/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.wso2event.internal.ds;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.Credentials;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.core.AgentCallback;
import org.wso2.carbon.databridge.core.DataBridgeSubscriberService;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterFactory;
import org.wso2.carbon.event.input.adapter.wso2event.WSO2EventAdapter;
import org.wso2.carbon.event.input.adapter.wso2event.WSO2EventEventAdapterFactory;
import org.wso2.carbon.event.input.adapter.wso2event.internal.ds.WSO2EventAdapterServiceValueHolder;

@Component(name="input.wso2EventAdapterService.component", immediate=true)
public class WSO2EventAdapterServiceDS {
    private static final Log log = LogFactory.getLog(WSO2EventAdapterServiceDS.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            WSO2EventEventAdapterFactory wso2EventEventAdapterFactory = new WSO2EventEventAdapterFactory();
            context.getBundleContext().registerService(InputEventAdapterFactory.class.getName(), (Object)wso2EventEventAdapterFactory, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully deployed the input WSO2Event adapter service");
            }
        }
        catch (RuntimeException e) {
            log.error((Object)"Can not create the input WSO2Event adapter service ", (Throwable)e);
        }
    }

    @Reference(name="agentserverservice.service", service=DataBridgeSubscriberService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unSetDataBridgeSubscriberService")
    protected void setDataBridgeSubscriberService(DataBridgeSubscriberService dataBridgeSubscriberService) {
        if (WSO2EventAdapterServiceValueHolder.getDataBridgeSubscriberService() == null) {
            WSO2EventAdapterServiceValueHolder.registerDataBridgeSubscriberService(dataBridgeSubscriberService);
            dataBridgeSubscriberService.subscribe(new AgentCallback(){

                public void definedStream(StreamDefinition streamDefinition, int i) {
                }

                public void removeStream(StreamDefinition streamDefinition, int i) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void receive(List<Event> events, Credentials credentials) {
                    try {
                        PrivilegedCarbonContext.startTenantFlow();
                        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(credentials.getTenantId());
                        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(credentials.getDomainName());
                        for (Event event : events) {
                            ConcurrentHashMap<String, WSO2EventAdapter> adapters = WSO2EventAdapterServiceValueHolder.getAdapterService(credentials.getDomainName(), event.getStreamId());
                            if (adapters != null) {
                                for (WSO2EventAdapter adapter : adapters.values()) {
                                    adapter.getEventAdaptorListener().onEvent((Object)event);
                                }
                            }
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Event received in wso2Event Adapter - " + event));
                        }
                    }
                    finally {
                        PrivilegedCarbonContext.endTenantFlow();
                    }
                }
            });
        }
    }

    protected void unSetDataBridgeSubscriberService(DataBridgeSubscriberService dataBridgeSubscriberService) {
    }
}

