/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.wso2event;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterFactory;
import org.wso2.carbon.event.input.adapter.core.Property;
import org.wso2.carbon.event.input.adapter.wso2event.WSO2EventAdapter;
import org.wso2.carbon.utils.CarbonUtils;

public class WSO2EventEventAdapterFactory
extends InputEventAdapterFactory {
    ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.event.input.adapter.wso2event.i18n.Resources", Locale.getDefault());
    private int thriftTCPPort;
    private int thriftSSLPort;
    private int binaryTCPPort;
    private int binarySSLPort;
    private int portOffset = this.getPortOffset();

    public WSO2EventEventAdapterFactory() {
        this.thriftTCPPort = 7611 + this.portOffset;
        this.thriftSSLPort = 7711 + this.portOffset;
        this.binaryTCPPort = 9611 + this.portOffset;
        this.binarySSLPort = 9711 + this.portOffset;
    }

    public String getType() {
        return "wso2event";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportInputMessageTypes = new ArrayList<String>();
        supportInputMessageTypes.add("wso2event");
        return supportInputMessageTypes;
    }

    public List<Property> getPropertyList() {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        Property isDuplicatedInCluster = new Property("events.duplicated.in.cluster");
        isDuplicatedInCluster.setDisplayName(this.resourceBundle.getString("events.duplicated.in.cluster"));
        isDuplicatedInCluster.setRequired(false);
        isDuplicatedInCluster.setHint(this.resourceBundle.getString("events.duplicated.in.cluster.hint"));
        isDuplicatedInCluster.setOptions(new String[]{"true", "false"});
        isDuplicatedInCluster.setDefaultValue("false");
        propertyList.add(isDuplicatedInCluster);
        return propertyList;
    }

    public String getUsageTips() {
        return this.resourceBundle.getString("wso2event.usage.tips_prefix") + this.thriftTCPPort + this.resourceBundle.getString("wso2event.usage.tips_in_between") + this.thriftSSLPort + this.resourceBundle.getString("wso2event.usage.tips_postfix") + this.binaryTCPPort + this.resourceBundle.getString("wso2event.usage.tips_in_between") + this.binarySSLPort;
    }

    public InputEventAdapter createEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new WSO2EventAdapter(eventAdapterConfiguration, globalProperties);
    }

    private int getPortOffset() {
        return CarbonUtils.getPortFromServerConfig((String)"Ports.Offset") + 1;
    }
}

