/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.wso2event;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterException;
import org.wso2.carbon.event.input.adapter.core.exception.TestConnectionNotSupportedException;
import org.wso2.carbon.event.input.adapter.wso2event.internal.ds.WSO2EventAdapterServiceValueHolder;

public final class WSO2EventAdapter
implements InputEventAdapter {
    private static final Log log = LogFactory.getLog(WSO2EventAdapter.class);
    private final InputEventAdapterConfiguration eventAdapterConfiguration;
    private final Map<String, String> globalProperties;
    private InputEventAdapterListener eventAdaptorListener;

    public WSO2EventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
    }

    public void init(InputEventAdapterListener eventAdaptorListener) throws InputEventAdapterException {
        this.eventAdaptorListener = eventAdaptorListener;
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        throw new TestConnectionNotSupportedException("not-supported");
    }

    public void connect() {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
        String streamId = this.eventAdapterConfiguration.getInputStreamIdOfWso2eventMessageFormat();
        WSO2EventAdapterServiceValueHolder.registerAdapterService(tenantDomain, streamId, this);
    }

    public void disconnect() {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
        String streamId = this.eventAdapterConfiguration.getInputStreamIdOfWso2eventMessageFormat();
        WSO2EventAdapterServiceValueHolder.unregisterAdapterService(tenantDomain, streamId, this);
    }

    public void destroy() {
    }

    public boolean isEventDuplicatedInCluster() {
        return Boolean.parseBoolean((String)this.eventAdapterConfiguration.getProperties().get("events.duplicated.in.cluster"));
    }

    public boolean isPolling() {
        return false;
    }

    public String getEventAdapterName() {
        return this.eventAdapterConfiguration.getName();
    }

    public InputEventAdapterListener getEventAdaptorListener() {
        return this.eventAdaptorListener;
    }
}

