/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.synchronizer.subversion.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class SVNFileChecksumResolverUtil {
    private static final Log log = LogFactory.getLog(SVNFileChecksumResolverUtil.class);
    private static final String CHECKSUM_FILENAME = "entries";
    private static final String CHECKSUM_TEMP_FILENAME = "tmp_entries";
    private static final String SVN_FOLDER = ".svn";

    public static void resolveChecksum(String errorMessage) {
        if (errorMessage.contains("Base checksum mismatch")) {
            int exIndex = errorMessage.indexOf("expected:");
            int acIndex = errorMessage.indexOf("actual:");
            int beginFile = errorMessage.indexOf("'", 0);
            int endFile = errorMessage.indexOf("'", beginFile + 1);
            int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            String axis2RepoPath = MultitenantUtils.getAxis2RepositoryPath((int)tenantId);
            if (axis2RepoPath.length() - 1 != axis2RepoPath.lastIndexOf(File.separator)) {
                axis2RepoPath = axis2RepoPath.concat(File.separator);
            }
            String expectedChecksum = errorMessage.substring(acIndex + 7, errorMessage.length() - 1);
            String actualChecksum = errorMessage.substring(exIndex + 9, acIndex);
            String filePath = errorMessage.substring(beginFile + 1, endFile);
            String svnFile = SVN_FOLDER + File.separator + CHECKSUM_FILENAME;
            String newSvnFile = SVN_FOLDER + File.separator + CHECKSUM_TEMP_FILENAME;
            int fileNameStartIndex = filePath.lastIndexOf(File.separatorChar) + 1;
            String svnPath = filePath.substring(0, fileNameStartIndex);
            String fullSvnFilePath = axis2RepoPath + svnPath + svnFile;
            String fulltmpFilePath = axis2RepoPath + svnPath + newSvnFile;
            File errorFile = new File(fullSvnFilePath);
            File tmpFile = new File(fulltmpFilePath);
            log.debug((Object)("Trying to correct the checksum mismatch for SVN file:" + fullSvnFilePath + ".Expected:" + expectedChecksum.trim() + " but it is:" + actualChecksum.trim()));
            try (FileReader fis = new FileReader(errorFile);
                 BufferedReader bis = new BufferedReader(new InputStreamReader(new FileInputStream(errorFile)));
                 BufferedWriter bw = new BufferedWriter(new FileWriter(tmpFile));){
                String line;
                while ((line = bis.readLine()) != null) {
                    String plainLine = line.trim();
                    if (plainLine.contains(actualChecksum.trim())) {
                        log.debug((Object)("Found checksum:" + actualChecksum.trim() + ". Will be replaced with:" + expectedChecksum.trim()));
                        bw.write(expectedChecksum.trim());
                    } else {
                        bw.write(line);
                    }
                    bw.newLine();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
            }
            if (errorFile.delete()) {
                log.debug((Object)("SVN file:" + fullSvnFilePath + " modifying."));
                if (tmpFile.renameTo(errorFile)) {
                    log.debug((Object)("SVN file:" + fullSvnFilePath + " update successful."));
                } else {
                    log.error((Object)("SVN file:" + fulltmpFilePath + " update failed. Please check file permissions and allow for modification."));
                }
            } else {
                log.error((Object)("SVN file:" + fullSvnFilePath + " unable to modify. Please check file permissions and allow for modification."));
                log.error((Object)"Unable to resolve checksum mismatch");
            }
        }
    }
}

