/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.receiver.binary.internal;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.wso2.carbon.databridge.commons.utils.DataBridgeThreadFactory;

public class BinaryDataReceiverThreadPoolExecutor
extends ThreadPoolExecutor {
    private final Semaphore semaphore;
    private AtomicBoolean isShutdown;

    public BinaryDataReceiverThreadPoolExecutor(int poolSize, String threadName) {
        super(poolSize, poolSize, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new DataBridgeThreadFactory(threadName));
        this.semaphore = new Semaphore(poolSize);
        this.isShutdown = new AtomicBoolean(false);
    }

    @Override
    public void execute(Runnable task) {
        boolean acquired = false;
        do {
            try {
                this.semaphore.acquire();
                acquired = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!acquired);
        if (!this.isShutdown.get()) {
            super.execute(task);
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        this.semaphore.release();
    }

    @Override
    public void shutdown() {
        this.isShutdown.set(true);
        super.shutdown();
    }
}

