/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.receiver.binary.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.core.ServerStartupObserver;
import org.wso2.carbon.databridge.core.DataBridgeReceiverService;
import org.wso2.carbon.databridge.receiver.binary.conf.BinaryDataReceiverConfiguration;
import org.wso2.carbon.databridge.receiver.binary.internal.BinaryDataReceiver;

@Component(name="binaryDataReceiver.component", immediate=true)
public class BinaryDataReceiverServiceComponent {
    private static final Log log = LogFactory.getLog(BinaryDataReceiverServiceComponent.class);
    private DataBridgeReceiverService dataBridgeReceiverService;
    private static final String DISABLE_RECEIVER = "disable.receiver";
    private BinaryDataReceiver binaryDataReceiver;

    @Activate
    protected void activate(ComponentContext context) {
        String disableReceiver = System.getProperty(DISABLE_RECEIVER);
        if (disableReceiver != null && Boolean.parseBoolean(disableReceiver)) {
            log.info((Object)"Receiver disabled.");
            return;
        }
        this.binaryDataReceiver = new BinaryDataReceiver(new BinaryDataReceiverConfiguration(this.dataBridgeReceiverService.getInitialConfig()), this.dataBridgeReceiverService);
        context.getBundleContext().registerService(ServerStartupObserver.class.getName(), (Object)this.binaryDataReceiver, null);
        log.info((Object)"Binary Data Receiver server activated");
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        log.info((Object)"Binary Data Receiver server shutting down...");
        this.binaryDataReceiver.stop();
    }

    @Reference(name="databridge.core", service=DataBridgeReceiverService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetDatabridgeReceiverService")
    protected void setDataBridgeReceiverService(DataBridgeReceiverService dataBridgeReceiverService) {
        this.dataBridgeReceiverService = dataBridgeReceiverService;
    }

    protected void unsetDatabridgeReceiverService(DataBridgeReceiverService dataBridgeReceiverService) {
        this.dataBridgeReceiverService = null;
    }
}

