/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.receiver.binary.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.util.concurrent.ExecutorService;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.ServerStartupObserver;
import org.wso2.carbon.databridge.commons.binary.BinaryMessageConverterUtil;
import org.wso2.carbon.databridge.core.DataBridgeReceiverService;
import org.wso2.carbon.databridge.core.EventConverter;
import org.wso2.carbon.databridge.core.exception.DataBridgeException;
import org.wso2.carbon.databridge.receiver.binary.BinaryEventConverter;
import org.wso2.carbon.databridge.receiver.binary.conf.BinaryDataReceiverConfiguration;
import org.wso2.carbon.databridge.receiver.binary.internal.BinaryDataReceiverThreadPoolExecutor;

public class BinaryDataReceiver
implements ServerStartupObserver {
    private static final Log log = LogFactory.getLog(BinaryDataReceiver.class);
    private DataBridgeReceiverService dataBridgeReceiverService;
    private BinaryDataReceiverConfiguration binaryDataReceiverConfiguration;
    private ExecutorService sslReceiverExecutorService;
    private ExecutorService tcpReceiverExecutorService;

    public BinaryDataReceiver(BinaryDataReceiverConfiguration binaryDataReceiverConfiguration, DataBridgeReceiverService dataBridgeReceiverService) {
        this.dataBridgeReceiverService = dataBridgeReceiverService;
        this.binaryDataReceiverConfiguration = binaryDataReceiverConfiguration;
        this.sslReceiverExecutorService = new BinaryDataReceiverThreadPoolExecutor(binaryDataReceiverConfiguration.getSizeOfSSLThreadPool(), "Receiver-Binary-SSL");
        this.tcpReceiverExecutorService = new BinaryDataReceiverThreadPoolExecutor(binaryDataReceiverConfiguration.getSizeOfTCPThreadPool(), "Receiver-Binary-TCP");
    }

    public void start() throws IOException, DataBridgeException {
        if (this.binaryDataReceiverConfiguration.isEnable()) {
            this.startSecureTransmission();
            this.startEventTransmission();
        }
    }

    public void stop() {
        if (this.binaryDataReceiverConfiguration.isEnable()) {
            log.info((Object)"Stopping Binary Server..");
            this.sslReceiverExecutorService.shutdown();
            this.tcpReceiverExecutorService.shutdown();
        }
    }

    private void startSecureTransmission() throws IOException, DataBridgeException {
        String trustManagerAlgorithm;
        String keyManagerAlgorithm;
        ServerConfiguration serverConfig;
        ServerConfiguration serverConfig2;
        String keyStore = this.dataBridgeReceiverService.getInitialConfig().getKeyStoreLocation();
        if (keyStore == null && (keyStore = (serverConfig2 = ServerConfiguration.getInstance()).getFirstProperty("Security.KeyStore.Location")) == null && (keyStore = System.getProperty("Security.KeyStore.Location")) == null) {
            throw new DataBridgeException("Cannot start binary agent server, not valid Security.KeyStore.Location is null");
        }
        String keyStorePassword = this.dataBridgeReceiverService.getInitialConfig().getKeyStorePassword();
        if (keyStorePassword == null && (keyStorePassword = (serverConfig = ServerConfiguration.getInstance()).getFirstProperty("Security.KeyStore.Password")) == null && (keyStorePassword = System.getProperty("Security.KeyStore.Password")) == null) {
            throw new DataBridgeException("Cannot start binary agent server, not valid Security.KeyStore.Password is null ");
        }
        System.setProperty("javax.net.ssl.keyStore", keyStore);
        System.setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
        String trustStore = System.getProperty("javax.net.ssl.trustStore");
        String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
        String trustStoreType = System.getProperty("javax.net.ssl.trustStoreType");
        String keystoreType = this.dataBridgeReceiverService.getInitialConfig().getKeyStoreType();
        if (StringUtils.isEmpty((String)keystoreType)) {
            keystoreType = KeyStore.getDefaultType();
        }
        if (StringUtils.isEmpty((String)(keyManagerAlgorithm = this.dataBridgeReceiverService.getInitialConfig().getKeyManagerType()))) {
            keyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        if (StringUtils.isEmpty((String)(trustManagerAlgorithm = this.dataBridgeReceiverService.getInitialConfig().getTrustManagerType()))) {
            trustManagerAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        }
        try {
            String ciphers;
            KeyStore ks = KeyStore.getInstance(keystoreType);
            ks.load(new FileInputStream(keyStore), keyStorePassword.toCharArray());
            KeyStore ts = KeyStore.getInstance(trustStoreType);
            ts.load(new FileInputStream(trustStore), trustStorePassword.toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerAlgorithm);
            keyManagerFactory.init(ks, keyStorePassword.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustManagerAlgorithm);
            trustManagerFactory.init(ts);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            SSLServerSocketFactory sslServerSocketFactory = context.getServerSocketFactory();
            SSLServerSocket sslserversocket = (SSLServerSocket)sslServerSocketFactory.createServerSocket(this.binaryDataReceiverConfiguration.getSSLPort());
            String sslProtocols = this.binaryDataReceiverConfiguration.getSslProtocols();
            if (sslProtocols != null && sslProtocols.length() != 0) {
                String[] sslProtocolsArray = sslProtocols.split(",");
                sslserversocket.setEnabledProtocols(sslProtocolsArray);
            }
            if ((ciphers = this.binaryDataReceiverConfiguration.getCiphers()) != null && ciphers.length() != 0) {
                String[] ciphersArray = ciphers.split(",");
                sslserversocket.setEnabledCipherSuites(ciphersArray);
            } else {
                sslserversocket.setEnabledCipherSuites(sslserversocket.getSupportedCipherSuites());
            }
            Thread thread = new Thread(new BinarySecureEventServerAcceptor(sslserversocket));
            thread.start();
            log.info((Object)("Started Binary SSL Transport on port : " + this.binaryDataReceiverConfiguration.getSSLPort()));
        }
        catch (Exception e) {
            throw new DataBridgeException("Error when starting binary agent server ", (Throwable)e);
        }
    }

    private void startEventTransmission() throws IOException {
        ServerSocketFactory serversocketfactory = ServerSocketFactory.getDefault();
        ServerSocket serversocket = serversocketfactory.createServerSocket(this.binaryDataReceiverConfiguration.getTCPPort());
        Thread thread = new Thread(new BinaryEventServerAcceptor(serversocket));
        thread.start();
        log.info((Object)("Started Binary TCP Transport on port : " + this.binaryDataReceiverConfiguration.getTCPPort()));
    }

    public void completingServerStartup() {
        try {
            this.start();
        }
        catch (IOException e) {
            log.error((Object)"Error when creating the server socket ", (Throwable)e);
        }
        catch (DataBridgeException e) {
            log.error((Object)"Error while starting binary data receiver ", (Throwable)e);
        }
    }

    public void completedServerStartup() {
    }

    private String processMessage(int messageType, byte[] message, OutputStream outputStream) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(message);
        switch (messageType) {
            case 0: {
                int userNameLength = byteBuffer.getInt();
                int passwordLength = byteBuffer.getInt();
                String userName = new String(message, 8, userNameLength);
                String password = new String(message, 8 + userNameLength, passwordLength);
                try {
                    String sessionId = this.dataBridgeReceiverService.login(userName, password);
                    ByteBuffer buffer = ByteBuffer.allocate(5 + sessionId.length());
                    buffer.put((byte)2);
                    buffer.putInt(sessionId.length());
                    buffer.put(sessionId.getBytes("UTF-8"));
                    outputStream.write(buffer.array());
                    outputStream.flush();
                }
                catch (Exception e) {
                    try {
                        this.sendError(e, outputStream);
                    }
                    catch (IOException e1) {
                        log.error((Object)("Error while sending response for login message: " + e1.getMessage()), (Throwable)e1);
                    }
                }
                break;
            }
            case 1: {
                int sessionIdLength = byteBuffer.getInt();
                String sessionId = new String(message, 4, sessionIdLength);
                try {
                    this.dataBridgeReceiverService.logout(sessionId);
                    outputStream.write(0);
                    outputStream.flush();
                }
                catch (Exception e) {
                    try {
                        this.sendError(e, outputStream);
                    }
                    catch (IOException e1) {
                        log.error((Object)("Error while sending response for login message: " + e1.getMessage()), (Throwable)e1);
                    }
                }
                break;
            }
            case 2: {
                int sessionIdLength = byteBuffer.getInt();
                String sessionId = new String(message, 4, sessionIdLength);
                try {
                    this.dataBridgeReceiverService.publish((Object)message, sessionId, (EventConverter)BinaryEventConverter.getConverter());
                    outputStream.write(0);
                    outputStream.flush();
                }
                catch (Exception e) {
                    try {
                        this.sendError(e, outputStream);
                    }
                    catch (IOException e1) {
                        log.error((Object)("Error while sending response for login message: " + e1.getMessage()), (Throwable)e1);
                    }
                }
                break;
            }
            default: {
                log.error((Object)("Message Type " + messageType + " is not supported!"));
            }
        }
        return null;
    }

    private void sendError(Exception e, OutputStream outputStream) throws IOException {
        int errorClassNameLength = e.getClass().getCanonicalName().length();
        int errorMsgLength = e.getMessage().length();
        ByteBuffer bbuf = ByteBuffer.wrap(new byte[8]);
        bbuf.putInt(errorClassNameLength);
        bbuf.putInt(errorMsgLength);
        outputStream.write(1);
        outputStream.write(bbuf.array());
        outputStream.write(e.getClass().getCanonicalName().getBytes("UTF-8"));
        outputStream.write(e.getMessage().getBytes("UTF-8"));
        outputStream.flush();
    }

    public class BinaryTransportReceiver
    implements Runnable {
        private Socket socket;

        public BinaryTransportReceiver(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            try {
                BufferedInputStream inputstream = new BufferedInputStream(this.socket.getInputStream());
                BufferedOutputStream outputStream = new BufferedOutputStream(this.socket.getOutputStream());
                int messageType = ((InputStream)inputstream).read();
                while (messageType != -1) {
                    int messageSize = ByteBuffer.wrap(BinaryMessageConverterUtil.loadData((InputStream)inputstream, (byte[])new byte[4])).getInt();
                    byte[] message = BinaryMessageConverterUtil.loadData((InputStream)inputstream, (byte[])new byte[messageSize]);
                    BinaryDataReceiver.this.processMessage(messageType, message, outputStream);
                    messageType = ((InputStream)inputstream).read();
                }
            }
            catch (IOException ex) {
                log.error((Object)"Error while reading from the socket. ", (Throwable)ex);
            }
        }
    }

    public class BinaryEventServerAcceptor
    implements Runnable {
        private ServerSocket serverSocket;

        public BinaryEventServerAcceptor(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Socket socket = this.serverSocket.accept();
                        BinaryDataReceiver.this.tcpReceiverExecutorService.submit(new BinaryTransportReceiver(socket));
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Error while accepting the connection. ", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    public class BinarySecureEventServerAcceptor
    implements Runnable {
        private ServerSocket serverSocket;

        public BinarySecureEventServerAcceptor(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Socket socket = this.serverSocket.accept();
                        BinaryDataReceiver.this.sslReceiverExecutorService.submit(new BinaryTransportReceiver(socket));
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Error while accepting the connection. ", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

