/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.receiver.binary.conf;

import org.wso2.carbon.databridge.core.conf.DataBridgeConfiguration;
import org.wso2.carbon.databridge.core.conf.DataReceiver;
import org.wso2.carbon.utils.CarbonUtils;

public class BinaryDataReceiverConfiguration {
    private boolean enable = true;
    private int sslPort;
    private int tcpPort;
    private int sizeOfSSLThreadPool;
    private int sizeOfTCPThreadPool;
    private String sslProtocols;
    private String ciphers;

    public BinaryDataReceiverConfiguration(int sslPort, int tcpPort) {
        this.sslPort = sslPort;
        this.tcpPort = tcpPort;
        this.sizeOfSSLThreadPool = 100;
        this.sizeOfTCPThreadPool = 100;
    }

    public BinaryDataReceiverConfiguration(DataBridgeConfiguration dataBridgeConfiguration) {
        DataReceiver dataReceiver = dataBridgeConfiguration.getDataReceiver("Binary");
        this.sslPort = Integer.parseInt(dataReceiver.getConfiguration("sslPort", (Object)9611).toString()) + BinaryDataReceiverConfiguration.getPortOffset();
        this.tcpPort = Integer.parseInt(dataReceiver.getConfiguration("tcpPort", (Object)9711).toString()) + BinaryDataReceiverConfiguration.getPortOffset();
        this.sizeOfSSLThreadPool = Integer.parseInt(dataReceiver.getConfiguration("sslReceiverThreadPoolSize", (Object)100).toString());
        this.sizeOfTCPThreadPool = Integer.parseInt(dataReceiver.getConfiguration("tcpReceiverThreadPoolSize", (Object)100).toString());
        this.enable = Boolean.valueOf(dataReceiver.getConfiguration("enable", (Object)this.enable).toString());
        Object sslProtocolObj = dataReceiver.getConfiguration("sslEnabledProtocols", null);
        this.sslProtocols = sslProtocolObj != null ? sslProtocolObj.toString() : null;
        Object ciphersObj = dataReceiver.getConfiguration("ciphers", null);
        this.ciphers = sslProtocolObj != null ? ciphersObj.toString() : null;
    }

    public int getSSLPort() {
        return this.sslPort;
    }

    public int getTCPPort() {
        return this.tcpPort;
    }

    public int getSizeOfTCPThreadPool() {
        return this.sizeOfTCPThreadPool;
    }

    public int getSizeOfSSLThreadPool() {
        return this.sizeOfSSLThreadPool;
    }

    private static int getPortOffset() {
        return CarbonUtils.getPortFromServerConfig((String)"Ports.Offset") + 1;
    }

    public String getSslProtocols() {
        return this.sslProtocols;
    }

    public String getCiphers() {
        return this.ciphers;
    }

    public boolean isEnable() {
        return this.enable;
    }
}

