/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.receiver.binary;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.binary.BinaryMessageConverterUtil;
import org.wso2.carbon.databridge.commons.exception.MalformedEventException;
import org.wso2.carbon.databridge.core.EventConverter;
import org.wso2.carbon.databridge.core.StreamTypeHolder;
import org.wso2.carbon.databridge.core.exception.EventConversionException;

public class BinaryEventConverter
implements EventConverter {
    private static BinaryEventConverter instance = new BinaryEventConverter();

    private BinaryEventConverter() {
    }

    public List<Event> toEventList(Object eventBundle, StreamTypeHolder streamTypeHolder) {
        ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])eventBundle);
        int sessionIdSize = byteBuffer.getInt();
        byteBuffer.get(new byte[sessionIdSize]);
        int events = byteBuffer.getInt();
        ArrayList<Event> eventList = new ArrayList<Event>();
        for (int i = 0; i < events; ++i) {
            int eventSize = byteBuffer.getInt();
            byte[] bytes = new byte[eventSize];
            byteBuffer.get(bytes);
            ByteBuffer eventByteBuffer = ByteBuffer.wrap(bytes);
            eventList.add(this.getEvent(eventByteBuffer, streamTypeHolder));
        }
        return eventList;
    }

    public int getSize(Object eventBundle) {
        return ((byte[])eventBundle).length;
    }

    public int getNumberOfEvents(Object eventBundle) {
        ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])eventBundle);
        int sessionIdSize = byteBuffer.getInt();
        byteBuffer.get(new byte[sessionIdSize]);
        return byteBuffer.getInt();
    }

    public Event getEvent(ByteBuffer byteBuffer, StreamTypeHolder streamTypeHolder) throws MalformedEventException {
        long timeStamp = byteBuffer.getLong();
        int streamIdSize = byteBuffer.getInt();
        String streamId = BinaryMessageConverterUtil.getString((ByteBuffer)byteBuffer, (int)streamIdSize);
        Event event = new Event();
        event.setStreamId(streamId);
        event.setTimeStamp(timeStamp);
        AttributeType[][] attributeTypeOrder = streamTypeHolder.getDataType(event.getStreamId());
        if (attributeTypeOrder == null) {
            PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            if (privilegedCarbonContext.getTenantDomain() == null) {
                privilegedCarbonContext.setTenantDomain("carbon.super");
                privilegedCarbonContext.setTenantId(-1234);
            }
            streamTypeHolder.reloadStreamTypeHolder();
            attributeTypeOrder = streamTypeHolder.getDataType(event.getStreamId());
            if (attributeTypeOrder == null) {
                throw new EventConversionException("No StreamDefinition for streamId " + event.getStreamId() + " present in cache ");
            }
        }
        event.setMetaData(this.toObjectArray(byteBuffer, attributeTypeOrder[0], "Meta Data"));
        event.setCorrelationData(this.toObjectArray(byteBuffer, attributeTypeOrder[1], "Correlation Data"));
        event.setPayloadData(this.toObjectArray(byteBuffer, attributeTypeOrder[2], "Payload Data"));
        event.setArbitraryDataMap(this.toStringMap(byteBuffer));
        return event;
    }

    public Object[] toObjectArray(ByteBuffer byteBuffer, AttributeType[] attributeTypeOrder, String type) {
        if (attributeTypeOrder != null) {
            if (byteBuffer == null) {
                throw new MalformedEventException("Expected event attribute type: " + type + " but it's is missing in the event");
            }
            Object[] objects = new Object[attributeTypeOrder.length];
            block8: for (int i = 0; i < attributeTypeOrder.length; ++i) {
                switch (attributeTypeOrder[i]) {
                    case INT: {
                        objects[i] = byteBuffer.getInt();
                        continue block8;
                    }
                    case LONG: {
                        objects[i] = byteBuffer.getLong();
                        continue block8;
                    }
                    case STRING: {
                        int stringSize = byteBuffer.getInt();
                        if (stringSize == 0) {
                            objects[i] = null;
                            continue block8;
                        }
                        objects[i] = BinaryMessageConverterUtil.getString((ByteBuffer)byteBuffer, (int)stringSize);
                        continue block8;
                    }
                    case DOUBLE: {
                        objects[i] = byteBuffer.getDouble();
                        continue block8;
                    }
                    case FLOAT: {
                        objects[i] = Float.valueOf(byteBuffer.getFloat());
                        continue block8;
                    }
                    case BOOL: {
                        objects[i] = byteBuffer.get() == 1;
                    }
                }
            }
            return objects;
        }
        return null;
    }

    public Map<String, String> toStringMap(ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            HashMap<String, String> eventProps = new HashMap<String, String>();
            while (byteBuffer.remaining() > 0) {
                int keySize = byteBuffer.getInt();
                String key = BinaryMessageConverterUtil.getString((ByteBuffer)byteBuffer, (int)keySize);
                int valueSize = byteBuffer.getInt();
                String value = BinaryMessageConverterUtil.getString((ByteBuffer)byteBuffer, (int)valueSize);
                eventProps.put(key, value);
            }
            return eventProps;
        }
        return null;
    }

    public static BinaryEventConverter getConverter() {
        return instance;
    }
}

