/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.h2.osgi.console;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.h2.Driver;
import org.h2.engine.Database;
import org.h2.engine.Engine;
import org.wso2.carbon.h2.osgi.console.ConsoleService;
import org.wso2.carbon.h2.osgi.utils.CarbonUtils;

public class H2DatabaseManager {
    private static H2DatabaseManager instance;
    private static final Log log;
    private ConsoleService console;

    private H2DatabaseManager() {
    }

    public static synchronized H2DatabaseManager getInstance() {
        if (instance == null) {
            instance = new H2DatabaseManager();
        }
        return instance;
    }

    public void initialize() throws SQLException {
        Driver.load();
        this.startH2Server();
    }

    public void terminate() {
        this.stopH2Server();
        this.closeAllOpenDatabases();
    }

    private void closeAllOpenDatabases() {
        Field[] f;
        Engine s = Engine.getInstance();
        for (Field var : f = s.getClass().getDeclaredFields()) {
            if (var.getType() != HashMap.class || !var.getName().equals("DATABASES")) continue;
            var.setAccessible(true);
            Object pass = new Object();
            try {
                Object fieldValue = var.get(pass);
                if (fieldValue.getClass() != HashMap.class) continue;
                HashMap DATABASES = (HashMap)fieldValue;
                ArrayList<Database> openDatabases = new ArrayList<Database>();
                for (Database database : DATABASES.values()) {
                    openDatabases.add(database);
                }
                for (Database database : openDatabases) {
                    Method declaredMethod = null;
                    try {
                        declaredMethod = database.getClass().getDeclaredMethod("close", Boolean.TYPE);
                        if (declaredMethod != null) {
                            declaredMethod.setAccessible(true);
                            declaredMethod.invoke((Object)database, true);
                            continue;
                        }
                        log.error((Object)("Database close method not found in class " + database.getClass().getName()));
                    }
                    catch (SecurityException e) {
                        log.error((Object)"H2", (Throwable)e);
                    }
                    catch (NoSuchMethodException e) {
                        log.error((Object)"H2", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        log.error((Object)"H2", (Throwable)e);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                log.error((Object)"H2", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"H2", (Throwable)e);
            }
        }
    }

    public void startH2Server() throws SQLException {
        if (this.console == null) {
            this.console = new ConsoleService();
        } else if (this.console.isServerRunning()) {
            this.stopH2Server();
        }
        this.console.runTool(this.getH2Parameters());
    }

    public void stopH2Server() {
        if (this.console != null && this.console.isServerRunning()) {
            this.console.shutdown();
        }
    }

    private String[] getH2Parameters() {
        ArrayList<String> parameterList = new ArrayList<String>();
        Map parameters = CarbonUtils.getH2Parameters();
        for (String paraName : parameters.keySet()) {
            parameterList.add("-" + paraName);
            if (parameters.get(paraName) == null || parameters.get(paraName).equals("")) continue;
            String value = parameters.get(paraName).toString();
            parameterList.add(value);
        }
        return parameterList.toArray(new String[0]);
    }

    static {
        log = LogFactory.getLog(H2DatabaseManager.class);
    }
}

