/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.apache.ws.commons.schema.utils.PrefixCollector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NodeNamespaceContext
implements NamespacePrefixList,
Serializable {
    private static final Collection XML_NS_PREFIX_COLLECTION = Collections.singletonList("xml");
    private static final Collection XMLNS_ATTRIBUTE_COLLECTION = Collections.singletonList("xmlns");
    private static final boolean DOM_LEVEL_3;
    private final Map declarations;
    private String[] prefixes;
    static /* synthetic */ Class class$org$w3c$dom$Node;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    private NodeNamespaceContext(Map decls) {
        this.declarations = decls;
    }

    public static String getNamespacePrefix(Element el, String ns) {
        if (DOM_LEVEL_3) {
            return NodeNamespaceContext.getNamespacePrefixDomLevel3(el, ns);
        }
        return NodeNamespaceContext.getNamespaceContext(el).getPrefix(ns);
    }

    private static String getNamespacePrefixDomLevel3(Element el, String ns) {
        return el.lookupPrefix(ns);
    }

    public static String getNamespaceURI(Element el, String pfx) {
        if ("xml".equals(pfx)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(pfx)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (DOM_LEVEL_3) {
            return NodeNamespaceContext.getNamespaceURIDomLevel3(el, pfx);
        }
        return NodeNamespaceContext.getNamespaceContext(el).getNamespaceURI(pfx);
    }

    private static String getNamespaceURIDomLevel3(Element el, String pfx) {
        if ("".equals(pfx)) {
            pfx = null;
        }
        return el.lookupNamespaceURI(pfx);
    }

    public static NodeNamespaceContext getNamespaceContext(Node pNode) {
        final HashMap declarations = new HashMap();
        new PrefixCollector(){

            protected void declare(String pPrefix, String pNamespaceURI) {
                declarations.put(pPrefix, pNamespaceURI);
            }
        }.searchAllPrefixDeclarations(pNode);
        return new NodeNamespaceContext(declarations);
    }

    public String getNamespaceURI(String pPrefix) {
        if (pPrefix == null) {
            throw new IllegalArgumentException("The prefix must not be null.");
        }
        if ("xml".equals(pPrefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(pPrefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        String uri = (String)this.declarations.get(pPrefix);
        return uri == null ? "" : uri;
    }

    public String getPrefix(String pNamespaceURI) {
        if (pNamespaceURI == null) {
            throw new IllegalArgumentException("The namespace URI must not be null.");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(pNamespaceURI)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(pNamespaceURI)) {
            return "xmlns";
        }
        Iterator iter = this.declarations.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!pNamespaceURI.equals(entry.getValue())) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public Iterator getPrefixes(String pNamespaceURI) {
        if (pNamespaceURI == null) {
            throw new IllegalArgumentException("The namespace URI must not be null.");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(pNamespaceURI)) {
            return XML_NS_PREFIX_COLLECTION.iterator();
        }
        if ("http://www.w3.org/2000/xmlns/".equals(pNamespaceURI)) {
            return XMLNS_ATTRIBUTE_COLLECTION.iterator();
        }
        ArrayList list = new ArrayList();
        Iterator iter = this.declarations.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!pNamespaceURI.equals(entry.getValue())) continue;
            list.add(entry.getKey());
        }
        return list.iterator();
    }

    public String[] getDeclaredPrefixes() {
        if (this.prefixes == null) {
            Set keys = this.declarations.keySet();
            this.prefixes = keys.toArray(new String[keys.size()]);
        }
        return this.prefixes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        boolean level3 = false;
        try {
            Class<?> cls = Class.forName("org.w3c.dom.UserDataHandler", false, (class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = NodeNamespaceContext.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node).getClassLoader());
            (class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = NodeNamespaceContext.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node).getMethod("getUserData", class$java$lang$String == null ? (class$java$lang$String = NodeNamespaceContext.class$("java.lang.String")) : class$java$lang$String);
            (class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = NodeNamespaceContext.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node).getMethod("setUserData", class$java$lang$String == null ? (class$java$lang$String = NodeNamespaceContext.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = NodeNamespaceContext.class$("java.lang.Object")) : class$java$lang$Object, cls);
            level3 = true;
        }
        catch (Throwable e) {
            level3 = false;
        }
        DOM_LEVEL_3 = level3;
    }
}

