/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.registry;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.OMDocumentImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.registry.AbstractRegistry;
import org.apache.synapse.registry.RegistryEntry;
import org.apache.synapse.util.SynapseBinaryDataSource;
import org.wso2.carbon.mediation.registry.MediationRegistryEntryImpl;
import org.wso2.carbon.mediation.registry.RegistryHelper;

public class MicroIntegratorRegistry
extends AbstractRegistry {
    private static final Log log = LogFactory.getLog(MicroIntegratorRegistry.class);
    private static final int DELETE_RETRY_SLEEP_TIME = 10;
    private static final long DEFAULT_CACHABLE_DURATION = 0L;
    private static final int MAX_KEYS = 200;
    private static final String METADATA_DIR_NAME = ".metadata";
    private static final String METADATA_FILE_SUFFIX = ".meta";
    private static final String METADATA_KEY_MEDIA_TYPE = "mediaType";
    public static final int FILE = 1;
    public static final int HTTP = 2;
    public static final int HTTPS = 3;
    private String localRegistry;
    private String configRegistry;
    private String govRegistry;
    private int registryType = 100;
    private int registryProtocol = 1;

    public MicroIntegratorRegistry() {
        String defaultFSRegRoot = RegistryHelper.getHome().replace(File.separator, "/");
        if (!defaultFSRegRoot.endsWith("/")) {
            defaultFSRegRoot = defaultFSRegRoot + "/";
        }
        defaultFSRegRoot = defaultFSRegRoot + "registry/";
        this.localRegistry = this.getUri(defaultFSRegRoot, "local");
        this.configRegistry = this.getUri(defaultFSRegRoot, "config");
        this.govRegistry = this.getUri(defaultFSRegRoot, "governance");
    }

    private String getUri(String defaultFSRegRoot, String subDirectory) {
        return Paths.get(defaultFSRegRoot + subDirectory, new String[0]).toUri().normalize().toString() + "/";
    }

    public void init(Properties properties) {
        super.init(properties);
        for (Object o : properties.keySet()) {
            if (o == null) continue;
            String name = (String)o;
            String value = (String)properties.get(name);
            this.addConfigProperty(name, value);
        }
        log.debug((Object)"EI lightweight registry is initialized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMNode lookup(String key) {
        URLConnection urlConnection;
        if (log.isDebugEnabled()) {
            log.debug((Object)("==> Repository fetch of resource with key : " + key));
        }
        String resolvedRegKeyPath = this.resolveRegistryURI(key);
        URL url = null;
        try {
            url = new URL(resolvedRegKeyPath);
        }
        catch (MalformedURLException e) {
            this.handleException("Invalid path '" + resolvedRegKeyPath + "' for URL", e);
        }
        if (url == null) {
            this.handleException("Unable to create URL for target resource : " + key);
        }
        if ("file".equals(url.getProtocol())) {
            try {
                url.openStream();
            }
            catch (IOException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Error occurred while accessing registry resource: " + key), (Throwable)e);
                }
                return null;
            }
        }
        try {
            urlConnection = url.openConnection();
            urlConnection.connect();
        }
        catch (IOException e) {
            return null;
        }
        InputStream input = null;
        try {
            input = urlConnection.getInputStream();
        }
        catch (IOException e) {
            this.handleException("Error when getting a stream from the URL", e);
        }
        if (input == null) {
            return null;
        }
        BufferedInputStream inputStream = new BufferedInputStream(input);
        OMElement result = null;
        try {
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            result = builder.getDocumentElement();
        }
        catch (XMLStreamException | OMException ignored) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The resource at the provided URL isn't well-formed XML,So,takes it as a text");
            }
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error((Object)"Error in closing the input stream. ", (Throwable)e);
            }
            try {
                result = this.readNonXML(url);
            }
            catch (IOException e) {
                log.error((Object)"Error occurred while retrieving text content from registry artifact", (Throwable)e);
                result = null;
            }
        }
        finally {
            try {
                if (result != null && result.getParent() != null) {
                    result.detach();
                    OMDocumentImpl parent = new OMDocumentImpl(OMAbstractFactory.getOMFactory());
                    parent.addChild((OMNode)result);
                }
                inputStream.close();
            }
            catch (IOException e) {
                log.error((Object)"Error in closing the input stream.", (Throwable)e);
            }
        }
        return result;
    }

    public boolean isResourceExists(String key) {
        String resolvedRegKeyPath = this.resolveRegistryURI(key);
        try {
            File file = new File(new URL(resolvedRegKeyPath).getFile());
            return file.exists();
        }
        catch (MalformedURLException e) {
            log.error((Object)("Error in fetching resource: " + key), (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties lookupProperties(String key) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("==> Repository fetch of resource with key : " + key));
        }
        String resolvedRegKeyPath = this.resolveRegistryURI(key);
        Properties result = new Properties();
        URL url = null;
        try {
            resolvedRegKeyPath = this.getPropertyFileURI(resolvedRegKeyPath);
            url = new URL(resolvedRegKeyPath);
        }
        catch (MalformedURLException e) {
            this.handleException("Invalid path '" + resolvedRegKeyPath + "' for URL", e);
        }
        if (url == null) {
            this.handleException("Unable to create URL for target resource : " + key);
        }
        if ("file".equals(url.getProtocol())) {
            try {
                url.openStream();
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) return null;
                log.debug((Object)("Error occurred while accessing registry resource: " + key), (Throwable)e);
                return null;
            }
        }
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.connect();
            try (InputStream input = urlConnection.getInputStream();){
                if (input == null) {
                    Properties properties = null;
                    return properties;
                }
                result.load(input);
                return result;
            }
        }
        catch (IOException e) {
            log.error((Object)"Error in loading properties", (Throwable)e);
            return null;
        }
    }

    private String getPropertyFileURI(String originalURL) throws MalformedURLException {
        boolean isDirectory = new File(new URL(originalURL = originalURL.trim()).getFile()).isDirectory();
        if (!isDirectory) {
            if (originalURL.endsWith("/")) {
                originalURL = originalURL.substring(0, originalURL.length() - 1);
            }
            return originalURL + ".properties";
        }
        String[] pathSegments = originalURL.split("/");
        String folderName = pathSegments[pathSegments.length - 1];
        if (originalURL.endsWith("/")) {
            return originalURL + folderName + ".properties";
        }
        return originalURL + "/" + folderName + ".properties";
    }

    public RegistryEntry getRegistryEntry(String key) {
        MediationRegistryEntryImpl entryEmbedded = new MediationRegistryEntryImpl();
        try {
            URL url = new URL(this.resolveRegistryURI(key));
            if ("file".equals(url.getProtocol())) {
                try {
                    url.openStream();
                }
                catch (IOException e) {
                    log.error((Object)("Error occurred while accessing registry resource: " + key), (Throwable)e);
                    return null;
                }
            }
            URLConnection urlc = url.openConnection();
            entryEmbedded.setKey(key);
            entryEmbedded.setName(url.getFile());
            entryEmbedded.setType("http://wso2.org/projects/esb/registry/types/file");
            entryEmbedded.setDescription("Resource at : " + url.toString());
            entryEmbedded.setLastModified(urlc.getLastModified());
            entryEmbedded.setVersion(urlc.getLastModified());
            if (urlc.getExpiration() > 0L) {
                entryEmbedded.setCachableDuration(urlc.getExpiration() - System.currentTimeMillis());
            } else {
                entryEmbedded.setCachableDuration(this.getCachableDuration());
            }
        }
        catch (MalformedURLException e) {
            this.handleException("Invalid URL reference " + this.resolveRegistryURI(key), e);
        }
        catch (IOException e) {
            this.handleException("IO Error reading from URL " + this.resolveRegistryURI(key), e);
        }
        return entryEmbedded;
    }

    public OMNode lookupFormat(String key) {
        return this.lookup(key);
    }

    public RegistryEntry[] getChildren(RegistryEntry entry) {
        if (entry == null) {
            MediationRegistryEntryImpl registryEntry = new MediationRegistryEntryImpl();
            registryEntry.setKey("local:/");
            entry = registryEntry;
        }
        String resourcePath = this.resolveRegistryURI(entry.getKey());
        String resourceRootEntry = entry.getKey();
        if (this.registryType == 100) {
            File file = null;
            try {
                file = new File(new URI(resourcePath));
            }
            catch (URISyntaxException e) {
                this.handleException(e.getMessage(), e);
            }
            if (file == null || !file.isDirectory()) {
                return null;
            }
            if (!resourceRootEntry.endsWith("/")) {
                resourceRootEntry = resourceRootEntry + "/";
            }
            String[] children = file.list();
            RegistryEntry[] entries = new RegistryEntry[children.length];
            for (int i = 0; i < children.length; ++i) {
                MediationRegistryEntryImpl registryEntry = new MediationRegistryEntryImpl();
                registryEntry.setKey(resourceRootEntry + children[i]);
                try {
                    File entryFile = new File(new URI(resourcePath + "/" + children[i]));
                    if (entryFile.isDirectory()) {
                        registryEntry.setType("http://wso2.org/projects/esb/registry/types/folder");
                    } else {
                        registryEntry.setType("http://wso2.org/projects/esb/registry/types/file");
                    }
                    entries[i] = registryEntry;
                    continue;
                }
                catch (URISyntaxException e) {
                    this.handleException("Error occurred while checking file type due to :" + e.getMessage(), e);
                }
            }
            return entries;
        }
        if (this.registryType == 101) {
            log.warn((Object)"Remote registry functionality not implemented yet");
        }
        return null;
    }

    public RegistryEntry[] getDescendants(RegistryEntry entry) {
        ArrayList<RegistryEntry> list = new ArrayList<RegistryEntry>();
        this.fillDescendants(entry, list);
        RegistryEntry[] descendants = new RegistryEntry[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            descendants[i] = list.get(i);
        }
        return descendants;
    }

    public void delete(String path) {
        if (this.registryType == 100) {
            this.removeResource(path);
        } else {
            log.warn((Object)("Deleting remote resources NOT SUPPORTED. Unable to delete: " + path));
        }
    }

    public void newResource(String path, boolean isDirectory) {
        if (this.registryType == 100) {
            String resolvedPath = this.resolveRegistryURI(path);
            if (isDirectory && !resolvedPath.endsWith("/")) {
                resolvedPath = resolvedPath + "/";
            }
            String parent = this.getParentPath(resolvedPath, isDirectory);
            String fileName = this.getResourceName(resolvedPath);
            try {
                this.addResource(parent, fileName, !isDirectory);
            }
            catch (Exception e) {
                this.handleException("Error when adding a new resource", e);
            }
        } else {
            log.warn((Object)("Creating new resources in remote registry is NOT SUPPORTED. Unable to create: " + path));
        }
    }

    public void newNonEmptyResource(String path, boolean isDirectory, String mediaType, String content, String propertyName) {
        if (this.registryType == 100) {
            String targetPath = this.resolveRegistryURI(path);
            if (isDirectory && !targetPath.endsWith("/")) {
                targetPath = targetPath + "/";
            }
            String parent = this.getParentPath(targetPath, isDirectory);
            String fileName = this.getResourceName(targetPath);
            Properties metadata = new Properties();
            if (mediaType != null) {
                metadata.setProperty(METADATA_KEY_MEDIA_TYPE, mediaType);
            }
            try {
                this.writeToFile(new URI(parent), fileName, content, metadata);
            }
            catch (Exception e) {
                this.handleException("Error when adding a new resource", e);
            }
        } else {
            log.warn((Object)("Creating new resource in remote registry is NOT SUPPORTED. Unable to create: " + path));
        }
    }

    public void updateResource(String path, Object value) {
        block18: {
            if (this.registryType == 100) {
                try {
                    File file = new File(new URI(this.resolveRegistryURI(path)));
                    if (!file.exists()) break block18;
                    try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                        writer.write(value.toString());
                        writer.flush();
                    }
                    catch (IOException e) {
                        this.handleException("Couldn't write to registry entry: " + path, e);
                    }
                }
                catch (URISyntaxException e) {
                    this.handleException("Error occurred while updating resource: " + path, e);
                }
            } else {
                log.warn((Object)("Updating remote registry is NOT SUPPORTED. Unable to update: " + path));
            }
        }
    }

    public void updateRegistryEntry(RegistryEntry entry) {
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, (Throwable)e);
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private long getCachableDuration() {
        String cachableDuration = (String)this.properties.get("cachableDuration");
        return cachableDuration == null ? 0L : Long.parseLong(cachableDuration);
    }

    private void fillDescendants(RegistryEntry parent, ArrayList<RegistryEntry> list) {
        RegistryEntry[] entries = this.getChildren(parent);
        if (entries != null) {
            for (RegistryEntry entry : entries) {
                if (list.size() <= 200) {
                    this.fillDescendants(entry, list);
                    continue;
                }
                break;
            }
        } else {
            list.add(parent);
        }
    }

    private void removeResource(String key) {
        try {
            File resource = new File(new URI(this.resolveRegistryURI(key)));
            if (resource.exists()) {
                if (resource.isFile()) {
                    this.deleteFile(resource);
                } else if (resource.isDirectory()) {
                    this.deleteDirectory(resource);
                }
            } else {
                this.handleException("Parent folder: " + key + " does not exists.");
            }
        }
        catch (URISyntaxException e) {
            this.handleException("Error occurred due to invalid URI while removing resource: " + key, e);
        }
    }

    private void deleteFile(File file) {
        boolean success = file.delete();
        if (!success) {
            System.gc();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                log.error((Object)"Sleep wait interrupted while waiting for second retry to delete registry resource", (Throwable)e);
            }
            success = file.delete();
            if (!success) {
                File renamedFile;
                int suffix = 1;
                File tempDir = new File("temp");
                if (!tempDir.exists()) {
                    tempDir.mkdir();
                }
                do {
                    String changedName = "d" + suffix + file.getName();
                    renamedFile = new File(tempDir, changedName);
                    ++suffix;
                } while (renamedFile.exists());
                if (file.renameTo(renamedFile)) {
                    renamedFile.deleteOnExit();
                } else {
                    this.handleException("Cannot delete the resource: " + file.getName());
                }
            }
        }
    }

    private void deleteDirectory(File dir) {
        File[] children;
        for (File child : children = dir.listFiles()) {
            if (child == null) continue;
            if (child.isFile()) {
                this.deleteFile(child);
                continue;
            }
            if (!child.isDirectory()) continue;
            this.deleteDirectory(child);
        }
        boolean success = dir.delete();
        if (!success) {
            this.handleException("Unable to delete the resource: " + dir.getName());
        }
    }

    private String getParentPath(String resourcePath, boolean isDirectory) {
        if (resourcePath != null) {
            String tempPath = resourcePath;
            if (isDirectory) {
                tempPath = resourcePath.substring(0, resourcePath.lastIndexOf("/"));
            }
            return tempPath.substring(0, tempPath.lastIndexOf("/"));
        }
        return "";
    }

    private String getResourceName(String path) {
        if (path != null) {
            String correctedPath = path;
            if (path.endsWith("/")) {
                correctedPath = path.substring(0, path.lastIndexOf("/"));
            }
            return correctedPath.substring(correctedPath.lastIndexOf("/") + 1, correctedPath.length());
        }
        return "";
    }

    private void addResource(String parentName, String resourceName, boolean isLeaf) throws Exception {
        if (isLeaf) {
            this.createFile(new URI(parentName), resourceName);
        } else {
            this.createFolder(new URI(parentName), resourceName);
        }
    }

    private void createFile(URI parentName, String newFileName) throws Exception {
        File newFile;
        File parent = new File(parentName);
        if (!parent.exists() && !parent.mkdirs()) {
            this.handleException("Unable to create parent directory: " + parentName);
        }
        if (!(newFile = new File(parent, newFileName)).createNewFile()) {
            this.handleException("Couldn't create resource: " + newFileName);
        }
    }

    private void writeToFile(URI parentName, String newFileName, String content, Properties metadata) {
        File parent = new File(parentName);
        if (!parent.exists() && !parent.mkdirs()) {
            this.handleException("Unable to create parent directory: " + parentName);
        }
        File newFile = new File(parent, newFileName);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(newFile));){
            writer.write(content);
            writer.flush();
            this.writeMetadata(parent, newFileName, metadata);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully content written to file : " + parentName + "/" + newFileName));
            }
        }
        catch (IOException e) {
            this.handleException("Couldn't write to registry resource: " + parentName + "/" + newFileName, e);
        }
    }

    private void writeMetadata(File parent, String resourceFileName, Properties metadata) {
        File metadataDir = new File(parent, METADATA_DIR_NAME);
        if (!metadataDir.exists() && !metadataDir.mkdirs()) {
            this.handleException("Unable to create metadata directory: " + metadataDir.getPath());
        }
        File newMetadataFile = new File(metadataDir, resourceFileName + METADATA_FILE_SUFFIX);
        try (BufferedWriter metadataWriter = new BufferedWriter(new FileWriter(newMetadataFile));){
            metadata.store(metadataWriter, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully written metadata to file: " + newMetadataFile.getPath()));
            }
        }
        catch (IOException e) {
            this.handleException("Couldn't write to metadata file: " + newMetadataFile.getPath(), e);
        }
    }

    private void createFolder(URI parentName, String newFolderName) throws Exception {
        File parent = new File(parentName);
        if (parent.exists() || parent.mkdirs()) {
            File newEntry = new File(parent, newFolderName);
            boolean success = newEntry.mkdir();
            if (!success) {
                this.handleException("Couldn't create folder: " + newFolderName);
            }
        } else {
            this.handleException("Parent folder: " + parentName + " cannot be created.");
        }
    }

    private String resolveRegistryURI(String key) {
        String resolvedPath = null;
        if (key != null || !key.isEmpty()) {
            String registryRoot = "";
            String resourcePath = "";
            if (key.startsWith("conf:")) {
                registryRoot = this.configRegistry;
                resourcePath = key.substring("conf:".length());
            } else if (key.startsWith("gov:")) {
                registryRoot = this.govRegistry;
                resourcePath = key.substring("gov:".length());
            } else if (key.startsWith("local:")) {
                registryRoot = this.localRegistry;
                resourcePath = key.substring("local:".length());
            } else {
                registryRoot = this.govRegistry;
                resourcePath = key;
            }
            if (resourcePath.startsWith("/")) {
                resourcePath = resourcePath.substring(1);
            }
            resolvedPath = registryRoot + resourcePath;
        }
        return resolvedPath;
    }

    private OMNode readNonXML(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        urlConnection.connect();
        try (InputStream inputStream = urlConnection.getInputStream();){
            if (inputStream == null) {
                OMNode oMNode = null;
                return oMNode;
            }
            Properties metadata = this.getMetadata(url.getPath());
            String mediaType = metadata.getProperty(METADATA_KEY_MEDIA_TYPE, "text/plain");
            if ("text/plain".equals(mediaType)) {
                StringBuilder strBuilder = new StringBuilder();
                try (BufferedReader bReader = new BufferedReader(new InputStreamReader(inputStream));){
                    String line;
                    while ((line = bReader.readLine()) != null) {
                        strBuilder.append(line);
                    }
                }
                OMText oMText = OMAbstractFactory.getOMFactory().createOMText(strBuilder.toString());
                return oMText;
            }
            OMText oMText = OMAbstractFactory.getOMFactory().createOMText((Object)new DataHandler((DataSource)new SynapseBinaryDataSource(inputStream, mediaType)), true);
            return oMText;
        }
    }

    private void addConfigProperty(String name, String value) {
        if (name != null && value != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processing registry configuration property : [Name: " + name + " Value: " + value + "]"));
            }
            if (name.equals("ConfigRegRoot") || name.equals("GovRegRoot") || name.equals("LocalRegRoot")) {
                try {
                    URL rootPathUrl = new URL(value);
                    if ("file".equals(rootPathUrl.getProtocol())) {
                        this.registryProtocol = 1;
                        this.registryType = 100;
                        try {
                            rootPathUrl.openStream();
                        }
                        catch (IOException e) {
                            String pathFromCarbonHome;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Configured registry path does not exists. Hence check existence relative to CARBON_HOME");
                            }
                            if (!(pathFromCarbonHome = RegistryHelper.getHome()).endsWith("/")) {
                                pathFromCarbonHome = pathFromCarbonHome + "/";
                            }
                            pathFromCarbonHome = rootPathUrl.getProtocol() + ":" + pathFromCarbonHome + value;
                            rootPathUrl = new URL(pathFromCarbonHome);
                            try {
                                rootPathUrl.openStream();
                                value = pathFromCarbonHome;
                            }
                            catch (IOException e1) {
                                this.handleException("Unable to open a connection to url : " + rootPathUrl, e1);
                            }
                        }
                        if (!value.endsWith("/")) {
                            value = value + "/";
                        }
                    } else if ("http".equals(rootPathUrl.getProtocol())) {
                        this.registryProtocol = 2;
                        this.registryType = 101;
                        if (!value.endsWith("/")) {
                            value = value + "/";
                        }
                    } else if ("https".equals(rootPathUrl.getProtocol())) {
                        this.registryProtocol = 3;
                        if (!value.endsWith("/")) {
                            value = value + "/";
                        }
                    }
                    if ("ConfigRegRoot".equals(name)) {
                        this.configRegistry = value;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Configuration Registry Location : " + this.configRegistry));
                        }
                    } else if ("GovRegRoot".equals(name)) {
                        this.govRegistry = value;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Governance Registry Location : " + this.govRegistry));
                        }
                    } else {
                        this.localRegistry = value;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Local Registry Location : " + this.localRegistry));
                        }
                    }
                }
                catch (MalformedURLException e) {
                    this.handleException("Registry root should be a valid URL.", e);
                }
            }
        } else {
            log.debug((Object)"Name and Value must need");
        }
    }

    public Properties getResourceProperties(String entryKey) {
        Properties properties = new Properties();
        Properties resourceProperties = this.lookupProperties(entryKey);
        if (resourceProperties != null) {
            for (Object key : resourceProperties.keySet()) {
                Object value = resourceProperties.get(key);
                if (value instanceof List) {
                    if (((List)value).size() <= 0) continue;
                    properties.put(key, ((List)value).get(0));
                    continue;
                }
                properties.put(key, value);
            }
            return properties;
        }
        return null;
    }

    private Properties getMetadata(String fileUrl) {
        Properties metadata = new Properties();
        File file = new File(fileUrl);
        String metadataFilePath = file.getParent() + File.separator + METADATA_DIR_NAME + File.separator + file.getName() + METADATA_FILE_SUFFIX;
        File metadataFile = new File(metadataFilePath);
        try (BufferedReader reader = new BufferedReader(new FileReader(metadataFile));){
            metadata.load(reader);
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Metadata file cannot be found at " + metadataFile.getPath()), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Error while reading file " + metadataFile.getPath()), (Throwable)e);
        }
        return metadata;
    }
}

