/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.saml.common.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.carbon.identity.saml.common.util.exception.IdentityUnmarshallingException;
import org.xml.sax.SAXException;

public class UnmarshallUtils {
    private static final Log log = LogFactory.getLog(UnmarshallUtils.class);
    private static final int ENTITY_EXPANSION_LIMIT = 0;

    public static XMLObject unmarshall(String xmlString) throws IdentityUnmarshallingException {
        try {
            DocumentBuilderFactory documentBuilderFactory = UnmarshallUtils.getSecuredDocumentBuilderFactory();
            documentBuilderFactory.setIgnoringComments(true);
            Document document = UnmarshallUtils.getDocument(documentBuilderFactory, xmlString);
            if (UnmarshallUtils.isSignedWithComments(document)) {
                documentBuilderFactory.setIgnoringComments(false);
                document = UnmarshallUtils.getDocument(documentBuilderFactory, xmlString);
            }
            Element element = document.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            return unmarshaller.unmarshall(element);
        }
        catch (IOException | ParserConfigurationException | UnmarshallingException | SAXException e) {
            String message = "Error in constructing XML Object from the encoded String";
            throw new IdentityUnmarshallingException(message, e);
        }
    }

    private static boolean isSignedWithComments(Document document) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            String assertionId = (String)xPath.compile("//*[local-name()='Assertion']/@ID").evaluate(document, XPathConstants.STRING);
            if (StringUtils.isBlank((String)assertionId)) {
                return false;
            }
            NodeList nodeList = (NodeList)xPath.compile("//*[local-name()='Assertion']/*[local-name()='Signature']/*[local-name()='SignedInfo']/*[local-name()='Reference'][@URI='#" + assertionId + "']/*[local-name()='Transforms']/*[local-name()='Transform'][@Algorithm='http://www.w3.org/2001/10/xml-exc-c14n#WithComments']").evaluate(document, XPathConstants.NODESET);
            return nodeList != null && nodeList.getLength() > 0;
        }
        catch (XPathExpressionException e) {
            String message = "Failed to find the canonicalization algorithm of the assertion. Defaulting to: http://www.w3.org/2001/10/xml-exc-c14n#";
            log.warn((Object)message);
            if (log.isDebugEnabled()) {
                log.debug((Object)message, (Throwable)e);
            }
            return false;
        }
    }

    private static Document getDocument(DocumentBuilderFactory documentBuilderFactory, String samlString) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(samlString.getBytes());
        return docBuilder.parse(inputStream);
    }

    public static DocumentBuilderFactory getSecuredDocumentBuilderFactory() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd or secure-processing.");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }
}

