/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.custom.lifecycles.checklist.ui.processors;

import java.util.ArrayList;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.custom.lifecycles.checklist.ui.clients.LifecycleServiceClient;

public class InvokeAspectProcessor {
    private static final Log log = LogFactory.getLog(InvokeAspectProcessor.class);

    public static void invokeAspect(HttpServletRequest request, ServletConfig config) throws Exception {
        LifecycleServiceClient lifecycleServiceClient = new LifecycleServiceClient(config, request.getSession());
        String path = request.getParameter("path");
        String aspect = request.getParameter("aspect");
        String action = request.getParameter("action");
        String[] items = request.getParameterValues("items");
        String versionString = request.getParameter("parameterString");
        if (!versionString.trim().equals("")) {
            String[] keySetWithValues = versionString.split("\\^\\|\\^");
            String[][] resourceVersionArray = new String[keySetWithValues.length][2];
            for (int i = 0; i < keySetWithValues.length; ++i) {
                String keySetWithValue = keySetWithValues[i];
                String[] keyAndValue = keySetWithValue.split("\\^\\^");
                resourceVersionArray[i][0] = keyAndValue[0];
                resourceVersionArray[i][1] = keyAndValue[1];
            }
            lifecycleServiceClient.invokeAspectWithParams(path, aspect, action, items, resourceVersionArray);
        } else {
            lifecycleServiceClient.invokeAspect(path, aspect, action, items);
        }
    }

    public static String[] getAllDependencies(HttpServletRequest request, ServletConfig config) throws Exception {
        String path = request.getParameter("path");
        LifecycleServiceClient lifecycleServiceClient = new LifecycleServiceClient(config, request.getSession());
        String[] dependencies = lifecycleServiceClient.getAllDependencies(path);
        ArrayList<String> filteredDependencies = new ArrayList<String>();
        for (String dependency : dependencies) {
            if (dependency.startsWith("/")) {
                filteredDependencies.add(dependency);
                continue;
            }
            log.warn((Object)("Dependency " + dependency + " of " + path.substring(path.lastIndexOf("/") + 1) + " ignored when promoting"));
        }
        return filteredDependencies.toArray(new String[filteredDependencies.size()]);
    }
}

