/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.custom.lifecycles.checklist.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.custom.lifecycles.checklist.stub.CustomLifecyclesChecklistAdminServiceStub;
import org.wso2.carbon.governance.custom.lifecycles.checklist.stub.beans.xsd.LifecycleBean;
import org.wso2.carbon.governance.custom.lifecycles.checklist.stub.services.ArrayOfString;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class LifecycleServiceClient {
    private static final Log log = LogFactory.getLog(LifecycleServiceClient.class);
    private CustomLifecyclesChecklistAdminServiceStub stub;
    private String epr;

    public LifecycleServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        this.epr = backendServerURL + "CustomLifecyclesChecklistAdminService";
        try {
            this.stub = new CustomLifecyclesChecklistAdminServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate lifecycles service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public LifecycleServiceClient(String cookie, ServletConfig config, HttpSession session) throws RegistryException {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "CustomLifecyclesChecklistAdminService";
        try {
            this.stub = new CustomLifecyclesChecklistAdminServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate lifecycles service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public LifecycleServiceClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "CustomLifecyclesChecklistAdminService";
        try {
            this.stub = new CustomLifecyclesChecklistAdminServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate lifecycles service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public LifecycleBean getLifecycleBean(String path) throws Exception {
        return this.stub.getLifecycleBean(path);
    }

    public void addAspect(String path, String aspect) throws Exception {
        this.stub.addAspect(path, aspect);
    }

    public void invokeAspect(String path, String aspect, String action, String[] items) throws Exception {
        this.stub.invokeAspect(path, aspect, action, items);
    }

    public void invokeAspectWithParams(String path, String aspect, String action, String[] items, String[][] params) throws Exception {
        ArrayOfString[] paramsArray = new ArrayOfString[params.length];
        for (int i = 0; i < params.length; ++i) {
            String[] param = params[i];
            ArrayOfString arrayOfString = new ArrayOfString();
            arrayOfString.addArray(param[0]);
            arrayOfString.addArray(param[1]);
            paramsArray[i] = arrayOfString;
        }
        this.stub.invokeAspectWithParams(path, aspect, action, items, paramsArray);
    }

    public void removeAspect(String path, String aspect) throws Exception {
        this.stub.removeAspect(path, aspect);
    }

    public String[] getAllDependencies(String path) throws Exception {
        return this.stub.getAllDependencies(path);
    }

    public void setDefaultAspect(String path, String aspect) throws Exception {
        this.stub.setDefaultAspect(path, aspect);
    }
}

