/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.custom.lifecycles.checklist.ui.clients;

import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.custom.lifecycles.checklist.ui.Beans.CurrentStateDurationBean;
import org.wso2.carbon.governance.lcm.stub.LifeCycleManagementServiceGovernanceExceptionException;
import org.wso2.carbon.governance.lcm.stub.LifeCycleManagementServiceStub;
import org.wso2.carbon.governance.lcm.stub.beans.xsd.DurationBean;

public class LifecycleManagementServiceClient {
    private static final Log log = LogFactory.getLog(LifecycleManagementServiceClient.class);
    private final String serviceName = "LifeCycleManagementService";
    private final String durationSecondsFormat = "%02ds";
    private final String durationMinutesSecondsFormat = "%02dm:%02ds";
    private final String durationHoursMinutesSecondsFormat = "%02dh:%02dm:%02ds";
    private final String durationDaysHoursMinutesSecondsFormat = "%dd:%02dh:%02dm:%02ds";
    public final String timeNotAvailableMessage = "Time duration not available";
    public final String currentStateDurationDefaultColour = "black";
    private LifeCycleManagementServiceStub stub;

    public LifecycleManagementServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) {
        String endPointReference = backendServerURL + "LifeCycleManagementService";
        try {
            this.stub = new LifeCycleManagementServiceStub(configContext, endPointReference);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Failed to initiate lifecycle management service client. " + axisFault.getMessage()), (Throwable)axisFault);
        }
    }

    public CurrentStateDurationBean getLifecycleCurrentStateDuration(String resourcePath, String lifecycleName) {
        CurrentStateDurationBean currentStateDurationBean = null;
        if (!StringUtils.isEmpty((String)resourcePath) && !StringUtils.isEmpty((String)lifecycleName)) {
            try {
                DurationBean durationBean = this.stub.getLifecycleCurrentStateDuration(resourcePath, lifecycleName);
                if (durationBean != null) {
                    currentStateDurationBean = new CurrentStateDurationBean();
                    currentStateDurationBean.setCheckpointBean(durationBean.getCheckpoint());
                    currentStateDurationBean.setDuration(this.formatTimeDuration(durationBean.getDuration()));
                }
            }
            catch (RemoteException e) {
                log.error((Object)"LifeCycleManagementService's operation, getLifecycleCurrentStateDuration error or its not unavailable", (Throwable)e);
            }
            catch (LifeCycleManagementServiceGovernanceExceptionException e) {
                log.error((Object)"Error in service: LifeCycleManagementService while getting lifecycle current state duration", (Throwable)e);
            }
        } else {
            log.error((Object)("Lifecycle directory path: '" + resourcePath + "' is or lifecycle name: '" + lifecycleName + "' is not set"));
        }
        return currentStateDurationBean;
    }

    private String formatTimeDuration(long duration) {
        long days = TimeUnit.MILLISECONDS.toDays(duration);
        long hours = TimeUnit.MILLISECONDS.toHours(duration) - TimeUnit.DAYS.toHours(TimeUnit.MILLISECONDS.toDays(duration));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(duration) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(duration));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duration));
        String timeDuration = days == 0L && hours == 0L && minutes == 0L ? String.format("%02ds", seconds) : (days == 0L && hours == 0L ? String.format("%02dm:%02ds", minutes, seconds) : (days == 0L ? String.format("%02dh:%02dm:%02ds", hours, minutes, seconds) : String.format("%dd:%02dh:%02dm:%02ds", days, hours, minutes, seconds)));
        return timeDuration;
    }
}

