/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.core.validator;

import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.OneTimeUse;
import org.opensaml.saml2.core.ProxyRestriction;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

public class ConditionsSpecValidator
implements Validator<Conditions> {
    @Override
    public void validate(Conditions conditions) throws ValidationException {
        this.validateOneTimeUseCondition(conditions);
        this.validateProxyRestrictionCondition(conditions);
    }

    protected void validateOneTimeUseCondition(Conditions conditions) throws ValidationException {
        int oneTimeUseCount = 0;
        for (int i = 0; i < conditions.getConditions().size(); ++i) {
            if (!(conditions.getConditions().get(i) instanceof OneTimeUse)) continue;
            ++oneTimeUseCount;
        }
        if (oneTimeUseCount > 1) {
            throw new ValidationException("At most one instance of OneTimeUse allowed");
        }
    }

    protected void validateProxyRestrictionCondition(Conditions conditions) throws ValidationException {
        int proxyRestrictionCount = 0;
        for (int i = 0; i < conditions.getConditions().size(); ++i) {
            if (!(conditions.getConditions().get(i) instanceof ProxyRestriction)) continue;
            ++proxyRestrictionCount;
        }
        if (proxyRestrictionCount > 1) {
            throw new ValidationException("At most one instance of ProxyRestriction allowed");
        }
    }
}

