/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;

public class SessionNonceCookieUtil {
    public static final String NONCE_COOKIE = "sessionNonceCookie";
    public static final String NONCE_COOKIE_CONFIG = "EnableSessionNonceCookie";
    public static final String NONCE_ERROR_CODE = "sessionNonceErrorCode";
    private static Boolean nonceCookieConfig;

    public static String getNonceCookieName(AuthenticationContext context) {
        return "sessionNonceCookie-" + context.getContextIdentifier();
    }

    public static void addNonceCookie(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) {
        if (SessionNonceCookieUtil.isNonceCookieEnabled()) {
            String nonceId = UUIDGenerator.generateUUID();
            String cookieName = SessionNonceCookieUtil.getNonceCookieName(context);
            FrameworkUtils.setCookie(request, response, cookieName, nonceId, null);
            context.setProperty(cookieName, nonceId);
        }
    }

    public static boolean validateNonceCookie(HttpServletRequest request, AuthenticationContext context) {
        if (!SessionNonceCookieUtil.isNonceCookieEnabled()) {
            return true;
        }
        boolean validNonceValue = false;
        String cookieName = SessionNonceCookieUtil.getNonceCookieName(context);
        String nonceFromContext = (String)context.getProperty(cookieName);
        Cookie nonceCookie = FrameworkUtils.getCookie(request, cookieName);
        String nonceFromSession = null;
        if (nonceCookie != null) {
            nonceFromSession = nonceCookie.getValue();
        }
        if (!StringUtils.isEmpty((String)nonceFromContext) && !StringUtils.isEmpty((String)nonceFromSession) && nonceFromContext.equals(nonceFromSession)) {
            validNonceValue = true;
        }
        return validNonceValue;
    }

    public static void removeNonceCookie(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) {
        if (SessionNonceCookieUtil.isNonceCookieEnabled()) {
            String cookieName = SessionNonceCookieUtil.getNonceCookieName(context);
            FrameworkUtils.removeCookie(request, response, cookieName);
            context.removeProperty(cookieName);
        }
    }

    public static boolean isNonceCookieEnabled() {
        if (nonceCookieConfig == null) {
            nonceCookieConfig = Boolean.parseBoolean(IdentityUtil.getProperty((String)NONCE_COOKIE_CONFIG));
        }
        return nonceCookieConfig;
    }
}

