/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.util;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class LoginContextManagementUtil {
    private static final String SP_REDIRECT_URL_RESOURCE_PATH = "/identity/config/relyingPartyRedirectUrls";
    private static final Log log = LogFactory.getLog(LoginContextManagementUtil.class);

    public static void handleLoginContext(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String sessionDataKey = request.getParameter("sessionDataKey");
        String relyingParty = request.getParameter("relyingParty");
        String tenantDomain = LoginContextManagementUtil.getTenantDomain(request);
        JsonObject result = new JsonObject();
        response.setContentType("application/json");
        if (StringUtils.isBlank((String)relyingParty) || StringUtils.isBlank((String)sessionDataKey)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Required data to proceed is not available in the request.");
            }
            result.addProperty("status", "success");
            response.getWriter().write(result.toString());
            return;
        }
        AuthenticationContext context = FrameworkUtils.getAuthenticationContextFromCache(sessionDataKey);
        if (context != null) {
            if (LoginContextManagementUtil.isStepHasMultiOption(context)) {
                context.setCurrentAuthenticator(null);
            }
            result.addProperty("status", "success");
            response.getWriter().write(result.toString());
        } else {
            String redirectUrl = LoginContextManagementUtil.getRelyingPartyRedirectUrl(relyingParty, tenantDomain);
            if (StringUtils.isBlank((String)redirectUrl)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Redirect URL is not available for the relaying party - " + relyingParty + " for sessionDataKey: " + sessionDataKey));
                }
                result.addProperty("status", "success");
                response.getWriter().write(result.toString());
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Redirect URL is: " + redirectUrl + " for the relaying party - " + relyingParty + " for sessionDataKey: " + sessionDataKey));
                }
                result.addProperty("status", "redirect");
                result.addProperty("redirectUrl", redirectUrl);
                response.getWriter().write(result.toString());
            }
        }
    }

    private static String getTenantDomain(HttpServletRequest request) {
        String tenantDomain;
        if (IdentityTenantUtil.isTenantQualifiedUrlsEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Tenant Qualified URL mode enabled. Retrieving tenantDomain from thread local context.");
            }
            tenantDomain = IdentityTenantUtil.getTenantDomainFromContext();
        } else {
            tenantDomain = request.getParameter("tenantDomain");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Service Provider tenant domain: " + tenantDomain));
        }
        return tenantDomain;
    }

    public static String getRelyingPartyRedirectUrl(String relyingParty, String tenantDomain) {
        int tenantId;
        if (log.isDebugEnabled()) {
            log.debug((Object)("retrieving configured url against relying party : " + relyingParty + "for tenant domain : " + tenantDomain));
        }
        if (StringUtils.isEmpty((String)tenantDomain)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Tenant domain is not available. Hence using super tenant domain");
            }
            tenantDomain = "carbon.super";
            tenantId = -1234;
        } else {
            tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        }
        try {
            String redirectUrl;
            Resource resource;
            IdentityTenantUtil.initializeRegistry((int)tenantId);
            Registry registry = IdentityTenantUtil.getConfigRegistry((int)tenantId);
            if (registry.resourceExists(SP_REDIRECT_URL_RESOURCE_PATH) && (resource = registry.get(SP_REDIRECT_URL_RESOURCE_PATH)) != null && StringUtils.isNotEmpty((String)(redirectUrl = resource.getProperty(relyingParty)))) {
                return redirectUrl;
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while getting data from the registry.", (Throwable)e);
        }
        catch (IdentityException e) {
            log.error((Object)("Error while getting the tenant domain from tenant id : " + tenantId), (Throwable)e);
        }
        return null;
    }

    public static boolean isPostAuthenticationExtensionCompleted(AuthenticationContext authenticationContext) {
        Object object = authenticationContext.getProperty("postAuthenticationExtensionCompleted");
        if (object != null && object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    public static void markPostAuthenticationCompleted(AuthenticationContext authenticationContext) {
        authenticationContext.setProperty("postAuthenticationExtensionCompleted", true);
    }

    private static boolean isStepHasMultiOption(AuthenticationContext context) {
        StepConfig stepConfig;
        Map<Integer, StepConfig> stepMap = context.getSequenceConfig().getStepMap();
        boolean stepHasMultiOption = false;
        if (stepMap != null && !stepMap.isEmpty() && (stepConfig = stepMap.get(context.getCurrentStep())) != null) {
            stepHasMultiOption = stepConfig.isMultiOption();
        }
        return stepHasMultiOption;
    }
}

