/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.util;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.SameSiteCookie;
import org.wso2.carbon.identity.application.authentication.framework.ApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticationDataPublisher;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticatorFlowStatus;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationContextCache;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationContextCacheEntry;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationContextCacheKey;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationRequestCache;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationRequestCacheEntry;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationRequestCacheKey;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationResultCache;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationResultCacheEntry;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationResultCacheKey;
import org.wso2.carbon.identity.application.authentication.framework.cache.SessionContextCache;
import org.wso2.carbon.identity.application.authentication.framework.cache.SessionContextCacheEntry;
import org.wso2.carbon.identity.application.authentication.framework.cache.SessionContextCacheKey;
import org.wso2.carbon.identity.application.authentication.framework.config.ConfigurationFacade;
import org.wso2.carbon.identity.application.authentication.framework.config.builder.FileBasedConfigurationBuilder;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ApplicationConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.AuthenticatorConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ExternalIdPConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.SerializableJsFunction;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.context.SessionContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.exception.InvalidCredentialsException;
import org.wso2.carbon.identity.application.authentication.framework.exception.UserSessionException;
import org.wso2.carbon.identity.application.authentication.framework.handler.claims.ClaimHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.claims.impl.DefaultClaimHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.hrd.HomeRealmDiscoverer;
import org.wso2.carbon.identity.application.authentication.framework.handler.hrd.impl.DefaultHomeRealmDiscoverer;
import org.wso2.carbon.identity.application.authentication.framework.handler.provisioning.ProvisioningHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.provisioning.impl.DefaultProvisioningHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.AuthenticationRequestHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.CallBackHandlerFactory;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.LogoutRequestHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.RequestCoordinator;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.DefaultAuthenticationRequestHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.DefaultLogoutRequestHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.DefaultRequestCoordinator;
import org.wso2.carbon.identity.application.authentication.framework.handler.sequence.RequestPathBasedSequenceHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.sequence.StepBasedSequenceHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.sequence.impl.DefaultRequestPathBasedSequenceHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.sequence.impl.GraphBasedSequenceHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.step.StepHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.step.impl.GraphBasedStepHandler;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceComponent;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedIdPData;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticationFrameworkWrapper;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticationRequest;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticationResult;
import org.wso2.carbon.identity.application.authentication.framework.store.UserSessionStore;
import org.wso2.carbon.identity.application.common.model.Claim;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.IdentityProviderProperty;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataHandler;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.core.model.CookieBuilder;
import org.wso2.carbon.identity.core.model.IdentityCookieConfig;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventConstants;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.services.IdentityEventService;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.FederatedAssociationManager;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;
import org.wso2.carbon.idp.mgt.util.IdPManagementUtil;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.config.UserStorePreferenceOrderSupplier;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class FrameworkUtils {
    public static final String SESSION_DATA_KEY = "sessionDataKey";
    public static final String TENANT_DOMAIN = "tenantDomain";
    public static final String UTF_8 = "UTF-8";
    private static final Log log = LogFactory.getLog(FrameworkUtils.class);
    private static int maxInactiveInterval;
    private static final String EMAIL = "email";
    private static List<String> cacheDisabledAuthenticators;
    private static final String QUERY_SEPARATOR = "&";
    private static final String EQUAL = "=";
    private static final String REQUEST_PARAM_APPLICATION = "application";
    private static final String ALREADY_WRITTEN_PROPERTY = "AlreadyWritten";
    private static final String CONTINUE_ON_CLAIM_HANDLING_ERROR = "ContinueOnClaimHandlingError";

    private FrameworkUtils() {
    }

    public static List<String> getCacheDisabledAuthenticators() {
        return cacheDisabledAuthenticators;
    }

    public static void addAuthenticationRequestToCache(String key, AuthenticationRequestCacheEntry authReqEntry) {
        AuthenticationRequestCacheKey cacheKey = new AuthenticationRequestCacheKey(key);
        AuthenticationRequestCache.getInstance().addToCache(cacheKey, authReqEntry);
    }

    public static AuthenticationRequestCacheEntry getAuthenticationRequestFromCache(String key) {
        AuthenticationRequestCacheKey cacheKey = new AuthenticationRequestCacheKey(key);
        AuthenticationRequestCacheEntry authRequest = AuthenticationRequestCache.getInstance().getValueFromCache(cacheKey);
        return authRequest;
    }

    public static void removeAuthenticationRequestFromCache(String key) {
        if (key != null) {
            AuthenticationRequestCacheKey cacheKey = new AuthenticationRequestCacheKey(key);
            AuthenticationRequestCache.getInstance().clearCacheEntry(cacheKey);
        }
    }

    public static HttpServletRequest getCommonAuthReqWithParams(HttpServletRequest request, AuthenticationRequestCacheEntry cacheEntry) {
        TreeMap<String, String[]> modifiableParameters = new TreeMap<String, String[]>();
        if (cacheEntry != null) {
            AuthenticationRequest authenticationRequest = cacheEntry.getAuthenticationRequest();
            if (!authenticationRequest.getRequestQueryParams().isEmpty()) {
                modifiableParameters.putAll(authenticationRequest.getRequestQueryParams());
            }
            if (authenticationRequest.getType() != null) {
                modifiableParameters.put("type", new String[]{authenticationRequest.getType()});
            }
            if (authenticationRequest.getCommonAuthCallerPath() != null) {
                modifiableParameters.put("commonAuthCallerPath", new String[]{authenticationRequest.getCommonAuthCallerPath()});
            }
            if (authenticationRequest.getRelyingParty() != null) {
                modifiableParameters.put("relyingParty", new String[]{authenticationRequest.getRelyingParty()});
            }
            if (authenticationRequest.getTenantDomain() != null && !IdentityTenantUtil.isTenantQualifiedUrlsEnabled()) {
                modifiableParameters.put(TENANT_DOMAIN, new String[]{authenticationRequest.getTenantDomain()});
            }
            modifiableParameters.put("forceAuth", new String[]{String.valueOf(authenticationRequest.getForceAuth())});
            modifiableParameters.put("passiveAuth", new String[]{String.valueOf(authenticationRequest.getPassiveAuth())});
            if (log.isDebugEnabled()) {
                StringBuilder queryStringBuilder = new StringBuilder("");
                for (Map.Entry entry : modifiableParameters.entrySet()) {
                    StringBuilder paramValueBuilder = new StringBuilder("");
                    String[] paramValueArr = (String[])entry.getValue();
                    if (paramValueArr != null) {
                        for (String paramValue : paramValueArr) {
                            paramValueBuilder.append("{").append(paramValue).append("}");
                        }
                    }
                    queryStringBuilder.append("\n").append((String)entry.getKey() + EQUAL + paramValueBuilder.toString());
                }
                log.debug((Object)("\nInbound Request parameters: " + queryStringBuilder.toString()));
            }
            return new AuthenticationFrameworkWrapper(request, modifiableParameters, authenticationRequest.getRequestHeaders());
        }
        return request;
    }

    public static ApplicationAuthenticator getAppAuthenticatorByName(String name) {
        for (ApplicationAuthenticator authenticator : FrameworkServiceComponent.getAuthenticators()) {
            if (!name.equals(authenticator.getName())) continue;
            return authenticator;
        }
        return null;
    }

    public static AuthenticationContext getContextData(HttpServletRequest request) {
        String promptId;
        AuthenticationContext context = null;
        if (request.getParameter("promptResp") != null && request.getParameter("promptId") != null && (context = FrameworkUtils.getAuthenticationContextFromCache(promptId = request.getParameter("promptId"))) != null) {
            FrameworkUtils.removeAuthenticationContextFromCache(promptId);
            return context;
        }
        for (ApplicationAuthenticator authenticator : FrameworkServiceComponent.getAuthenticators()) {
            try {
                String contextIdentifier = authenticator.getContextIdentifier(request);
                if (contextIdentifier == null || contextIdentifier.isEmpty() || (context = FrameworkUtils.getAuthenticationContextFromCache(contextIdentifier)) == null) continue;
                break;
            }
            catch (UnsupportedOperationException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Ignore UnsupportedOperationException.", (Throwable)e);
            }
        }
        return context;
    }

    public static RequestCoordinator getRequestCoordinator() {
        RequestCoordinator requestCoordinator = null;
        Object obj = ConfigurationFacade.getInstance().getExtensions().get("RequestCoordinator");
        requestCoordinator = obj instanceof RequestCoordinator ? (RequestCoordinator)obj : DefaultRequestCoordinator.getInstance();
        return requestCoordinator;
    }

    public static AuthenticationRequestHandler getAuthenticationRequestHandler() {
        AuthenticationRequestHandler authenticationRequestHandler = null;
        Object obj = ConfigurationFacade.getInstance().getExtensions().get("AuthenticationRequestHandler");
        authenticationRequestHandler = obj instanceof AuthenticationRequestHandler ? (AuthenticationRequestHandler)obj : DefaultAuthenticationRequestHandler.getInstance();
        return authenticationRequestHandler;
    }

    public static LogoutRequestHandler getLogoutRequestHandler() {
        LogoutRequestHandler logoutRequestHandler = null;
        Object obj = ConfigurationFacade.getInstance().getExtensions().get("LogoutRequestHandler");
        logoutRequestHandler = obj instanceof LogoutRequestHandler ? (LogoutRequestHandler)obj : DefaultLogoutRequestHandler.getInstance();
        return logoutRequestHandler;
    }

    public static StepBasedSequenceHandler getStepBasedSequenceHandler() {
        Object obj = ConfigurationFacade.getInstance().getExtensions().get("StepBasedSequenceHandler");
        StepBasedSequenceHandler stepBasedSequenceHandler = obj instanceof StepBasedSequenceHandler ? (StepBasedSequenceHandler)obj : new GraphBasedSequenceHandler();
        return stepBasedSequenceHandler;
    }

    public static RequestPathBasedSequenceHandler getRequestPathBasedSequenceHandler() {
        RequestPathBasedSequenceHandler reqPathBasedSeqHandler = null;
        Object obj = ConfigurationFacade.getInstance().getExtensions().get("RequestPathBasedSequenceHandler");
        reqPathBasedSeqHandler = obj instanceof RequestPathBasedSequenceHandler ? (RequestPathBasedSequenceHandler)obj : DefaultRequestPathBasedSequenceHandler.getInstance();
        return reqPathBasedSeqHandler;
    }

    public static StepHandler getStepHandler() {
        Object obj = ConfigurationFacade.getInstance().getExtensions().get("StepHandler");
        StepHandler stepHandler = obj instanceof StepHandler ? (StepHandler)obj : new GraphBasedStepHandler();
        return stepHandler;
    }

    public static HomeRealmDiscoverer getHomeRealmDiscoverer() {
        HomeRealmDiscoverer homeRealmDiscoverer = null;
        Object obj = ConfigurationFacade.getInstance().getExtensions().get("HomeRealmDiscoverer");
        homeRealmDiscoverer = obj instanceof HomeRealmDiscoverer ? (HomeRealmDiscoverer)obj : DefaultHomeRealmDiscoverer.getInstance();
        return homeRealmDiscoverer;
    }

    public static ClaimHandler getClaimHandler() {
        ClaimHandler claimHandler = null;
        Object obj = ConfigurationFacade.getInstance().getExtensions().get("ClaimHandler");
        claimHandler = obj instanceof ClaimHandler ? (ClaimHandler)obj : DefaultClaimHandler.getInstance();
        return claimHandler;
    }

    public static ProvisioningHandler getProvisioningHandler() {
        ProvisioningHandler provisioningHandler = null;
        Object obj = ConfigurationFacade.getInstance().getExtensions().get("ProvisioningHandler");
        provisioningHandler = obj instanceof ProvisioningHandler ? (ProvisioningHandler)obj : DefaultProvisioningHandler.getInstance();
        return provisioningHandler;
    }

    public static UserStorePreferenceOrderSupplier<List<String>> getUserStorePreferenceOrderSupplier(AuthenticationContext context, ServiceProvider serviceProvider) {
        return FrameworkUtils.getCallBackHandlerFactory().createUserStorePreferenceOrderSupplier(context, serviceProvider);
    }

    private static CallBackHandlerFactory getCallBackHandlerFactory() {
        Object obj = ConfigurationFacade.getInstance().getExtensions().get("CallbackFactory");
        CallBackHandlerFactory userStorePreferenceCallbackHandlerFactory = obj != null ? (CallBackHandlerFactory)obj : new CallBackHandlerFactory();
        return userStorePreferenceCallbackHandlerFactory;
    }

    public static void sendToRetryPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.setAttribute("authenticatorFlowStatus", (Object)AuthenticatorFlowStatus.INCOMPLETE);
        response.sendRedirect(FrameworkUtils.getRedirectURL(ConfigurationFacade.getInstance().getAuthenticationEndpointRetryURL(), request));
    }

    public static void sendToRetryPage(HttpServletRequest request, HttpServletResponse response, String status, String statusMsg) throws IOException {
        try {
            URIBuilder uriBuilder = new URIBuilder(ConfigurationFacade.getInstance().getAuthenticationEndpointRetryURL());
            uriBuilder.addParameter("status", status);
            uriBuilder.addParameter("statusMsg", statusMsg);
            request.setAttribute("authenticatorFlowStatus", (Object)AuthenticatorFlowStatus.INCOMPLETE);
            response.sendRedirect(FrameworkUtils.getRedirectURL(uriBuilder.build().toString(), request));
        }
        catch (URISyntaxException e) {
            log.error((Object)"Error building redirect url for failure", (Throwable)e);
            FrameworkUtils.sendToRetryPage(request, response);
        }
    }

    public static String getRedirectURL(String redirectURL, HttpServletRequest request) {
        String spName = (String)request.getAttribute("sp");
        String tenantDomain = (String)request.getAttribute(TENANT_DOMAIN);
        if (StringUtils.isBlank((String)spName)) {
            spName = FrameworkUtils.getServiceProviderNameByReferer(request);
        }
        if (StringUtils.isBlank((String)tenantDomain)) {
            tenantDomain = FrameworkUtils.getTenantDomainByReferer(request);
        }
        try {
            if (StringUtils.isNotBlank((String)spName)) {
                redirectURL = FrameworkUtils.appendUri(redirectURL, "sp", spName);
            }
            if (!IdentityTenantUtil.isTenantQualifiedUrlsEnabled() && StringUtils.isNotBlank((String)tenantDomain)) {
                redirectURL = FrameworkUtils.appendUri(redirectURL, TENANT_DOMAIN, tenantDomain);
            }
        }
        catch (UnsupportedEncodingException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error occurred while encoding parameters: " + tenantDomain + " and/or " + spName), (Throwable)e);
            }
            return redirectURL;
        }
        return redirectURL;
    }

    private static String getServiceProviderNameByReferer(HttpServletRequest request) {
        String serviceProviderName = null;
        String refererHeader = request.getHeader("referer");
        if (StringUtils.isNotBlank((String)refererHeader)) {
            String[] queryParams;
            for (String queryParam : queryParams = refererHeader.split(QUERY_SEPARATOR)) {
                if (!queryParam.contains("sp=") && !queryParam.contains("application=")) continue;
                serviceProviderName = queryParam.substring(queryParam.lastIndexOf(EQUAL) + 1);
                break;
            }
        }
        return serviceProviderName;
    }

    private static String getTenantDomainByReferer(HttpServletRequest request) {
        String tenantDomain = null;
        String refererHeader = request.getHeader("referer");
        if (StringUtils.isNotBlank((String)refererHeader)) {
            String[] queryParams;
            for (String queryParam : queryParams = refererHeader.split(QUERY_SEPARATOR)) {
                if (!queryParam.contains("tenantDomain=")) continue;
                tenantDomain = queryParam.substring(queryParam.lastIndexOf(EQUAL) + 1);
                break;
            }
        }
        return tenantDomain;
    }

    private static String appendUri(String uri, String key, String value) throws UnsupportedEncodingException {
        if (StringUtils.isNotBlank((String)uri) && StringUtils.isNotBlank((String)key) && StringUtils.isNotBlank((String)value)) {
            uri = uri.contains("?") || uri.contains("#") ? uri + QUERY_SEPARATOR + key + EQUAL + URLEncoder.encode(value, UTF_8) : uri + "?" + key + EQUAL + URLEncoder.encode(value, UTF_8);
        }
        return uri;
    }

    public static void removeAuthCookie(HttpServletRequest req, HttpServletResponse resp) {
        FrameworkUtils.removeCookie(req, resp, "commonAuthId", SameSiteCookie.NONE);
    }

    public static void removeCookie(HttpServletRequest req, HttpServletResponse resp, String cookieName) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                CookieBuilder cookieBuilder = new CookieBuilder(cookieName, cookie.getValue());
                IdentityCookieConfig cookieConfig = IdentityUtil.getIdentityCookieConfig((String)cookieName);
                if (cookieConfig != null) {
                    FrameworkUtils.updateCookieConfig(cookieBuilder, cookieConfig, 0);
                } else {
                    cookieBuilder.setHttpOnly(true);
                    cookieBuilder.setSecure(true);
                    cookieBuilder.setPath("/");
                }
                cookieBuilder.setMaxAge(0);
                resp.addCookie(cookieBuilder.build());
                break;
            }
        }
    }

    public static void removeCookie(HttpServletRequest req, HttpServletResponse resp, String cookieName, SameSiteCookie sameSiteCookie) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                CookieBuilder cookieBuilder = new CookieBuilder(cookieName, cookie.getValue());
                IdentityCookieConfig cookieConfig = IdentityUtil.getIdentityCookieConfig((String)cookieName);
                if (cookieConfig != null) {
                    FrameworkUtils.updateCookieConfig(cookieBuilder, cookieConfig, 0);
                } else {
                    cookieBuilder.setHttpOnly(true);
                    cookieBuilder.setSecure(true);
                    cookieBuilder.setPath("/");
                    cookieBuilder.setSameSite(sameSiteCookie);
                }
                cookieBuilder.setMaxAge(0);
                resp.addCookie(cookieBuilder.build());
                break;
            }
        }
    }

    public static void storeAuthCookie(HttpServletRequest req, HttpServletResponse resp, String id) {
        FrameworkUtils.storeAuthCookie(req, resp, id, null);
    }

    public static void storeAuthCookie(HttpServletRequest req, HttpServletResponse resp, String id, Integer age) {
        FrameworkUtils.setCookie(req, resp, "commonAuthId", id, age, SameSiteCookie.NONE);
    }

    public static void setCookie(HttpServletRequest req, HttpServletResponse resp, String cookieName, String id, Integer age) {
        CookieBuilder cookieBuilder = new CookieBuilder(cookieName, id);
        IdentityCookieConfig cookieConfig = IdentityUtil.getIdentityCookieConfig((String)cookieName);
        if (cookieConfig != null) {
            FrameworkUtils.updateCookieConfig(cookieBuilder, cookieConfig, age);
        } else {
            cookieBuilder.setSecure(true);
            cookieBuilder.setHttpOnly(true);
            cookieBuilder.setPath("/");
            if (age != null) {
                cookieBuilder.setMaxAge(age.intValue());
            }
        }
        resp.addCookie(cookieBuilder.build());
    }

    public static void setCookie(HttpServletRequest req, HttpServletResponse resp, String cookieName, String id, Integer age, SameSiteCookie setSameSite) {
        CookieBuilder cookieBuilder = new CookieBuilder(cookieName, id);
        IdentityCookieConfig cookieConfig = IdentityUtil.getIdentityCookieConfig((String)cookieName);
        if (cookieConfig != null) {
            FrameworkUtils.updateCookieConfig(cookieBuilder, cookieConfig, age);
        } else {
            cookieBuilder.setSecure(true);
            cookieBuilder.setHttpOnly(true);
            cookieBuilder.setPath("/");
            cookieBuilder.setSameSite(setSameSite);
            if (age != null) {
                cookieBuilder.setMaxAge(age.intValue());
            }
        }
        resp.addCookie(cookieBuilder.build());
    }

    public static Cookie getAuthCookie(HttpServletRequest req) {
        return FrameworkUtils.getCookie(req, "commonAuthId");
    }

    public static Cookie getCookie(HttpServletRequest req, String cookieName) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static void addAuthenticationContextToCache(String contextId, AuthenticationContext context) {
        AuthenticationContextCacheKey cacheKey = new AuthenticationContextCacheKey(contextId);
        AuthenticationContextCacheEntry cacheEntry = new AuthenticationContextCacheEntry(context);
        cacheEntry.setValidityPeriod(TimeUnit.MINUTES.toNanos(IdentityUtil.getTempDataCleanUpTimeout()));
        AuthenticationContextCache.getInstance().addToCache(cacheKey, cacheEntry);
    }

    public static void addAuthenticationResultToCache(String key, AuthenticationResult authenticationResult) {
        AuthenticationResultCacheKey cacheKey = new AuthenticationResultCacheKey(key);
        AuthenticationResultCacheEntry cacheEntry = new AuthenticationResultCacheEntry();
        cacheEntry.setResult(authenticationResult);
        cacheEntry.setValidityPeriod(TimeUnit.MINUTES.toNanos(IdentityUtil.getOperationCleanUpTimeout()));
        AuthenticationResultCache.getInstance().addToCache(cacheKey, cacheEntry);
    }

    public static AuthenticationResultCacheEntry getAuthenticationResultFromCache(String key) {
        AuthenticationResultCacheKey cacheKey = new AuthenticationResultCacheKey(key);
        AuthenticationResultCacheEntry authResult = AuthenticationResultCache.getInstance().getValueFromCache(cacheKey);
        return authResult;
    }

    public static void removeAuthenticationResultFromCache(String autheticationResultId) {
        if (autheticationResultId != null) {
            AuthenticationResultCacheKey cacheKey = new AuthenticationResultCacheKey(autheticationResultId);
            AuthenticationResultCache.getInstance().clearCacheEntry(cacheKey);
        }
    }

    @Deprecated
    public static void addSessionContextToCache(String key, SessionContext sessionContext) {
        Object authenticatedUserObj;
        SessionContextCacheKey cacheKey = new SessionContextCacheKey(key);
        SessionContextCacheEntry cacheEntry = new SessionContextCacheEntry();
        Map<String, SequenceConfig> seqData = sessionContext.getAuthenticatedSequences();
        if (seqData != null) {
            for (Map.Entry<String, SequenceConfig> entry : seqData.entrySet()) {
                if (entry.getValue() == null) continue;
                entry.getValue().getAuthenticatedUser().setUserAttributes(null);
                entry.getValue().setAuthenticationGraph(null);
            }
        }
        if ((authenticatedUserObj = sessionContext.getProperty("AuthenticatedUser")) instanceof AuthenticatedUser) {
            AuthenticatedUser authenticatedUser = (AuthenticatedUser)((Object)authenticatedUserObj);
            cacheEntry.setLoggedInUser(authenticatedUser.getAuthenticatedSubjectIdentifier());
        }
        cacheEntry.setContext(sessionContext);
        SessionContextCache.getInstance().addToCache(cacheKey, cacheEntry);
    }

    public static void addSessionContextToCache(String key, SessionContext sessionContext, String tenantDomain) {
        Object authenticatedUserObj;
        SessionContextCacheKey cacheKey = new SessionContextCacheKey(key);
        SessionContextCacheEntry cacheEntry = new SessionContextCacheEntry();
        Map<String, SequenceConfig> seqData = sessionContext.getAuthenticatedSequences();
        if (seqData != null) {
            for (Map.Entry<String, SequenceConfig> entry : seqData.entrySet()) {
                if (entry.getValue() == null) continue;
                entry.getValue().getAuthenticatedUser().setUserAttributes(null);
                entry.getValue().setAuthenticationGraph(null);
            }
        }
        if ((authenticatedUserObj = sessionContext.getProperty("AuthenticatedUser")) instanceof AuthenticatedUser) {
            AuthenticatedUser authenticatedUser = (AuthenticatedUser)((Object)authenticatedUserObj);
            cacheEntry.setLoggedInUser(authenticatedUser.getAuthenticatedSubjectIdentifier());
        }
        long timeoutPeriod = sessionContext.isRememberMe() ? TimeUnit.SECONDS.toNanos(IdPManagementUtil.getRememberMeTimeout((String)tenantDomain)) : TimeUnit.SECONDS.toNanos(IdPManagementUtil.getIdleSessionTimeOut((String)tenantDomain));
        cacheEntry.setContext(sessionContext);
        cacheEntry.setValidityPeriod(timeoutPeriod);
        SessionContextCache.getInstance().addToCache(cacheKey, cacheEntry);
    }

    public static SessionContext getSessionContextFromCache(String key) {
        SessionContext sessionContext = null;
        if (StringUtils.isNotBlank((String)key)) {
            SessionContextCacheKey cacheKey = new SessionContextCacheKey(key);
            SessionContextCacheEntry cacheEntryObj = SessionContextCache.getInstance().getValueFromCache(cacheKey);
            if (cacheEntryObj != null) {
                sessionContext = cacheEntryObj.getContext();
            }
        }
        return sessionContext;
    }

    public static SessionContext getSessionContextFromCache(HttpServletRequest request, AuthenticationContext context, String sessionContextKey) throws FrameworkException {
        SessionContext sessionContext = null;
        if (StringUtils.isNotBlank((String)sessionContextKey)) {
            SessionContextCacheKey cacheKey = new SessionContextCacheKey(sessionContextKey);
            SessionContextCache sessionContextCache = SessionContextCache.getInstance();
            SessionContextCacheEntry cacheEntry = sessionContextCache.getSessionContextCacheEntry(cacheKey);
            if (cacheEntry != null) {
                sessionContext = cacheEntry.getContext();
                boolean isSessionExpired = sessionContextCache.isSessionExpired(cacheKey, cacheEntry);
                if (isSessionExpired) {
                    FrameworkUtils.triggerSessionExpireEvent(request, context, sessionContext);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("A SESSION_EXPIRE event was fired for the expired session found corresponding to the key: " + cacheKey.getContextId()));
                    }
                    return null;
                }
            }
        }
        return sessionContext;
    }

    private static void triggerSessionExpireEvent(HttpServletRequest request, AuthenticationContext context, SessionContext sessionContext) throws FrameworkException {
        AuthenticatedUser authenticatedUser = new AuthenticatedUser();
        if (sessionContext != null) {
            Object authenticatedUserObj = sessionContext.getProperty("AuthenticatedUser");
            if (authenticatedUserObj instanceof AuthenticatedUser) {
                authenticatedUser = (AuthenticatedUser)((Object)authenticatedUserObj);
            }
            context.setSubject(authenticatedUser);
            IdentityEventService eventService = FrameworkServiceDataHolder.getInstance().getIdentityEventService();
            try {
                HashMap<String, Object> eventProperties = new HashMap<String, Object>();
                eventProperties.put("request", request);
                eventProperties.put("context", context);
                eventProperties.put("sessionContext", sessionContext);
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("user", (Object)authenticatedUser);
                paramMap.put("sessionId", context.getSessionIdentifier());
                Map unmodifiableParamMap = Collections.unmodifiableMap(paramMap);
                eventProperties.put("params", unmodifiableParamMap);
                Event event = new Event(IdentityEventConstants.EventName.SESSION_EXPIRE.name(), eventProperties);
                eventService.handleEvent(event);
            }
            catch (IdentityEventException e) {
                throw new FrameworkException("Error in triggering session expire event for the session: " + context.getSessionIdentifier() + " of user: " + authenticatedUser.toFullQualifiedUsername(), e);
            }
        }
    }

    public static void removeSessionContextFromCache(String key) {
        if (key != null) {
            SessionContextCacheKey cacheKey = new SessionContextCacheKey(key);
            SessionContextCache.getInstance().clearCacheEntry(cacheKey);
        }
    }

    public static void removeAuthenticationContextFromCache(String contextId) {
        if (contextId != null) {
            AuthenticationContextCacheKey cacheKey = new AuthenticationContextCacheKey(contextId);
            AuthenticationContextCache.getInstance().clearCacheEntry(cacheKey);
        }
    }

    public static AuthenticationContext getAuthenticationContextFromCache(String contextId) {
        AuthenticationContext authenticationContext = null;
        AuthenticationContextCacheKey cacheKey = new AuthenticationContextCacheKey(contextId);
        AuthenticationContextCacheEntry authenticationContextCacheEntry = AuthenticationContextCache.getInstance().getValueFromCache(cacheKey);
        if (authenticationContextCacheEntry != null) {
            authenticationContext = authenticationContextCacheEntry.getContext();
        }
        if (log.isDebugEnabled() && authenticationContext == null) {
            log.debug((Object)"Authentication Context is null");
        }
        return authenticationContext;
    }

    public static Map<String, String> getAuthenticatorPropertyMapFromIdP(ExternalIdPConfig externalIdPConfig, String name) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        if (externalIdPConfig != null) {
            FederatedAuthenticatorConfig[] authenticatorConfigs;
            for (FederatedAuthenticatorConfig authenticatorConfig : authenticatorConfigs = externalIdPConfig.getIdentityProvider().getFederatedAuthenticatorConfigs()) {
                if (!authenticatorConfig.getName().equals(name)) continue;
                for (Property property : authenticatorConfig.getProperties()) {
                    propertyMap.put(property.getName(), property.getValue());
                }
                break;
            }
        }
        return propertyMap;
    }

    public static Map<ClaimMapping, String> buildClaimMappings(Map<String, String> attributeValue) {
        HashMap<ClaimMapping, String> claimMap = new HashMap<ClaimMapping, String>();
        for (Map.Entry<String, String> entry : attributeValue.entrySet()) {
            if (entry.getValue() == null) continue;
            claimMap.put(ClaimMapping.build((String)entry.getKey(), (String)entry.getKey(), null, (boolean)false), entry.getValue());
        }
        return claimMap;
    }

    public static Set<String> getKeySet(Map<ClaimMapping, String> attributeValues) {
        HashSet<String> claimList = new HashSet<String>();
        for (Map.Entry<ClaimMapping, String> entry : attributeValues.entrySet()) {
            claimList.add(entry.getKey().getLocalClaim().getClaimUri());
        }
        return claimList;
    }

    public static Map<String, String> getClaimMappings(ClaimMapping[] claimMappings, boolean useLocalDialectAsKey) {
        HashMap<String, String> remoteToLocalClaimMap = new HashMap<String, String>();
        for (ClaimMapping claimMapping : claimMappings) {
            if (useLocalDialectAsKey) {
                remoteToLocalClaimMap.put(claimMapping.getLocalClaim().getClaimUri(), claimMapping.getRemoteClaim().getClaimUri());
                continue;
            }
            remoteToLocalClaimMap.put(claimMapping.getRemoteClaim().getClaimUri(), claimMapping.getLocalClaim().getClaimUri());
        }
        return remoteToLocalClaimMap;
    }

    public static Map<String, String> getClaimMappings(Map<ClaimMapping, String> claimMappings, boolean useLocalDialectAsKey) {
        HashMap<String, String> remoteToLocalClaimMap = new HashMap<String, String>();
        for (Map.Entry<ClaimMapping, String> entry : claimMappings.entrySet()) {
            ClaimMapping claimMapping = entry.getKey();
            if (useLocalDialectAsKey) {
                remoteToLocalClaimMap.put(claimMapping.getLocalClaim().getClaimUri(), entry.getValue());
                continue;
            }
            remoteToLocalClaimMap.put(claimMapping.getRemoteClaim().getClaimUri(), entry.getValue());
        }
        return remoteToLocalClaimMap;
    }

    public static Map<String, String> getLocalToSPClaimMappings(Map<String, String> claimMappings) {
        HashMap<String, String> remoteToLocalClaimMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : claimMappings.entrySet()) {
            remoteToLocalClaimMap.put(entry.getValue(), entry.getKey());
        }
        return remoteToLocalClaimMap;
    }

    public static String getQueryStringWithFrameworkContextId(String originalQueryStr, String callerContextId, String frameworkContextId) {
        String queryParams = originalQueryStr;
        queryParams = queryParams.replace(callerContextId, frameworkContextId);
        return queryParams;
    }

    public static List<String> getStepIdPs(StepConfig stepConfig) {
        ArrayList<String> stepIdps = new ArrayList<String>();
        List<AuthenticatorConfig> authenticatorConfigs = stepConfig.getAuthenticatorList();
        for (AuthenticatorConfig authenticatorConfig : authenticatorConfigs) {
            List<String> authenticatorIdps = authenticatorConfig.getIdpNames();
            for (String authenticatorIdp : authenticatorIdps) {
                stepIdps.add(authenticatorIdp);
            }
        }
        return stepIdps;
    }

    public static List<String> getAuthenticatedStepIdPs(List<String> stepIdPs, List<String> authenticatedIdPs) {
        ArrayList<String> idps = new ArrayList<String>();
        if (stepIdPs != null && authenticatedIdPs != null) {
            for (String stepIdP : stepIdPs) {
                if (!authenticatedIdPs.contains(stepIdP)) continue;
                idps.add(stepIdP);
                break;
            }
        }
        return idps;
    }

    public static Map<String, AuthenticatorConfig> getAuthenticatedStepIdPs(StepConfig stepConfig, Map<String, AuthenticatedIdPData> authenticatedIdPs) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Finding already authenticated IdPs of the step {order:%d}", stepConfig.getOrder()));
        }
        HashMap<String, AuthenticatorConfig> idpAuthenticatorMap = new HashMap<String, AuthenticatorConfig>();
        List<AuthenticatorConfig> authenticatorConfigs = stepConfig.getAuthenticatorList();
        if (authenticatedIdPs != null && !authenticatedIdPs.isEmpty()) {
            block0: for (AuthenticatorConfig authenticatorConfig : authenticatorConfigs) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Considering the authenticator '%s'", authenticatorConfig.getName()));
                }
                String authenticatorName = authenticatorConfig.getName();
                List<String> authenticatorIdps = authenticatorConfig.getIdpNames();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("%d IdP(s) found in the step.", authenticatedIdPs.size()));
                }
                for (String authenticatorIdp : authenticatorIdps) {
                    AuthenticatedIdPData authenticatedIdPData;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Considering the IDP : '%s'", authenticatorIdp));
                    }
                    if ((authenticatedIdPData = authenticatedIdPs.get(authenticatorIdp)) != null && authenticatedIdPData.getIdpName() != null && authenticatedIdPData.getIdpName().equals(authenticatorIdp)) {
                        if ("LOCAL".equals(authenticatedIdPData.getIdpName())) {
                            if (authenticatedIdPData.isAlreadyAuthenticatedUsing(authenticatorName, authenticatorConfig.getApplicationAuthenticator().getAuthMechanism())) {
                                idpAuthenticatorMap.put(authenticatorIdp, authenticatorConfig);
                                if (!log.isDebugEnabled()) continue block0;
                                log.debug((Object)String.format("('%s', '%s') is an already authenticated IDP - authenticator combination.", authenticatorConfig.getName(), authenticatorIdp));
                                continue block0;
                            }
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)String.format("('%s', '%s') is not an already authenticated IDP - authenticator combination.", authenticatorConfig.getName(), authenticatorIdp));
                            continue;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("'%s' is an already authenticated IDP.", authenticatorIdp));
                        }
                        idpAuthenticatorMap.put(authenticatorIdp, authenticatorConfig);
                        continue block0;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("'%s' is NOT an already authenticated IDP.", authenticatorIdp));
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"No authenticators found.");
        }
        return idpAuthenticatorMap;
    }

    public static String getAuthenticatorIdPMappingString(List<AuthenticatorConfig> authConfigList) {
        StringBuilder authenticatorIdPStr = new StringBuilder("");
        for (AuthenticatorConfig authConfig : authConfigList) {
            StringBuilder idpsOfAuthenticatorStr = new StringBuilder("");
            for (String idpName : authConfig.getIdpNames()) {
                IdentityProvider idp;
                if (idpName == null) continue;
                if (idpsOfAuthenticatorStr.length() != 0) {
                    idpsOfAuthenticatorStr.append(":");
                }
                if ((idp = authConfig.getIdps().get(idpName)) != null && idp.isFederationHub()) {
                    idpName = idpName + ".hub";
                }
                idpsOfAuthenticatorStr.append(idpName);
            }
            if (authenticatorIdPStr.length() != 0) {
                authenticatorIdPStr.append(";");
            }
            authenticatorIdPStr.append(authConfig.getName()).append(":").append((CharSequence)idpsOfAuthenticatorStr);
        }
        return authenticatorIdPStr.toString();
    }

    public static String getQueryStringWithConfiguredParams(HttpServletRequest request) {
        StringBuilder queryStrBuilder;
        block15: {
            Map reqParamMap;
            block13: {
                List<String> queryParams;
                block14: {
                    boolean configAvailable = FileBasedConfigurationBuilder.getInstance().isAuthEndpointQueryParamsConfigAvailable();
                    queryParams = FileBasedConfigurationBuilder.getInstance().getAuthEndpointQueryParams();
                    String action = FileBasedConfigurationBuilder.getInstance().getAuthEndpointQueryParamsAction();
                    queryStrBuilder = new StringBuilder("");
                    reqParamMap = request.getParameterMap();
                    if (!configAvailable) break block13;
                    if (action == null || !action.equals("exclude")) break block14;
                    if (reqParamMap == null) break block15;
                    for (Map.Entry entry : reqParamMap.entrySet()) {
                        String paramName = (String)entry.getKey();
                        String paramValue = ((String[])entry.getValue())[0];
                        if (SESSION_DATA_KEY.equals(paramName) || "relyingParty".equals(paramName) || "type".equals(paramName) || IdentityTenantUtil.isTenantQualifiedUrlsEnabled() && TENANT_DOMAIN.equals(paramName) || queryParams.contains(paramName)) continue;
                        if (queryStrBuilder.length() > 0) {
                            queryStrBuilder.append('&');
                        }
                        try {
                            queryStrBuilder.append(URLEncoder.encode(paramName, UTF_8)).append('=').append(URLEncoder.encode(paramValue, UTF_8));
                        }
                        catch (UnsupportedEncodingException e) {
                            log.error((Object)"Error while URL Encoding query param to be sent to the AuthenticationEndpoint", (Throwable)e);
                        }
                    }
                    break block15;
                }
                for (String param : queryParams) {
                    String paramValue = request.getParameter(param);
                    if (paramValue == null) continue;
                    if (queryStrBuilder.length() > 0) {
                        queryStrBuilder.append('&');
                    }
                    try {
                        queryStrBuilder.append(URLEncoder.encode(param, UTF_8)).append('=').append(URLEncoder.encode(paramValue, UTF_8));
                    }
                    catch (UnsupportedEncodingException e) {
                        log.error((Object)"Error while URL Encoding query param to be sent to the AuthenticationEndpoint", (Throwable)e);
                    }
                }
                break block15;
            }
            if (reqParamMap != null) {
                for (Map.Entry entry : reqParamMap.entrySet()) {
                    String paramName = (String)entry.getKey();
                    String paramValue = ((String[])entry.getValue())[0];
                    if (SESSION_DATA_KEY.equals(paramName) || "relyingParty".equals(paramName) || "type".equals(paramName) || IdentityTenantUtil.isTenantQualifiedUrlsEnabled() && TENANT_DOMAIN.equals(paramName)) continue;
                    if (queryStrBuilder.length() > 0) {
                        queryStrBuilder.append('&');
                    }
                    try {
                        queryStrBuilder.append(URLEncoder.encode(paramName, UTF_8)).append('=').append(URLEncoder.encode(paramValue, UTF_8));
                    }
                    catch (UnsupportedEncodingException e) {
                        log.error((Object)"Error while URL Encoding query param to be sent to the AuthenticationEndpoint", (Throwable)e);
                    }
                }
            }
        }
        return queryStrBuilder.toString();
    }

    public static String getRedirectURLWithFilteredParams(String redirectUrl, AuthenticationContext context) {
        return FrameworkUtils.getRedirectURLWithFilteredParams(redirectUrl, context.getEndpointParams());
    }

    public static String getRedirectURLWithFilteredParams(String redirectUrl, Map<String, Serializable> dataStoreMap) {
        URIBuilder uriBuilder;
        boolean configAvailable = FileBasedConfigurationBuilder.getInstance().isAuthEndpointRedirectParamsConfigAvailable();
        if (!configAvailable) {
            return redirectUrl;
        }
        List<String> queryParams = FileBasedConfigurationBuilder.getInstance().getAuthEndpointRedirectParams();
        String action = FileBasedConfigurationBuilder.getInstance().getAuthEndpointRedirectParamsAction();
        try {
            uriBuilder = new URIBuilder(redirectUrl);
        }
        catch (URISyntaxException e) {
            log.warn((Object)("Unable to filter redirect params for url." + redirectUrl), (Throwable)e);
            return redirectUrl;
        }
        List<String> filteringEnabledHosts = FileBasedConfigurationBuilder.getInstance().getFilteringEnabledHostNames();
        if (CollectionUtils.isNotEmpty(filteringEnabledHosts) && !filteringEnabledHosts.contains(uriBuilder.getHost())) {
            return redirectUrl;
        }
        List queryParamsList = uriBuilder.getQueryParams();
        if (action != null && action.equals("exclude")) {
            if (queryParamsList != null) {
                Iterator iterator = queryParamsList.iterator();
                while (iterator.hasNext()) {
                    NameValuePair nameValuePair = (NameValuePair)iterator.next();
                    String paramName = nameValuePair.getName();
                    String paramValue = nameValuePair.getValue();
                    if (SESSION_DATA_KEY.equals(paramName) || !queryParams.contains(paramName)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(paramName + " is in exclude list, hence removing from url and making available via API"));
                    }
                    dataStoreMap.put(paramName, (Serializable)((Object)paramValue));
                    iterator.remove();
                }
            }
        } else if (queryParamsList != null) {
            Iterator iterator = queryParamsList.iterator();
            while (iterator.hasNext()) {
                NameValuePair nameValuePair = (NameValuePair)iterator.next();
                String paramName = nameValuePair.getName();
                String paramValue = nameValuePair.getValue();
                if (SESSION_DATA_KEY.equals(paramName) || queryParams.contains(paramName)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(paramName + " is not in include list, hence removing from url and making available via API"));
                }
                dataStoreMap.put(paramName, (Serializable)((Object)paramValue));
                iterator.remove();
            }
        }
        uriBuilder.clearParameters();
        uriBuilder.setParameters(queryParamsList);
        return uriBuilder.toString();
    }

    public static boolean isRemoveAPIParamsOnConsume() {
        return FileBasedConfigurationBuilder.getInstance().isRemoveAPIParametersOnConsume();
    }

    public static int getMaxInactiveInterval() {
        return maxInactiveInterval;
    }

    public static void setMaxInactiveInterval(int maxInactiveInterval) {
        FrameworkUtils.maxInactiveInterval = maxInactiveInterval;
    }

    public static String prependUserStoreDomainToName(String authenticatedSubject) {
        if (authenticatedSubject == null || authenticatedSubject.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid argument. authenticatedSubject : " + authenticatedSubject);
        }
        if (!authenticatedSubject.contains(CarbonConstants.DOMAIN_SEPARATOR)) {
            if (UserCoreUtil.getDomainFromThreadLocal() != null && !UserCoreUtil.getDomainFromThreadLocal().isEmpty()) {
                authenticatedSubject = UserCoreUtil.getDomainFromThreadLocal() + CarbonConstants.DOMAIN_SEPARATOR + authenticatedSubject;
            }
        } else if (authenticatedSubject.indexOf(CarbonConstants.DOMAIN_SEPARATOR) == 0) {
            throw new IllegalArgumentException("Invalid argument. authenticatedSubject : " + authenticatedSubject + " begins with '" + CarbonConstants.DOMAIN_SEPARATOR + "'");
        }
        return authenticatedSubject;
    }

    public static String getFederatedSubjectFromClaims(IdentityProvider identityProvider, Map<ClaimMapping, String> claimMappings) {
        String userIdClaimURI = identityProvider.getClaimConfig().getUserClaimURI();
        ClaimMapping claimMapping = new ClaimMapping();
        Claim claim = new Claim();
        claim.setClaimUri(userIdClaimURI);
        claimMapping.setRemoteClaim(claim);
        claimMapping.setLocalClaim(claim);
        return claimMappings.get(claimMapping);
    }

    public static String getFederatedSubjectFromClaims(AuthenticationContext context, String otherDialect) throws FrameworkException {
        String value;
        boolean useLocalClaimDialect = context.getExternalIdP().useDefaultLocalIdpDialect();
        String userIdClaimURI = context.getExternalIdP().getUserIdClaimUri();
        Map<ClaimMapping, String> claimMappings = context.getSubject().getUserAttributes();
        if (useLocalClaimDialect) {
            Map<String, String> extAttributesValueMap = FrameworkUtils.getClaimMappings(claimMappings, false);
            Map mappedAttrs = null;
            try {
                mappedAttrs = ClaimMetadataHandler.getInstance().getMappingsMapFromOtherDialectToCarbon(otherDialect, extAttributesValueMap.keySet(), context.getTenantDomain(), true);
            }
            catch (ClaimMetadataException e) {
                throw new FrameworkException("Error while loading claim mappings.", e);
            }
            String spUserIdClaimURI = (String)mappedAttrs.get(userIdClaimURI);
            value = extAttributesValueMap.get(spUserIdClaimURI);
        } else {
            ClaimMapping claimMapping = new ClaimMapping();
            Claim claim = new Claim();
            claim.setClaimUri(userIdClaimURI);
            claimMapping.setRemoteClaim(claim);
            claimMapping.setLocalClaim(claim);
            value = claimMappings.get(claimMapping);
        }
        return value;
    }

    public static void startTenantFlow(String tenantDomain) {
        String tenantDomainParam = tenantDomain;
        int tenantId = -1234;
        if (tenantDomainParam != null && !tenantDomainParam.trim().isEmpty()) {
            try {
                tenantId = FrameworkServiceComponent.getRealmService().getTenantManager().getTenantId(tenantDomain);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                log.error((Object)"Error while getting tenantId from tenantDomain query param", (Throwable)e);
            }
        } else {
            tenantDomainParam = "carbon.super";
        }
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        carbonContext.setTenantId(tenantId);
        carbonContext.setTenantDomain(tenantDomainParam);
    }

    public static void endTenantFlow() {
        PrivilegedCarbonContext.endTenantFlow();
    }

    public static long getCurrentStandardNano() {
        long epochTimeReference = TimeUnit.MILLISECONDS.toNanos(FrameworkServiceDataHolder.getInstance().getUnixTimeReference());
        long currentSystemNano = System.nanoTime();
        long currentStandardNano = epochTimeReference + (currentSystemNano - FrameworkServiceDataHolder.getInstance().getNanoTimeReference());
        return currentStandardNano;
    }

    public static String appendQueryParamsStringToUrl(String url, String queryParamString) {
        String queryAppendedUrl = url;
        if (StringUtils.isNotEmpty((String)queryParamString)) {
            String appender = url.contains("?") ? QUERY_SEPARATOR : "?";
            if (queryParamString.startsWith("?") || queryParamString.startsWith(QUERY_SEPARATOR)) {
                queryParamString = queryParamString.substring(1);
            }
            queryAppendedUrl = queryAppendedUrl + appender + queryParamString;
        }
        return queryAppendedUrl;
    }

    @Deprecated
    public static String appendQueryParamsToUrl(String url, Map<String, String> queryParams) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException("Passed URL is empty.");
        }
        if (queryParams == null) {
            throw new IllegalArgumentException("Passed query param map is empty.");
        }
        ArrayList<String> queryParam1 = new ArrayList<String>();
        for (Map.Entry<String, String> entry : queryParams.entrySet()) {
            String encodedValue = URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.name());
            queryParam1.add(entry.getKey() + EQUAL + encodedValue);
        }
        String queryString = StringUtils.join(queryParam1, (String)QUERY_SEPARATOR);
        return FrameworkUtils.appendQueryParamsStringToUrl(url, queryString);
    }

    public static String buildURLWithQueryParams(String url, Map<String, String> queryParams) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException("Passed URL is empty.");
        }
        if (MapUtils.isEmpty(queryParams)) {
            return url;
        }
        ArrayList<String> queryParam1 = new ArrayList<String>();
        for (Map.Entry<String, String> entry : queryParams.entrySet()) {
            String encodedValue = URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.name());
            queryParam1.add(entry.getKey() + EQUAL + encodedValue);
        }
        String queryString = StringUtils.join(queryParam1, (String)QUERY_SEPARATOR);
        return FrameworkUtils.appendQueryParamsStringToUrl(url, queryString);
    }

    public static void publishSessionEvent(String sessionId, HttpServletRequest request, AuthenticationContext context, SessionContext sessionContext, AuthenticatedUser user, String status) {
        AuthenticationDataPublisher authnDataPublisherProxy = FrameworkServiceDataHolder.getInstance().getAuthnDataPublisherProxy();
        if (authnDataPublisherProxy != null && authnDataPublisherProxy.isEnabled(context)) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("user", (Object)user);
            paramMap.put("sessionId", sessionId);
            String isPublishingSessionCountEnabledValue = IdentityUtil.getProperty((String)"Analytics.PublishActiveSessionCount");
            boolean isPublishingSessionCountEnabled = Boolean.parseBoolean(isPublishingSessionCountEnabledValue);
            if (isPublishingSessionCountEnabled) {
                paramMap.put("activeSessionCount", FrameworkUtils.getActiveSessionCount(user.getTenantDomain()));
            }
            Map<String, Object> unmodifiableParamMap = Collections.unmodifiableMap(paramMap);
            if ("sessionCreated".equalsIgnoreCase(status)) {
                authnDataPublisherProxy.publishSessionCreation(request, context, sessionContext, unmodifiableParamMap);
            } else if ("sessionUpdated".equalsIgnoreCase(status)) {
                authnDataPublisherProxy.publishSessionUpdate(request, context, sessionContext, unmodifiableParamMap);
            } else if ("sessionTerminated".equalsIgnoreCase(status)) {
                authnDataPublisherProxy.publishSessionTermination(request, context, sessionContext, unmodifiableParamMap);
            }
        }
    }

    private static int getActiveSessionCount(String tenantDomain) {
        int activeSessionCount = 0;
        try {
            if (FrameworkServiceDataHolder.getInstance().isUserSessionMappingEnabled()) {
                activeSessionCount = UserSessionStore.getInstance().getActiveSessionCount(tenantDomain);
            }
        }
        catch (UserSessionException e) {
            activeSessionCount = -1;
            log.error((Object)"An error occurred while retrieving the active session count. Therefore the active session count is set to -1 in the analytics event.");
        }
        return activeSessionCount;
    }

    private static void updateCookieConfig(CookieBuilder cookieBuilder, IdentityCookieConfig cookieConfig, Integer age) {
        if (cookieConfig.getDomain() != null) {
            cookieBuilder.setDomain(cookieConfig.getDomain());
        }
        if (cookieConfig.getPath() != null) {
            cookieBuilder.setPath(cookieConfig.getPath());
        }
        if (cookieConfig.getComment() != null) {
            cookieBuilder.setComment(cookieConfig.getComment());
        }
        if (cookieConfig.getMaxAge() > 0) {
            cookieBuilder.setMaxAge(cookieConfig.getMaxAge());
        } else if (age != null) {
            cookieBuilder.setMaxAge(age.intValue());
        }
        if (cookieConfig.getVersion() > 0) {
            cookieBuilder.setVersion(cookieConfig.getVersion());
        }
        if (cookieConfig.getSameSite() != null) {
            cookieBuilder.setSameSite(cookieConfig.getSameSite());
        }
        cookieBuilder.setHttpOnly(cookieConfig.isHttpOnly());
        cookieBuilder.setSecure(cookieConfig.isSecure());
    }

    public static String getMultiAttributeSeparator() {
        String multiAttributeSeparator;
        block4: {
            multiAttributeSeparator = null;
            try {
                multiAttributeSeparator = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getRealmConfiguration().getUserStoreProperty("MultiAttributeSeparator");
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                log.warn((Object)"Error while retrieving MultiAttributeSeparator from UserRealm.");
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)"Error while retrieving MultiAttributeSeparator from UserRealm.", (Throwable)e);
            }
        }
        if (StringUtils.isBlank((String)multiAttributeSeparator)) {
            multiAttributeSeparator = ",,,";
            if (log.isDebugEnabled()) {
                log.debug((Object)("Multi Attribute Separator is defaulting to " + multiAttributeSeparator));
            }
        }
        return multiAttributeSeparator;
    }

    public static String getPASTRCookieName(String sessionDataKey) {
        return "pastr-" + sessionDataKey;
    }

    public static List<String> getIdentityProvideMappedUserRoles(ExternalIdPConfig externalIdPConfig, Map<String, String> extAttributesValueMap, String idpRoleClaimUri, Boolean excludeUnmapped) {
        String federatedIDPRoleClaimAttributeSeparator;
        if (idpRoleClaimUri == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Role claim uri is not configured for the external IDP: " + externalIdPConfig.getIdPName() + ", in Domain: " + externalIdPConfig.getDomain() + "."));
            }
            return new ArrayList<String>();
        }
        String idpRoleAttrValue = null;
        if (extAttributesValueMap != null) {
            idpRoleAttrValue = extAttributesValueMap.get(idpRoleClaimUri);
        }
        if (idpRoleAttrValue != null) {
            if (IdentityUtil.getProperty((String)"FederatedIDPRoleClaimValueAttributeSeparator") != null) {
                federatedIDPRoleClaimAttributeSeparator = IdentityUtil.getProperty((String)"FederatedIDPRoleClaimValueAttributeSeparator");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The IDP side role claim value separator is configured as : " + federatedIDPRoleClaimAttributeSeparator));
                }
            } else {
                federatedIDPRoleClaimAttributeSeparator = FrameworkUtils.getMultiAttributeSeparator();
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No role attribute value has received from the external IDP: " + externalIdPConfig.getIdPName() + ", in Domain: " + externalIdPConfig.getDomain() + "."));
            }
            return new ArrayList<String>();
        }
        String[] idpRoles = idpRoleAttrValue.split(federatedIDPRoleClaimAttributeSeparator);
        Map<String, String> idpToLocalRoleMapping = externalIdPConfig.getRoleMappings();
        HashSet<String> idpMappedUserRoles = new HashSet<String>();
        if (MapUtils.isEmpty(idpToLocalRoleMapping)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No role mapping is configured in the external IDP: " + externalIdPConfig.getIdPName() + ", in Domain: " + externalIdPConfig.getDomain() + "."));
            }
            if (excludeUnmapped.booleanValue()) {
                return new ArrayList<String>();
            }
            idpMappedUserRoles.addAll(Arrays.asList(idpRoles));
            return new ArrayList<String>(idpMappedUserRoles);
        }
        for (String idpRole : idpRoles) {
            if (idpToLocalRoleMapping.containsKey(idpRole)) {
                idpMappedUserRoles.add(idpToLocalRoleMapping.get(idpRole));
                continue;
            }
            if (excludeUnmapped.booleanValue()) continue;
            idpMappedUserRoles.add(idpRole);
        }
        return new ArrayList<String>(idpMappedUserRoles);
    }

    public static String getIdpRoleClaimUri(ExternalIdPConfig externalIdPConfig) {
        ClaimMapping[] idpToLocalClaimMapping;
        String idpRoleClaimUri = externalIdPConfig.getRoleClaimUri();
        if ((idpRoleClaimUri == null || idpRoleClaimUri.isEmpty()) && (idpToLocalClaimMapping = externalIdPConfig.getClaimMappings()) != null && idpToLocalClaimMapping.length > 0) {
            for (ClaimMapping mapping : idpToLocalClaimMapping) {
                if (!"http://wso2.org/claims/role".equals(mapping.getLocalClaim().getClaimUri()) || mapping.getRemoteClaim() == null) continue;
                return mapping.getRemoteClaim().getClaimUri();
            }
        }
        return idpRoleClaimUri;
    }

    public static String getMappedIdpRoleClaimUri(String idpRoleClaimUri, StepConfig stepConfig, AuthenticationContext context) {
        String idpRoleMappingURI;
        block5: {
            idpRoleMappingURI = idpRoleClaimUri;
            ApplicationAuthenticator authenticator = stepConfig.getAuthenticatedAutenticator().getApplicationAuthenticator();
            boolean useDefaultIdpDialect = context.getExternalIdP().useDefaultLocalIdpDialect();
            boolean useLocalClaimDialectForClaimMappings = FileBasedConfigurationBuilder.getInstance().isCustomClaimMappingsForAuthenticatorsAllowed();
            Map carbonToStandardClaimMapping = new HashMap();
            if (useDefaultIdpDialect || useLocalClaimDialectForClaimMappings) {
                String idPStandardDialect = authenticator.getClaimDialectURI();
                try {
                    if (StringUtils.isNotBlank((String)idPStandardDialect)) {
                        carbonToStandardClaimMapping = ClaimMetadataHandler.getInstance().getMappingsMapFromOtherDialectToCarbon(idPStandardDialect, null, context.getTenantDomain(), false);
                    }
                    for (Map.Entry entry : carbonToStandardClaimMapping.entrySet()) {
                        if (!idpRoleMappingURI.equalsIgnoreCase((String)entry.getValue())) continue;
                        idpRoleMappingURI = (String)entry.getKey();
                    }
                }
                catch (ClaimMetadataException e) {
                    if (!log.isDebugEnabled()) break block5;
                    log.debug((Object)("Error in getting the mapping between idps and standard dialect.Thus returning the unmapped RoleClaimUri: " + idpRoleMappingURI), (Throwable)e);
                }
            }
        }
        return idpRoleMappingURI;
    }

    public static String getLocalClaimUriMappedForIdPRoleClaim(ExternalIdPConfig externalIdPConfig) {
        Object[] idpToLocalClaimMapping;
        String idpRoleClaimUri = externalIdPConfig.getRoleClaimUri();
        if (StringUtils.isNotBlank((String)idpRoleClaimUri) && !ArrayUtils.isEmpty((Object[])(idpToLocalClaimMapping = externalIdPConfig.getClaimMappings()))) {
            for (Object mapping : idpToLocalClaimMapping) {
                if (mapping.getRemoteClaim() == null || !idpRoleClaimUri.equals(mapping.getRemoteClaim().getClaimUri())) continue;
                return mapping.getLocalClaim().getClaimUri();
            }
        }
        return "http://wso2.org/claims/role";
    }

    @Deprecated
    public static boolean isStepBasedSequenceHandlerExecuted(AuthenticationContext context) {
        boolean isNeeded = true;
        SequenceConfig sequenceConfig = context.getSequenceConfig();
        AuthenticatedUser authenticatedUser = sequenceConfig.getAuthenticatedUser();
        Object isDefaultStepBasedSequenceHandlerTriggered = context.getProperty("stepBasedSequenceHandlerTriggered");
        if (authenticatedUser == null || isDefaultStepBasedSequenceHandlerTriggered == null || !((Boolean)isDefaultStepBasedSequenceHandlerTriggered).booleanValue()) {
            isNeeded = false;
        }
        return isNeeded;
    }

    public static String[] getMissingClaims(AuthenticationContext context) {
        StringBuilder missingClaimsString = new StringBuilder();
        StringBuilder missingClaimValuesString = new StringBuilder();
        Map<String, String> missingClaims = FrameworkUtils.getMissingClaimsMap(context);
        for (Map.Entry<String, String> entry : missingClaims.entrySet()) {
            missingClaimsString.append(entry.getKey());
            missingClaimValuesString.append(entry.getValue());
            missingClaimsString.append(",");
            missingClaimValuesString.append(",");
        }
        return new String[]{missingClaimsString.toString(), missingClaimValuesString.toString()};
    }

    public static Map<String, String> getMissingClaimsMap(AuthenticationContext context) {
        HashMap<String, String> mappedAttrs = new HashMap<String, String>();
        AuthenticatedUser user = context.getSequenceConfig().getAuthenticatedUser();
        Map<ClaimMapping, String> userAttributes = user.getUserAttributes();
        if (userAttributes != null) {
            Map spToCarbonClaimMapping = new HashMap();
            Object object = context.getProperty("SP_TO_CARBON_CLAIM_MAPPING");
            if (object instanceof Map) {
                spToCarbonClaimMapping = (Map)object;
            }
            for (Map.Entry<String, String> entry : userAttributes.entrySet()) {
                String localClaimUri = ((ClaimMapping)entry.getKey()).getLocalClaim().getClaimUri();
                if (MapUtils.isNotEmpty(spToCarbonClaimMapping) && spToCarbonClaimMapping.get(localClaimUri) != null) {
                    localClaimUri = (String)spToCarbonClaimMapping.get(localClaimUri);
                }
                mappedAttrs.put(localClaimUri, entry.getValue());
            }
        }
        Map<String, String> mandatoryClaims = context.getSequenceConfig().getApplicationConfig().getMandatoryClaimMappings();
        HashMap<String, String> missingClaims = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : mandatoryClaims.entrySet()) {
            if (mappedAttrs.get(entry.getValue()) != null || mappedAttrs.get(entry.getKey()) != null || FrameworkUtils.getUserClaimValue(context, entry.getValue()) != null) continue;
            missingClaims.put(entry.getKey(), entry.getValue());
        }
        return missingClaims;
    }

    private static String getUserClaimValue(AuthenticationContext context, String localClaim) {
        Object unFilteredLocalClaims = context.getProperty("UNFILTERED_LOCAL_CLAIM_VALUES");
        if (unFilteredLocalClaims instanceof Map) {
            return (String)((Map)unFilteredLocalClaims).get(localClaim);
        }
        return null;
    }

    public static String getPasswordProvisioningUIUrl() {
        String passwordProvisioningUrl = IdentityUtil.getProperty((String)"JITProvisioning.PasswordProvisioningUI");
        if (StringUtils.isEmpty((String)passwordProvisioningUrl)) {
            passwordProvisioningUrl = "/accountrecoveryendpoint/signup.do";
        }
        return passwordProvisioningUrl;
    }

    public static String getUserNameProvisioningUIUrl() {
        String userNamePrvisioningUrl = IdentityUtil.getProperty((String)"JITProvisioning.UserNameProvisioningUI");
        if (StringUtils.isEmpty((String)userNamePrvisioningUrl)) {
            userNamePrvisioningUrl = "/accountrecoveryendpoint/register.do";
        }
        return userNamePrvisioningUrl;
    }

    public static boolean promptOnLongWait() {
        boolean promptOnLongWait = false;
        String promptOnLongWaitString = IdentityUtil.getProperty((String)"AdaptiveAuth.PromptOnLongWait");
        if (promptOnLongWaitString != null) {
            promptOnLongWait = Boolean.parseBoolean(promptOnLongWaitString);
        }
        return promptOnLongWait;
    }

    public static String getStandardDialect(String clientType, ApplicationConfig appConfig) {
        Map<String, String> claimMappings = appConfig.getClaimMappings();
        if ("oidc".equals(clientType)) {
            return "http://wso2.org/oidc/claim";
        }
        if ("sts".equals(clientType)) {
            return "http://schemas.xmlsoap.org/ws/2005/05/identity";
        }
        if ("openid".equals(clientType)) {
            return "http://axschema.org";
        }
        if ("scim".equals(clientType)) {
            return "urn:scim:schemas:core:1.0";
        }
        if ("wso2".equals(clientType)) {
            return "http://wso2.org/claims";
        }
        if (claimMappings == null || claimMappings.isEmpty()) {
            return "http://wso2.org/claims";
        }
        boolean isAtLeastOneNotEqual = false;
        for (Map.Entry<String, String> entry : claimMappings.entrySet()) {
            if (entry.getKey().equals(entry.getValue())) continue;
            isAtLeastOneNotEqual = true;
            break;
        }
        if (!isAtLeastOneNotEqual) {
            return "http://wso2.org/claims";
        }
        return null;
    }

    public static Object toJsSerializable(Object value) {
        if (value instanceof Serializable) {
            if (value instanceof HashMap) {
                HashMap map = new HashMap();
                ((HashMap)value).forEach((k, v) -> map.put((String)k, FrameworkUtils.toJsSerializable(v)));
                return map;
            }
            return value;
        }
        if (value instanceof ScriptObjectMirror) {
            ScriptObjectMirror scriptObjectMirror = (ScriptObjectMirror)value;
            if (scriptObjectMirror.isFunction()) {
                return SerializableJsFunction.toSerializableForm(scriptObjectMirror);
            }
            if (scriptObjectMirror.isArray()) {
                ArrayList arrayItems = new ArrayList(scriptObjectMirror.size());
                scriptObjectMirror.values().forEach(v -> {
                    Object serializedObj = FrameworkUtils.toJsSerializable(v);
                    if (serializedObj instanceof Serializable) {
                        arrayItems.add((Serializable)serializedObj);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Serialized the value of array item as : " + serializedObj));
                        }
                    } else {
                        log.warn((Object)String.format("Non serializable array item: %s. and will not be persisted.", serializedObj));
                    }
                });
                return arrayItems;
            }
            if (!scriptObjectMirror.isEmpty()) {
                HashMap serializedMap = new HashMap();
                scriptObjectMirror.forEach((k, v) -> {
                    Object serializedObj = FrameworkUtils.toJsSerializable(v);
                    if (serializedObj instanceof Serializable) {
                        serializedMap.put(k, (Serializable)serializedObj);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Serialized the value for key : " + k));
                        }
                    } else {
                        log.warn((Object)String.format("Non serializable object for key : %s, and will not be persisted.", k));
                    }
                });
                return serializedMap;
            }
            return Collections.EMPTY_MAP;
        }
        return value;
    }

    public static Object fromJsSerializable(Object value, ScriptEngine engine) throws FrameworkException {
        if (value instanceof SerializableJsFunction) {
            SerializableJsFunction serializableJsFunction = (SerializableJsFunction)value;
            try {
                return engine.eval(serializableJsFunction.getSource());
            }
            catch (ScriptException e) {
                throw new FrameworkException("Error in resurrecting a Javascript Function : " + serializableJsFunction);
            }
        }
        if (value instanceof Map) {
            HashMap deserializedMap = new HashMap();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                Object deserializedObj = FrameworkUtils.fromJsSerializable(entry.getValue(), engine);
                deserializedMap.put(entry.getKey(), deserializedObj);
            }
            return deserializedMap;
        }
        return value;
    }

    private static Property[] getResidentIdpConfiguration(String tenantDomain) throws FrameworkException {
        IdentityProviderManager identityProviderManager = IdentityProviderManager.getInstance();
        IdentityProvider residentIdp = null;
        try {
            residentIdp = identityProviderManager.getResidentIdP(tenantDomain);
        }
        catch (IdentityProviderManagementException e) {
            String errorMsg = String.format("Error while retrieving resident Idp for %s tenant.", tenantDomain);
            throw new FrameworkException(errorMsg, e);
        }
        IdentityProviderProperty[] identityMgtProperties = residentIdp.getIdpProperties();
        Property[] configMap = new Property[identityMgtProperties.length];
        int index = 0;
        for (IdentityProviderProperty identityMgtProperty : identityMgtProperties) {
            if (ALREADY_WRITTEN_PROPERTY.equals(identityMgtProperty.getName())) continue;
            Property property = new Property();
            property.setName(identityMgtProperty.getName());
            property.setValue(identityMgtProperty.getValue());
            configMap[index] = property;
            ++index;
        }
        return configMap;
    }

    public static Property getResidentIdpConfiguration(String propertyName, String tenantDomain) throws FrameworkException {
        Property requestedProperty = null;
        Property[] allProperties = FrameworkUtils.getResidentIdpConfiguration(tenantDomain);
        for (int i = 0; i < allProperties.length; ++i) {
            if (!propertyName.equals(allProperties[i].getName())) continue;
            requestedProperty = allProperties[i];
            break;
        }
        return requestedProperty;
    }

    public static boolean isUserSessionMappingEnabled() {
        return Boolean.parseBoolean(IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.UserSessionMapping.Enable")) && FrameworkUtils.isTableExists("IDN_AUTH_USER") && FrameworkUtils.isTableExists("IDN_AUTH_USER_SESSION_MAPPING");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isTableExists(String tableName) {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            if (metaData.storesLowerCaseIdentifiers()) {
                tableName = tableName.toLowerCase();
            }
            try {
                Throwable throwable;
                ResultSet resultSet;
                block41: {
                    boolean bl;
                    block42: {
                        resultSet = metaData.getTables(null, null, tableName, new String[]{"TABLE"});
                        throwable = null;
                        if (!resultSet.next()) break block41;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Table - " + tableName + " available in the Identity database."));
                        }
                        IdentityDatabaseUtil.commitTransaction((Connection)connection);
                        bl = true;
                        if (resultSet == null) return bl;
                        if (throwable == null) break block42;
                        try {
                            resultSet.close();
                            return bl;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return bl;
                        }
                    }
                    resultSet.close();
                    return bl;
                }
                try {
                    IdentityDatabaseUtil.commitTransaction((Connection)connection);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (resultSet != null) {
                        if (throwable != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            resultSet.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Table - " + tableName + " not available in the Identity database."));
                }
                boolean bl = false;
                if (connection == null) return bl;
                if (var2_3 == null) {
                    connection.close();
                    return bl;
                }
                try {
                    connection.close();
                    return bl;
                }
                catch (Throwable throwable) {
                    var2_3.addSuppressed(throwable);
                    return bl;
                }
            }
        }
        catch (SQLException e) {
            if (!log.isDebugEnabled()) return false;
            log.debug((Object)("Table - " + tableName + " not available in the Identity database."));
            return false;
        }
        if (!log.isDebugEnabled()) return false;
        log.debug((Object)("Table - " + tableName + " not available in the Identity database."));
        return false;
    }

    public static boolean isConsentPageSkippedForSP(ServiceProvider serviceProvider) {
        if (serviceProvider == null) {
            throw new IllegalArgumentException("A null reference received for service provider.");
        }
        boolean isSkipConsent = false;
        if (serviceProvider.getLocalAndOutBoundAuthenticationConfig() != null) {
            isSkipConsent = serviceProvider.getLocalAndOutBoundAuthenticationConfig().isSkipConsent();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("SkipConsent: " + isSkipConsent + " for application: " + serviceProvider.getApplicationName() + " with id: " + serviceProvider.getApplicationID()));
        }
        return isSkipConsent;
    }

    public static boolean isLogoutConsentPageSkippedForSP(ServiceProvider serviceProvider) {
        if (serviceProvider == null) {
            throw new IllegalArgumentException("A null reference received for service provider.");
        }
        boolean isSkipLogoutConsent = false;
        if (serviceProvider.getLocalAndOutBoundAuthenticationConfig() != null) {
            isSkipLogoutConsent = serviceProvider.getLocalAndOutBoundAuthenticationConfig().isSkipLogoutConsent();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("SkipLogoutConsent: " + isSkipLogoutConsent + " for application: " + serviceProvider.getApplicationName() + " with id: " + serviceProvider.getApplicationID()));
        }
        return isSkipLogoutConsent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isTableColumnExists(String tableName, String columnName) {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            if (metaData.storesLowerCaseIdentifiers()) {
                tableName = tableName.toLowerCase();
                columnName = columnName.toLowerCase();
            }
            String schemaPattern = null;
            if (metaData.getDriverName().contains("Oracle")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("DB type detected as Oracle. Setting schemaPattern to " + metaData.getUserName()));
                }
                schemaPattern = metaData.getUserName();
            }
            try {
                Throwable throwable;
                ResultSet resultSet;
                block43: {
                    boolean bl;
                    block44: {
                        resultSet = metaData.getColumns(null, schemaPattern, tableName, columnName);
                        throwable = null;
                        if (!resultSet.next()) break block43;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Column - " + columnName + " in table - " + tableName + " is available in the Identity database."));
                        }
                        IdentityDatabaseUtil.commitTransaction((Connection)connection);
                        bl = true;
                        if (resultSet == null) return bl;
                        if (throwable == null) break block44;
                        try {
                            resultSet.close();
                            return bl;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return bl;
                        }
                    }
                    resultSet.close();
                    return bl;
                }
                try {
                    IdentityDatabaseUtil.commitTransaction((Connection)connection);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (resultSet != null) {
                        if (throwable != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            resultSet.close();
                        }
                    }
                }
            }
            catch (SQLException ex) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Column - " + columnName + " in table - " + tableName + " is not available in the Identity database."));
                }
                boolean bl = false;
                if (connection == null) return bl;
                if (var3_4 == null) {
                    connection.close();
                    return bl;
                }
                try {
                    connection.close();
                    return bl;
                }
                catch (Throwable throwable) {
                    var3_4.addSuppressed(throwable);
                    return bl;
                }
            }
        }
        catch (SQLException e) {
            if (!log.isDebugEnabled()) return false;
            log.debug((Object)("Column - " + columnName + " in table - " + tableName + " is not available in the Identity database."));
            return false;
        }
        if (!log.isDebugEnabled()) return false;
        log.debug((Object)("Column - " + columnName + " in table - " + tableName + " is not available in the Identity database."));
        return false;
    }

    public static String removeDomainFromNamesExcludeHybrid(List<String> domainAwareRolesList) {
        ArrayList<String> roleList = new ArrayList<String>();
        for (String role : domainAwareRolesList) {
            String userStoreDomain = IdentityUtil.extractDomainFromName((String)role);
            if ("Internal".equalsIgnoreCase(userStoreDomain) || "Application".equalsIgnoreCase(userStoreDomain) || "Workflow".equalsIgnoreCase(userStoreDomain)) {
                roleList.add(role);
                continue;
            }
            roleList.add(UserCoreUtil.removeDomainFromName((String)role));
        }
        return String.join((CharSequence)FrameworkUtils.getMultiAttributeSeparator(), roleList);
    }

    public static FederatedAssociationManager getFederatedAssociationManager() throws FrameworkException {
        FederatedAssociationManager federatedAssociationManager = FrameworkServiceDataHolder.getInstance().getFederatedAssociationManager();
        if (federatedAssociationManager == null) {
            throw new FrameworkException("Federated Association Manager service is not available.");
        }
        return federatedAssociationManager;
    }

    public static String resolveUserIdFromUsername(int tenantId, String userStoreDomain, String username) throws UserSessionException {
        try {
            if (userStoreDomain == null) {
                userStoreDomain = "PRIMARY";
            }
            org.wso2.carbon.user.api.UserStoreManager userStoreManager = FrameworkUtils.getUserStoreManager(tenantId, userStoreDomain);
            try {
                if (userStoreManager instanceof AbstractUserStoreManager) {
                    String userId = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(username);
                    if (StringUtils.isBlank((String)userId) && !userStoreManager.isReadOnly()) {
                        userId = FrameworkUtils.addUserId(username, userStoreManager);
                    }
                    return userId;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Provided user store manager for the user: " + username + ", is not an instance of the AbstractUserStore manager"));
                }
                throw new UserSessionException("Unable to get the unique id of the user: " + username + ".");
            }
            catch (UserStoreException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Error occurred while resolving Id for the user: " + username), (Throwable)e);
                }
                throw new UserSessionException("Error occurred while resolving Id for the user: " + username, e);
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserSessionException("Error occurred while retrieving the userstore manager to resolve Id for the user: " + username, e);
        }
    }

    public static String preprocessUsername(String username, AuthenticationContext context) {
        boolean isSaaSApp = context.getSequenceConfig().getApplicationConfig().isSaaSApp();
        if (IdentityTenantUtil.isLegacySaaSAuthenticationEnabled() && isSaaSApp) {
            return username;
        }
        if (IdentityUtil.isEmailUsernameEnabled()) {
            if (StringUtils.countMatches((String)username, (String)"@") == 1) {
                return username + "@" + context.getTenantDomain();
            }
        } else if (!username.endsWith(context.getTenantDomain())) {
            if (isSaaSApp && StringUtils.countMatches((String)username, (String)"@") >= 1) {
                return username;
            }
            return username + "@" + context.getTenantDomain();
        }
        return username;
    }

    public static void validateUsername(String username, AuthenticationContext context) throws InvalidCredentialsException {
        String tenantAwareUsername;
        if (IdentityUtil.isEmailUsernameEnabled() && StringUtils.countMatches((String)(tenantAwareUsername = MultitenantUtils.getTenantAwareUsername((String)username)), (String)"@") < 1) {
            context.setProperty("InvalidEmailUsername", true);
            throw new InvalidCredentialsException("Invalid username. Username has to be an email.");
        }
    }

    private static String addUserId(String username, org.wso2.carbon.user.api.UserStoreManager userStoreManager) {
        String userId;
        block2: {
            userId = UUID.randomUUID().toString();
            HashMap<String, String> claims = new HashMap<String, String>();
            claims.put("http://wso2.org/claims/userid", userId);
            try {
                userStoreManager.setUserClaimValues(username, claims, null);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("Error while updating http://wso2.org/claims/userid claim of the user: " + username + " with the unique user id."));
            }
        }
        return userId;
    }

    private static org.wso2.carbon.user.api.UserStoreManager getUserStoreManager(int tenantId, String userStoreDomain) throws org.wso2.carbon.user.api.UserStoreException {
        org.wso2.carbon.user.api.UserStoreManager userStoreManager = FrameworkServiceComponent.getRealmService().getTenantUserRealm(tenantId).getUserStoreManager();
        if (userStoreManager instanceof UserStoreManager) {
            return ((UserStoreManager)userStoreManager).getSecondaryUserStoreManager(userStoreDomain);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unable to resolve the corresponding user store manager for the domain: " + userStoreDomain + ", as the provided user store manager: " + userStoreManager.getClass() + ", is not an instance of org.wso2.carbon.user.core.UserStoreManager. Therefore returning the user store manager: " + userStoreManager.getClass() + ", from the realm."));
        }
        return userStoreManager;
    }

    public static boolean isContinueOnClaimHandlingErrorAllowed() {
        String continueOnClaimHandlingErrorValue = IdentityUtil.getProperty((String)CONTINUE_ON_CLAIM_HANDLING_ERROR);
        return !Boolean.FALSE.toString().equalsIgnoreCase(continueOnClaimHandlingErrorValue);
    }

    static {
        cacheDisabledAuthenticators = Arrays.asList("samlsso", "oauth2");
    }
}

