/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.database.utils.jdbc.JdbcTemplate;
import org.wso2.carbon.database.utils.jdbc.exceptions.DataAccessException;
import org.wso2.carbon.database.utils.jdbc.exceptions.TransactionException;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthHistory;
import org.wso2.carbon.identity.application.authentication.framework.exception.DuplicatedAuthUserException;
import org.wso2.carbon.identity.application.authentication.framework.exception.UserSessionException;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.authentication.framework.util.JdbcUtils;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.idp.mgt.util.IdPManagementUtil;

public class UserSessionStore {
    private static final Log log = LogFactory.getLog(UserSessionStore.class);
    private static UserSessionStore instance = new UserSessionStore();
    private static final String FEDERATED_USER_DOMAIN = "FEDERATED";
    private static final String DELETE_CHUNK_SIZE_PROPERTY = "JDBCPersistenceManager.SessionDataPersist.UserSessionMapping.DeleteChunkSize";
    private static final String IDN_AUTH_USER_SESSION_MAPPING_TABLE = "IDN_AUTH_USER_SESSION_MAPPING";
    private static final String IDN_AUTH_SESSION_APP_INFO_TABLE = "IDN_AUTH_SESSION_APP_INFO_TABLE";
    private static final String IDN_AUTH_SESSION_META_DATA_TABLE = "IDN_AUTH_SESSION_META_DATA";
    private int deleteChunkSize = 10000;

    private UserSessionStore() {
        String deleteChunkSizeString = IdentityUtil.getProperty((String)DELETE_CHUNK_SIZE_PROPERTY);
        if (StringUtils.isNotBlank((String)deleteChunkSizeString)) {
            this.deleteChunkSize = Integer.parseInt(deleteChunkSizeString);
        }
    }

    public static UserSessionStore getInstance() {
        return instance;
    }

    public void storeUserData(String userId, String userName, int tenantId, String userDomain, int idPId) throws UserSessionException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO IDN_AUTH_USER(USER_ID, USER_NAME, TENANT_ID, DOMAIN_NAME, IDP_ID) VALUES (?,?,?,?,?)");){
                preparedStatement.setString(1, userId);
                preparedStatement.setString(2, userName);
                preparedStatement.setInt(3, tenantId);
                preparedStatement.setString(4, userDomain == null ? FEDERATED_USER_DOMAIN : userDomain.toUpperCase());
                preparedStatement.setInt(5, idPId);
                preparedStatement.executeUpdate();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e1) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new DuplicatedAuthUserException("Error when store user data.", e1);
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            throw new DuplicatedAuthUserException("Duplicated user entry found in IDN_AUTH_USER table. Username: " + userName + " Tenant Id: " + tenantId + " User Store Domain: " + userDomain + " Identity Provider Id: " + idPId, e);
        }
        catch (SQLException e) {
            if (StringUtils.containsIgnoreCase((String)e.getMessage(), (String)"USER_STORE_CONSTRAINT")) {
                throw new DuplicatedAuthUserException("Duplicated user entry found in IDN_AUTH_USER table. Username: " + userName + " Tenant Id: " + tenantId + " User Store Domain: " + userDomain + " Identity Provider Id: " + idPId, e);
            }
            throw new UserSessionException("Error while storing authenticated user details to the database table IDN_AUTH_USER_STORE of user: " + userName + ", Tenant Id: " + tenantId + ", User domain: " + userDomain + ", Identity provider id: " + idPId, e);
        }
    }

    public String getUserId(String userName, int tenantId, String userDomain, int idPId) throws UserSessionException {
        String userId = null;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT USER_ID FROM IDN_AUTH_USER WHERE USER_NAME =? AND TENANT_ID =? AND DOMAIN_NAME =? AND IDP_ID = ?");){
                preparedStatement.setString(1, userName);
                preparedStatement.setInt(2, tenantId);
                preparedStatement.setString(3, userDomain == null ? FEDERATED_USER_DOMAIN : userDomain.toUpperCase());
                preparedStatement.setInt(4, idPId);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        userId = resultSet.getString(1);
                    }
                }
            }
            catch (SQLException e1) {
                throw new UserSessionException("Error while retrieving User Id of the user: " + userName + ", Tenant Id: " + tenantId + ", User domain: " + userDomain + ", Identity provider id: " + idPId, e1);
            }
        }
        catch (SQLException e) {
            throw new UserSessionException("Error while retrieving User Id of the user: " + userName + ", Tenant Id: " + tenantId + ", User domain: " + userDomain + ", Identity provider id: " + idPId, e);
        }
        return userId;
    }

    public String getUserId(String userName, int tenantId, String userDomain) throws UserSessionException {
        String userId = null;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT USER_ID FROM IDN_AUTH_USER WHERE USER_NAME =? AND TENANT_ID =? AND DOMAIN_NAME =?");){
                preparedStatement.setString(1, userName);
                preparedStatement.setInt(2, tenantId);
                preparedStatement.setString(3, userDomain == null ? FEDERATED_USER_DOMAIN : userDomain.toUpperCase());
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        userId = resultSet.getString(1);
                    }
                }
            }
            catch (SQLException e1) {
                throw new UserSessionException("Error while retrieving User Id of the user: " + userName + ", Tenant Id: " + tenantId + ", User domain: " + userDomain, e1);
            }
        }
        catch (SQLException e) {
            throw new UserSessionException("Error while retrieving User Id of the user: " + userName + ", Tenant Id: " + tenantId + ", User domain: " + userDomain, e);
        }
        return userId;
    }

    public List<String> getUserIdsOfUserStore(String userDomain, int tenantId) throws UserSessionException {
        ArrayList<String> userIds = new ArrayList<String>();
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT USER_ID FROM IDN_AUTH_USER WHERE DOMAIN_NAME = ? AND TENANT_ID =?");){
                preparedStatement.setString(1, userDomain.toUpperCase());
                preparedStatement.setInt(2, tenantId);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        userIds.add(resultSet.getString(1));
                    }
                }
            }
            catch (SQLException e1) {
                throw new UserSessionException("Error while retrieving user Ids stored in the user domain: " + userDomain + ", Tenant Id: " + tenantId, e1);
            }
        }
        catch (SQLException e) {
            throw new UserSessionException("Error while retrieving user Ids stored in the user domain: " + userDomain + ", Tenant Id: " + tenantId, e);
        }
        return userIds;
    }

    public int getIdPId(String idPName) throws UserSessionException {
        int idPId = -1;
        if (idPName.equals("LOCAL")) {
            return idPId;
        }
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT IDP.ID FROM IDP WHERE NAME = ?");){
                preparedStatement.setString(1, idPName);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        idPId = resultSet.getInt(1);
                    }
                }
            }
            catch (SQLException e1) {
                throw new UserSessionException("Error while retrieving the IdP id of: " + idPName, e1);
            }
        }
        catch (SQLException e) {
            throw new UserSessionException("Error while retrieving the IdP id of: " + idPName, e);
        }
        return idPId;
    }

    public void storeUserSessionData(String userId, String sessionId) throws UserSessionException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO IDN_AUTH_USER_SESSION_MAPPING(USER_ID,SESSION_ID )VALUES (?,?)");){
                preparedStatement.setString(1, userId);
                preparedStatement.setString(2, sessionId);
                preparedStatement.executeUpdate();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e1) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new UserSessionException("Error while storing mapping between user Id: " + userId + " and session Id: " + sessionId, e1);
            }
        }
        catch (SQLException e) {
            throw new UserSessionException("Error while storing mapping between user Id: " + userId + " and session Id: " + sessionId, e);
        }
    }

    public boolean isExistingMapping(String userId, String sessionId) throws UserSessionException {
        Boolean isExisting = false;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM IDN_AUTH_USER_SESSION_MAPPING WHERE USER_ID =? AND SESSION_ID =?");){
                preparedStatement.setString(1, userId);
                preparedStatement.setString(2, sessionId);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        isExisting = true;
                    }
                }
            }
            catch (SQLException e1) {
                throw new UserSessionException("Error while retrieving existing mapping between user Id: " + userId + " and session Id: " + sessionId, e1);
            }
        }
        catch (SQLException e) {
            throw new UserSessionException("Error while retrieving existing mapping between user Id: " + userId + " and session Id: " + sessionId, e);
        }
        return isExisting;
    }

    public List<String> getSessionId(String userId) throws UserSessionException {
        ArrayList<String> sessionIdList = new ArrayList<String>();
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT SESSION_ID FROM IDN_AUTH_USER_SESSION_MAPPING WHERE USER_ID = ?");){
                preparedStatement.setString(1, userId);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        sessionIdList.add(resultSet.getString(1));
                    }
                }
            }
            catch (SQLException e1) {
                throw new UserSessionException("Error while retrieving session Id of user Id: " + userId, e1);
            }
        }
        catch (SQLException e) {
            throw new UserSessionException("Error while retrieving session Id of user Id: " + userId, e);
        }
        return sessionIdList;
    }

    public void removeExpiredSessionRecords() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Removing information of expired and deleted sessions.");
        }
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            Set<String> terminatedAuthSessionIds = this.getSessionsTerminated(connection);
            String[] sessionsToRemove = new String[terminatedAuthSessionIds.size()];
            terminatedAuthSessionIds.toArray(sessionsToRemove);
            if (!terminatedAuthSessionIds.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(terminatedAuthSessionIds.size() + " number of sessions should be removed from the database. Removing in " + this.deleteChunkSize + " size batches."));
                }
                this.deleteSessionDataFromTable(sessionsToRemove, connection, IDN_AUTH_USER_SESSION_MAPPING_TABLE, "DELETE FROM IDN_AUTH_USER_SESSION_MAPPING WHERE SESSION_ID = ?");
                this.deleteSessionDataFromTable(sessionsToRemove, connection, IDN_AUTH_SESSION_APP_INFO_TABLE, "DELETE FROM IDN_AUTH_SESSION_APP_INFO WHERE SESSION_ID = ?");
                this.deleteSessionDataFromTable(sessionsToRemove, connection, IDN_AUTH_SESSION_META_DATA_TABLE, "DELETE FROM IDN_AUTH_SESSION_META_DATA WHERE SESSION_ID = ?");
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"No expired sessions found to remove.");
            }
        }
        catch (SQLException e) {
            log.error((Object)"Error while removing expired session information from the database.", (Throwable)e);
        }
    }

    public void removeTerminatedSessionRecords(List<String> sessionIdList) {
        String[] sessionsToRemove = sessionIdList.toArray(new String[0]);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Removing meta information of the deleted sessions.");
        }
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
            try {
                this.deleteSessionDataFromTable(sessionsToRemove, connection, IDN_AUTH_USER_SESSION_MAPPING_TABLE, "DELETE FROM IDN_AUTH_USER_SESSION_MAPPING WHERE SESSION_ID = ?");
                this.deleteSessionDataFromTable(sessionsToRemove, connection, IDN_AUTH_SESSION_APP_INFO_TABLE, "DELETE FROM IDN_AUTH_SESSION_APP_INFO WHERE SESSION_ID = ?");
                this.deleteSessionDataFromTable(sessionsToRemove, connection, IDN_AUTH_SESSION_META_DATA_TABLE, "DELETE FROM IDN_AUTH_SESSION_META_DATA WHERE SESSION_ID = ?");
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e1) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                log.error((Object)"Error while removing the terminated session information from the database.", (Throwable)e1);
            }
        }
        catch (SQLException e) {
            log.error((Object)"Error while obtaining the db connection to remove terminated session information", (Throwable)e);
        }
    }

    private Set<String> getSessionsTerminated(Connection connection) throws SQLException {
        HashSet<String> terminatedSessionIds = new HashSet<String>();
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT SESSION_ID FROM IDN_AUTH_SESSION_STORE WHERE SESSION_TYPE = 'AppAuthFrameworkSessionContextCache' AND EXPIRY_TIME < ?");){
            preparedStatement.setLong(1, FrameworkUtils.getCurrentStandardNano());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    terminatedSessionIds.add(resultSet.getString(1));
                }
            }
        }
        return terminatedSessionIds;
    }

    private void deleteSessionDataFromTable(String[] sessionsToRemove, Connection connection, String tableName, String deleteQuery) throws SQLException {
        int totalSessionsToRemove = sessionsToRemove.length;
        int iterations = totalSessionsToRemove / this.deleteChunkSize + 1;
        int startCount = 0;
        for (int i = 0; i < iterations; ++i) {
            int endCount = (i + 1) * this.deleteChunkSize;
            if (totalSessionsToRemove < endCount) {
                endCount = totalSessionsToRemove;
            }
            try (PreparedStatement preparedStatementForDelete = connection.prepareStatement(deleteQuery);){
                for (int j = startCount; j < endCount; ++j) {
                    preparedStatementForDelete.setString(1, sessionsToRemove[j]);
                    preparedStatementForDelete.addBatch();
                }
                preparedStatementForDelete.executeBatch();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removed  " + (endCount - startCount) + " records from " + tableName + "."));
                }
            }
            startCount = endCount;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removed total " + totalSessionsToRemove + " records from " + tableName + "."));
        }
    }

    public void storeAppSessionData(String sessionId, String subject, int appID, String inboundAuth) throws DataAccessException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.withTransaction(template -> {
                template.executeUpdate("INSERT INTO IDN_AUTH_SESSION_APP_INFO(SESSION_ID,SUBJECT,APP_ID,INBOUND_AUTH_TYPE)VALUES (?,?,?,?)", preparedStatement -> {
                    preparedStatement.setString(1, sessionId);
                    preparedStatement.setString(2, subject);
                    preparedStatement.setInt(3, appID);
                    preparedStatement.setString(4, inboundAuth);
                });
                return null;
            });
        }
        catch (TransactionException e) {
            throw new DataAccessException("Error while storing application data for session in the database.", (Throwable)e);
        }
    }

    public void storeAppSessionDataIfNotExist(String sessionId, String subject, int appID, String inboundAuth) throws DataAccessException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.withTransaction(template -> {
                Integer recordCount = (Integer)template.fetchSingleRecord("SELECT 1 FROM IDN_AUTH_SESSION_APP_INFO WHERE SESSION_ID =? AND SUBJECT =? AND APP_ID =? AND INBOUND_AUTH_TYPE =?", (resultSet, rowNumber) -> resultSet.getInt(1), preparedStatement -> {
                    preparedStatement.setString(1, sessionId);
                    preparedStatement.setString(2, subject);
                    preparedStatement.setInt(3, appID);
                    preparedStatement.setString(4, inboundAuth);
                });
                if (recordCount == null) {
                    this.storeAppSessionData(sessionId, subject, appID, inboundAuth);
                }
                return null;
            });
        }
        catch (TransactionException e) {
            throw new DataAccessException("Error while storing application data of session id: " + sessionId + ", subject: " + subject + ", app Id: " + appID + ", protocol: " + inboundAuth + ".", (Throwable)e);
        }
    }

    public int getAppId(String applicationName, int appTenantID) throws UserSessionException {
        Integer appId;
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            appId = (Integer)jdbcTemplate.fetchSingleRecord("SELECT ID FROM SP_APP WHERE APP_NAME =? AND TENANT_ID =?", (resultSet, rowNumber) -> resultSet.getInt(1), preparedStatement -> {
                preparedStatement.setString(1, applicationName);
                preparedStatement.setInt(2, appTenantID);
            });
        }
        catch (DataAccessException e) {
            throw new UserSessionException("Error while retrieving the app id of " + applicationName + ", tenant id" + appTenantID + ".", e);
        }
        return appId == null ? 0 : appId;
    }

    public boolean isExistingAppSession(String sessionId, String subject, int appID, String inboundAuth) throws UserSessionException {
        Integer recordCount;
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            recordCount = (Integer)jdbcTemplate.fetchSingleRecord("SELECT 1 FROM IDN_AUTH_SESSION_APP_INFO WHERE SESSION_ID =? AND SUBJECT =? AND APP_ID =? AND INBOUND_AUTH_TYPE =?", (resultSet, rowNumber) -> resultSet.getInt(1), preparedStatement -> {
                preparedStatement.setString(1, sessionId);
                preparedStatement.setString(2, subject);
                preparedStatement.setInt(3, appID);
                preparedStatement.setString(4, inboundAuth);
            });
        }
        catch (DataAccessException e) {
            throw new UserSessionException("Error while retrieving application data of session id: " + sessionId + ", subject: " + subject + ", app Id: " + appID + ", protocol: " + inboundAuth + ".", e);
        }
        return recordCount != null;
    }

    public void storeSessionMetaData(String sessionId, Map<String, String> metaData) throws UserSessionException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeBatchInsert("INSERT INTO IDN_AUTH_SESSION_META_DATA(SESSION_ID,PROPERTY_TYPE,VALUE)VALUES (?,?,?)", preparedStatement -> {
                for (Map.Entry entry : metaData.entrySet()) {
                    preparedStatement.setString(1, sessionId);
                    preparedStatement.setString(2, (String)entry.getKey());
                    preparedStatement.setString(3, (String)entry.getValue());
                    preparedStatement.addBatch();
                }
            }, (Object)sessionId);
        }
        catch (DataAccessException e) {
            throw new UserSessionException("Error while storing metadata of session:" + sessionId + " in table " + IDN_AUTH_SESSION_META_DATA_TABLE + ".", e);
        }
    }

    public void updateSessionMetaData(String sessionId, String propertyType, String value) throws UserSessionException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("UPDATE IDN_AUTH_SESSION_META_DATA SET VALUE=? WHERE SESSION_ID =? AND PROPERTY_TYPE=?", preparedStatement -> {
                preparedStatement.setString(1, value);
                preparedStatement.setString(2, sessionId);
                preparedStatement.setString(3, propertyType);
            });
        }
        catch (DataAccessException e) {
            throw new UserSessionException("Error while updating " + propertyType + " of session:" + sessionId + " in table " + IDN_AUTH_SESSION_META_DATA_TABLE + ".", e);
        }
    }

    public List<String> getSessionId(User user, int idpId) throws UserSessionException {
        ArrayList<String> sessionIdList = new ArrayList<String>();
        int tenantId = IdentityTenantUtil.getTenantId((String)user.getTenantDomain());
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT SESSION_ID FROM IDN_AUTH_USER_SESSION_MAPPING WHERE USER_ID = (SELECT USER_ID FROM IDN_AUTH_USER WHERE USER_NAME =? AND TENANT_ID =? AND DOMAIN_NAME =? AND IDP_ID = ?)");){
                preparedStatement.setString(1, user.getUserName());
                preparedStatement.setInt(2, tenantId);
                preparedStatement.setString(3, user.getUserStoreDomain() == null ? FEDERATED_USER_DOMAIN : user.getUserStoreDomain().toUpperCase());
                preparedStatement.setInt(4, idpId);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        sessionIdList.add(resultSet.getString(1));
                    }
                }
            }
            catch (SQLException ex) {
                throw new UserSessionException("Error while retrieving session IDs of user: " + user.getUserName() + ".", ex);
            }
        }
        catch (SQLException e) {
            throw new UserSessionException("Error while retrieving session IDs of user: " + user.getUserName() + ".", e);
        }
        return sessionIdList;
    }

    public boolean isExistingMapping(User user, int idpId, String sessionId) throws UserSessionException {
        Boolean isExisting = false;
        int tenantId = IdentityTenantUtil.getTenantId((String)user.getTenantDomain());
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM IDN_AUTH_USER_SESSION_MAPPING WHERE SESSION_ID =? AND USER_ID = (SELECT USER_ID FROM IDN_AUTH_USER WHERE USER_NAME =? AND TENANT_ID =? AND DOMAIN_NAME =? AND IDP_ID = ?)");){
                preparedStatement.setString(1, sessionId);
                preparedStatement.setString(2, user.getUserName());
                preparedStatement.setInt(3, tenantId);
                preparedStatement.setString(4, user.getUserStoreDomain() == null ? FEDERATED_USER_DOMAIN : user.getUserStoreDomain().toUpperCase());
                preparedStatement.setInt(5, idpId);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        isExisting = true;
                    }
                }
            }
            catch (SQLException ex) {
                throw new UserSessionException("Error while retrieving existing mapping between user : " + user.getUserName() + " and session Id: " + sessionId + ".", ex);
            }
        }
        catch (SQLException e) {
            throw new UserSessionException("Error while retrieving existing mapping between user : " + user.getUserName() + " and session Id: " + sessionId + ".", e);
        }
        return isExisting;
    }

    public void storeFederatedAuthSessionInfo(String sessionContextKey, AuthHistory authHistory) throws UserSessionException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             PreparedStatement prepStmt = connection.prepareStatement("INSERT INTO IDN_FED_AUTH_SESSION_MAPPING (IDP_SESSION_ID, SESSION_ID, IDP_NAME,  AUTHENTICATOR_ID, PROTOCOL_TYPE) VALUES (?, ?, ?, ?, ?)");){
            prepStmt.setString(1, authHistory.getIdpSessionIndex());
            prepStmt.setString(2, sessionContextKey);
            prepStmt.setString(3, authHistory.getIdpName());
            prepStmt.setString(4, authHistory.getAuthenticatorName());
            prepStmt.setString(5, authHistory.getRequestType());
            prepStmt.execute();
        }
        catch (SQLException e) {
            throw new UserSessionException("Error while adding session details of the session index:" + sessionContextKey + ", IdP:" + authHistory.getIdpName(), e);
        }
    }

    public void removeFederatedAuthSessionInfo(String sessionContextKey) throws UserSessionException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             PreparedStatement prepStmt = connection.prepareStatement("DELETE FROM IDN_FED_AUTH_SESSION_MAPPING WHERE SESSION_ID=?");){
            prepStmt.setString(1, sessionContextKey);
            prepStmt.execute();
        }
        catch (SQLException e) {
            throw new UserSessionException("Error while removing federated authentication session details of the session index:" + sessionContextKey, e);
        }
    }

    public boolean isExistingUser(String userId) throws UserSessionException {
        Boolean isExisting = false;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT USER_ID FROM IDN_AUTH_USER WHERE USER_ID = ?");){
            preparedStatement.setString(1, userId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    isExisting = true;
                }
            }
        }
        catch (SQLException e) {
            throw new UserSessionException("Error while retrieving information of user id: " + userId, e);
        }
        return isExisting;
    }

    public int getActiveSessionCount(String tenantDomain) throws UserSessionException {
        int activeSessionCount = 0;
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        long idleSessionTimeOut = TimeUnit.SECONDS.toMillis(IdPManagementUtil.getIdleSessionTimeOut((String)tenantDomain));
        long currentTime = System.currentTimeMillis();
        long minTimestamp = currentTime - idleSessionTimeOut;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT COUNT( DISTINCT IDN_AUTH_SESSION_META_DATA.SESSION_ID) FROM IDN_AUTH_SESSION_META_DATA INNER JOIN IDN_AUTH_USER_SESSION_MAPPING ON IDN_AUTH_SESSION_META_DATA.SESSION_ID = IDN_AUTH_USER_SESSION_MAPPING.SESSION_ID INNER JOIN IDN_AUTH_SESSION_STORE ON IDN_AUTH_USER_SESSION_MAPPING.SESSION_ID = IDN_AUTH_SESSION_STORE.SESSION_ID WHERE IDN_AUTH_SESSION_META_DATA.PROPERTY_TYPE = ? AND IDN_AUTH_SESSION_META_DATA.VALUE BETWEEN ? AND ? AND IDN_AUTH_SESSION_STORE.TENANT_ID = ? ");){
            preparedStatement.setString(1, "Last Access Time");
            preparedStatement.setString(2, String.valueOf(minTimestamp));
            preparedStatement.setString(3, String.valueOf(currentTime));
            preparedStatement.setInt(4, tenantId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    activeSessionCount = resultSet.getInt(1);
                }
            }
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            throw new UserSessionException("Error while retrieving active session count of the tenant domain, " + tenantDomain, e);
        }
        return activeSessionCount;
    }
}

