/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.store;

import java.util.concurrent.BlockingDeque;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.store.SessionContextDO;
import org.wso2.carbon.identity.application.authentication.framework.store.SessionDataStore;

public class TempAuthContextDataDeleteTask
implements Runnable {
    private static final Log log = LogFactory.getLog(TempAuthContextDataDeleteTask.class);
    private BlockingDeque<SessionContextDO> sessionContextDeleteTempQueue;
    private static volatile boolean running;

    public TempAuthContextDataDeleteTask(BlockingDeque<SessionContextDO> sessionContextDeleteTempQueue) {
        this.sessionContextDeleteTempQueue = sessionContextDeleteTempQueue;
    }

    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting temporary authentication context data delete task");
        }
        running = true;
        while (running) {
            try {
                SessionContextDO sessionContextDO = this.sessionContextDeleteTempQueue.take();
                if (sessionContextDO == null) continue;
                SessionDataStore.getInstance().removeTempAuthnContextData(sessionContextDO.getKey(), sessionContextDO.getType());
            }
            catch (InterruptedException e) {
                log.error((Object)"Error while running temporary data delete task: ", (Throwable)e);
            }
        }
    }

    public static void shutdown() {
        running = false;
    }
}

