/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.application.authentication.framework.store.SessionCleanUpService;
import org.wso2.carbon.identity.application.authentication.framework.store.SessionContextDO;
import org.wso2.carbon.identity.application.authentication.framework.store.SessionDataPersistTask;
import org.wso2.carbon.identity.application.authentication.framework.store.TempAuthContextDataDeleteTask;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.cache.CacheEntry;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.model.IdentityCacheConfig;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.idp.mgt.util.IdPManagementUtil;

public class SessionDataStore {
    private static final Log log;
    private static final String OPERATION_DELETE = "DELETE";
    private static final String OPERATION_STORE = "STORE";
    private static final String SQL_INSERT_STORE_OPERATION = "INSERT INTO IDN_AUTH_SESSION_STORE(SESSION_ID, SESSION_TYPE, OPERATION, SESSION_OBJECT, TIME_CREATED, EXPIRY_TIME, TENANT_ID) VALUES (?,?,?,?,?,?,?)";
    private static final String SQL_INSERT_DELETE_OPERATION = "INSERT INTO IDN_AUTH_SESSION_STORE(SESSION_ID, SESSION_TYPE,OPERATION, TIME_CREATED, EXPIRY_TIME) VALUES (?,?,?,?,?)";
    private static final String SQL_DELETE_STORE_OPERATIONS_TASK = "DELETE FROM IDN_AUTH_SESSION_STORE WHERE OPERATION = 'STORE' AND SESSION_ID in (SELECT SESSION_ID  FROM IDN_AUTH_SESSION_STORE WHERE OPERATION = 'DELETE')";
    private static final String SQL_DELETE_TEMP_STORE_OPERATIONS_TASK = "DELETE FROM IDN_AUTH_TEMP_SESSION_STORE WHERE EXPIRY_TIME < ?";
    private static final String SQL_DELETE_STORE_OPERATIONS_TASK_MYSQL = "DELETE IDN_AUTH_SESSION_STORE_DELETE FROM IDN_AUTH_SESSION_STORE IDN_AUTH_SESSION_STORE_DELETE WHERE OPERATION = 'STORE' AND SESSION_ID IN (SELECT SESSION_ID FROM (SELECT SESSION_ID FROM IDN_AUTH_SESSION_STORE WHERE OPERATION = 'DELETE') IDN_AUTH_SESSION_STORE_SELECT)";
    private static final String SQL_DELETE_DELETE_OPERATIONS_TASK = "DELETE FROM IDN_AUTH_SESSION_STORE WHERE OPERATION = 'DELETE' AND  EXPIRY_TIME < ?";
    private static final String SQL_DELETE_TEMP_RECORDS = "DELETE FROM IDN_AUTH_TEMP_SESSION_STORE WHERE SESSION_ID = ? AND  SESSION_TYPE = ?";
    private static final String SQL_DESERIALIZE_OBJECT_MYSQL = "SELECT OPERATION, SESSION_OBJECT, TIME_CREATED FROM IDN_AUTH_SESSION_STORE WHERE SESSION_ID =? AND SESSION_TYPE=? ORDER BY TIME_CREATED DESC LIMIT 1";
    private static final String SQL_DESERIALIZE_OBJECT_DB2SQL = "SELECT OPERATION, SESSION_OBJECT, TIME_CREATED FROM IDN_AUTH_SESSION_STORE WHERE SESSION_ID =? AND SESSION_TYPE=? ORDER BY TIME_CREATED DESC FETCH FIRST 1 ROWS ONLY";
    private static final String SQL_DESERIALIZE_OBJECT_MSSQL = "SELECT TOP 1 OPERATION, SESSION_OBJECT, TIME_CREATED FROM IDN_AUTH_SESSION_STORE WHERE SESSION_ID =? AND SESSION_TYPE=? ORDER BY TIME_CREATED DESC";
    private static final String SQL_DESERIALIZE_OBJECT_POSTGRESQL = "SELECT OPERATION, SESSION_OBJECT, TIME_CREATED FROM IDN_AUTH_SESSION_STORE WHERE SESSION_ID =? AND SESSION_TYPE=? ORDER BY TIME_CREATED DESC LIMIT 1";
    private static final String SQL_DESERIALIZE_OBJECT_INFORMIX = "SELECT FIRST 1 OPERATION, SESSION_OBJECT, TIME_CREATED FROM IDN_AUTH_SESSION_STORE WHERE SESSION_ID =? AND SESSION_TYPE=? ORDER BY TIME_CREATED DESC LIMIT 1";
    private static final String SQL_DESERIALIZE_OBJECT_ORACLE = "SELECT * FROM (SELECT OPERATION, SESSION_OBJECT, TIME_CREATED FROM IDN_AUTH_SESSION_STORE WHERE SESSION_ID =? AND SESSION_TYPE=? ORDER BY TIME_CREATED DESC) WHERE ROWNUM < 2";
    private static final String SQL_DELETE_EXPIRED_DATA_TASK_MYSQL = "DELETE FROM IDN_AUTH_SESSION_STORE WHERE EXPIRY_TIME < ? LIMIT %d";
    private static final String SQL_DELETE_EXPIRED_DATA_TASK_MSSQL = "DELETE TOP (%d) FROM IDN_AUTH_SESSION_STORE WHERE EXPIRY_TIME < ?";
    private static final String SQL_DELETE_EXPIRED_DATA_TASK_POSTGRESQL = "DELETE FROM IDN_AUTH_SESSION_STORE WHERE CTID IN (SELECT CTID FROM IDN_AUTH_SESSION_STORE WHERE EXPIRY_TIME < ? LIMIT %d)";
    private static final String SQL_DELETE_EXPIRED_DATA_TASK_ORACLE = "DELETE FROM IDN_AUTH_SESSION_STORE WHERE ROWID IN (SELECT ROWID FROM IDN_AUTH_SESSION_STORE WHERE EXPIRY_TIME < ? AND ROWNUM <= %d)";
    private static final String SQL_DELETE_EXPIRED_DATA_TASK_INFOMIXSQL = "DELETE FROM (SELECT SESSION_ID, SESSION_TYPE, OPERATION, TIME_CREATED FROM IDN_AUTH_SESSION_STORE WHERE EXPIRY_TIME < ? LIMIT %d) ";
    private static final String SQL_DELETE_EXPIRED_DATA_TASK_DB2SQL = "DELETE FROM IDN_AUTH_SESSION_STORE WHERE (SESSION_ID, SESSION_TYPE, OPERATION, TIME_CREATED) IN (SELECT SESSION_ID, SESSION_TYPE, OPERATION, TIME_CREATED FROM IDN_AUTH_SESSION_STORE WHERE EXPIRY_TIME < ? FETCH FIRST %d ROWS ONLY)";
    private static final String MYSQL_DATABASE = "MySQL";
    private static final String MARIA_DATABASE = "MariaDB";
    private static final String H2_DATABASE = "H2";
    private static final String DB2_DATABASE = "DB2";
    private static final String MS_SQL_DATABASE = "MS SQL";
    private static final String MICROSOFT_DATABASE = "Microsoft";
    private static final String POSTGRESQL_DATABASE = "PostgreSQL";
    private static final String INFORMIX_DATABASE = "Informix";
    private static final int DEFAULT_DELETE_LIMIT = 50000;
    public static final String DEFAULT_SESSION_STORE_TABLE_NAME = "IDN_AUTH_SESSION_STORE";
    private static final String CACHE_MANAGER_NAME = "IdentityApplicationManagementCacheManager";
    public static final String DEFAULT_TEMP_SESSION_STORE_TABLE_NAME = "IDN_AUTH_TEMP_SESSION_STORE";
    private static int maxSessionDataPoolSize;
    private static int maxTempDataPoolSize;
    private static BlockingDeque<SessionContextDO> sessionContextQueue;
    private static BlockingDeque<SessionContextDO> tempAuthnContextDataDeleteQueue;
    private static volatile SessionDataStore instance;
    private boolean enablePersist;
    private String sqlInsertSTORE;
    private String sqlInsertDELETE;
    private String sqlDeleteSTORETask;
    private String sqlDeleteTempDataTask;
    private String sqlDeleteDELETETask;
    private String sqlSelect;
    private String sqlDeleteExpiredDataTask;
    private int deleteChunkSize = 50000;
    private boolean sessionDataCleanupEnabled = true;
    private boolean operationDataCleanupEnabled = false;
    private static boolean tempDataCleanupEnabled;

    private SessionDataStore() {
        String deleteChunkSizeString;
        String enablePersistVal = IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.Enable");
        this.enablePersist = true;
        if (enablePersistVal != null) {
            this.enablePersist = Boolean.parseBoolean(enablePersistVal);
        }
        String insertSTORESQL = IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.SQL.InsertSTORE");
        String insertDELETESQL = IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.SQL.InsertDELETE");
        String deleteSTORETaskSQL = IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.SQL.DeleteSTORETask");
        String deleteTempSTORETaskSQL = IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.SQL.DeleteTempDataTask");
        String deleteDELETETaskSQL = IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.SQL.DeleteDELETETask");
        String selectSQL = IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.SQL.Select");
        String deleteExpiredDataTaskSQL = IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.SQL.DeleteExpiredDataTask");
        this.sqlInsertSTORE = !StringUtils.isBlank((String)insertSTORESQL) ? insertSTORESQL : SQL_INSERT_STORE_OPERATION;
        this.sqlInsertDELETE = !StringUtils.isBlank((String)insertDELETESQL) ? insertDELETESQL : SQL_INSERT_DELETE_OPERATION;
        if (!StringUtils.isBlank((String)deleteSTORETaskSQL)) {
            this.sqlDeleteSTORETask = deleteSTORETaskSQL;
        }
        this.sqlDeleteTempDataTask = !StringUtils.isBlank((String)deleteTempSTORETaskSQL) ? deleteTempSTORETaskSQL : SQL_DELETE_TEMP_STORE_OPERATIONS_TASK;
        this.sqlDeleteDELETETask = !StringUtils.isBlank((String)deleteDELETETaskSQL) ? deleteDELETETaskSQL : SQL_DELETE_DELETE_OPERATIONS_TASK;
        if (!StringUtils.isBlank((String)selectSQL)) {
            this.sqlSelect = selectSQL;
        }
        if (StringUtils.isNotBlank((String)(deleteChunkSizeString = IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.SessionDataCleanUp.DeleteChunkSize")))) {
            this.deleteChunkSize = Integer.parseInt(deleteChunkSizeString);
        }
        if (StringUtils.isNotBlank((String)deleteExpiredDataTaskSQL)) {
            this.sqlDeleteExpiredDataTask = String.format(deleteExpiredDataTaskSQL, this.deleteChunkSize);
        }
        if (!this.enablePersist) {
            log.info((Object)"Session Data Persistence of Authentication framework is not enabled.");
        }
        String isCleanUpEnabledVal = IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.SessionDataCleanUp.Enable");
        String isOperationCleanUpEnabledVal = IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.OperationDataCleanUp.Enable");
        if (StringUtils.isNotBlank((String)isCleanUpEnabledVal)) {
            this.sessionDataCleanupEnabled = Boolean.parseBoolean(isCleanUpEnabledVal);
        }
        if (StringUtils.isNotBlank((String)isOperationCleanUpEnabledVal)) {
            this.operationDataCleanupEnabled = Boolean.parseBoolean(isOperationCleanUpEnabledVal);
        }
        if (this.sessionDataCleanupEnabled || this.operationDataCleanupEnabled || tempDataCleanupEnabled) {
            long sessionCleanupPeriod = IdentityUtil.getCleanUpPeriod((String)CarbonContext.getThreadLocalCarbonContext().getTenantDomain());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Session clean up task enabled to run in %d minutes intervals", sessionCleanupPeriod));
            }
            SessionCleanUpService sessionCleanUpService = new SessionCleanUpService(sessionCleanupPeriod / 4L, sessionCleanupPeriod);
            sessionCleanUpService.activateCleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SessionDataStore getInstance() {
        if (instance != null) return instance;
        Class<SessionDataStore> clazz = SessionDataStore.class;
        synchronized (SessionDataStore.class) {
            if (instance != null) return instance;
            instance = new SessionDataStore();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Object getSessionData(String key, String type) {
        SessionContextDO sessionContextDO = this.getSessionContextData(key, type);
        return sessionContextDO != null ? sessionContextDO.getEntry() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionContextDO getSessionContextData(String key, String type) {
        if (!this.enablePersist) {
            return null;
        }
        Connection connection = null;
        try {
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        }
        catch (IdentityRuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (StringUtils.isBlank((String)this.sqlSelect)) {
                String driverName = connection.getMetaData().getDriverName();
                this.sqlSelect = driverName.contains(MYSQL_DATABASE) || driverName.contains(MARIA_DATABASE) || driverName.contains(H2_DATABASE) ? "SELECT OPERATION, SESSION_OBJECT, TIME_CREATED FROM IDN_AUTH_SESSION_STORE WHERE SESSION_ID =? AND SESSION_TYPE=? ORDER BY TIME_CREATED DESC LIMIT 1" : (connection.getMetaData().getDatabaseProductName().contains(DB2_DATABASE) ? SQL_DESERIALIZE_OBJECT_DB2SQL : (driverName.contains(MS_SQL_DATABASE) || driverName.contains(MICROSOFT_DATABASE) ? SQL_DESERIALIZE_OBJECT_MSSQL : (driverName.contains(POSTGRESQL_DATABASE) ? "SELECT OPERATION, SESSION_OBJECT, TIME_CREATED FROM IDN_AUTH_SESSION_STORE WHERE SESSION_ID =? AND SESSION_TYPE=? ORDER BY TIME_CREATED DESC LIMIT 1" : (driverName.contains(INFORMIX_DATABASE) ? SQL_DESERIALIZE_OBJECT_INFORMIX : SQL_DESERIALIZE_OBJECT_ORACLE))));
            }
            preparedStatement = connection.prepareStatement(this.getSessionStoreDBQuery(this.sqlSelect, type));
            preparedStatement.setString(1, key);
            preparedStatement.setString(2, type);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String operation = resultSet.getString(1);
                long nanoTime = resultSet.getLong(3);
                if (OPERATION_STORE.equals(operation)) {
                    SessionContextDO sessionContextDO = new SessionContextDO(key, type, this.getBlobObject(resultSet.getBinaryStream(2)), nanoTime);
                    IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)preparedStatement);
                    return sessionContextDO;
                }
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)preparedStatement);
        }
        catch (IOException | ClassNotFoundException | SQLException | IdentityApplicationManagementException e) {
            log.error((Object)"Error while retrieving session data", e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, preparedStatement);
        }
        return null;
    }

    public void storeSessionData(String key, String type, Object entry) {
        this.storeSessionData(key, type, entry, -1);
    }

    public void storeSessionData(String key, String type, Object entry, int tenantId) {
        if (!this.enablePersist) {
            return;
        }
        long nanoTime = FrameworkUtils.getCurrentStandardNano();
        if (maxSessionDataPoolSize > 0 && !this.isTempCache(type)) {
            sessionContextQueue.push(new SessionContextDO(key, type, entry, nanoTime, tenantId));
        } else {
            this.persistSessionData(key, type, entry, nanoTime, tenantId);
        }
    }

    public void clearSessionData(String key, String type) {
        if (!this.enablePersist) {
            return;
        }
        long nanoTime = FrameworkUtils.getCurrentStandardNano();
        if (maxSessionDataPoolSize > 0 && !this.isTempCache(type)) {
            sessionContextQueue.push(new SessionContextDO(key, type, null, nanoTime));
        } else {
            this.removeSessionData(key, type, nanoTime);
        }
    }

    public void stopService() {
        TempAuthContextDataDeleteTask.shutdown();
        SessionDataPersistTask.shutdown();
    }

    private String getDBSpecificSessionDataRemovalQuery() throws IdentityApplicationManagementException {
        Connection connection = null;
        try {
            connection = IdentityDatabaseUtil.getDBConnection();
            String driverName = connection.getMetaData().getDriverName();
            String nonFormattedQuery = driverName.contains(MYSQL_DATABASE) || driverName.contains(MARIA_DATABASE) || driverName.contains(H2_DATABASE) ? SQL_DELETE_EXPIRED_DATA_TASK_MYSQL : (connection.getMetaData().getDatabaseProductName().contains(DB2_DATABASE) ? SQL_DELETE_EXPIRED_DATA_TASK_DB2SQL : (driverName.contains(MS_SQL_DATABASE) || driverName.contains(MICROSOFT_DATABASE) ? SQL_DELETE_EXPIRED_DATA_TASK_MSSQL : (driverName.contains(POSTGRESQL_DATABASE) ? SQL_DELETE_EXPIRED_DATA_TASK_POSTGRESQL : (driverName.contains(INFORMIX_DATABASE) ? SQL_DELETE_EXPIRED_DATA_TASK_INFOMIXSQL : SQL_DELETE_EXPIRED_DATA_TASK_ORACLE))));
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
            String string = String.format(nonFormattedQuery, this.deleteChunkSize);
            return string;
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityApplicationManagementException("Error while retrieving DB connection meta-data", (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, null);
        }
    }

    private void removeExpiredSessionData(String sqlQuery) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("DB query for removing expired data: " + sqlQuery));
        }
        long currentTime = FrameworkUtils.getCurrentStandardNano();
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
            boolean deleteCompleted = false;
            int totalDeletedEntries = 0;
            while (!deleteCompleted) {
                PreparedStatement statement = connection.prepareStatement(sqlQuery);
                Throwable throwable = null;
                try {
                    statement.setLong(1, currentTime);
                    int noOfDeletedRecords = statement.executeUpdate();
                    deleteCompleted = noOfDeletedRecords < this.deleteChunkSize;
                    totalDeletedEntries += noOfDeletedRecords;
                    IdentityDatabaseUtil.commitTransaction((Connection)connection);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("Removed %d expired session records.", noOfDeletedRecords));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Deleted total of %d entries", totalDeletedEntries));
            }
        }
        catch (SQLException | IdentityRuntimeException e) {
            log.error((Object)("Error while removing session data from the database for nano time: " + currentTime), e);
        }
    }

    public void removeExpiredSessionData() {
        if (StringUtils.isBlank((String)this.sqlDeleteExpiredDataTask)) {
            try {
                this.sqlDeleteExpiredDataTask = this.getDBSpecificSessionDataRemovalQuery();
            }
            catch (IdentityApplicationManagementException e) {
                log.error((Object)"Error when initializing the db specific cleanup query.", (Throwable)e);
            }
        }
        if (this.sessionDataCleanupEnabled) {
            this.removeExpiredSessionData(this.sqlDeleteExpiredDataTask);
        }
        if (tempDataCleanupEnabled) {
            this.removeExpiredSessionData(this.replaceTableName(this.sqlDeleteExpiredDataTask));
        }
        if (this.operationDataCleanupEnabled) {
            this.removeInvalidatedSTOREOperations();
        }
    }

    @Deprecated
    public void removeExpiredOperationData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistSessionData(String key, String type, Object entry, long nanoTime, int tenantId) {
        if (!this.enablePersist) {
            return;
        }
        Connection connection = null;
        try {
            connection = IdentityDatabaseUtil.getDBConnection();
        }
        catch (IdentityRuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        long validityPeriodNano = 0L;
        if (entry instanceof CacheEntry) {
            validityPeriodNano = ((CacheEntry)entry).getValidityPeriod();
        }
        if (validityPeriodNano == 0L) {
            validityPeriodNano = this.getCleanupTimeout(type, tenantId);
        }
        PreparedStatement preparedStatement = null;
        try {
            String sqlQuery = this.getSessionStoreDBQuery(this.sqlInsertSTORE, type);
            preparedStatement = connection.prepareStatement(sqlQuery);
            preparedStatement.setString(1, key);
            preparedStatement.setString(2, type);
            preparedStatement.setString(3, OPERATION_STORE);
            this.setBlobObject(preparedStatement, entry, 4);
            preparedStatement.setLong(5, nanoTime);
            preparedStatement.setLong(6, nanoTime + validityPeriodNano);
            preparedStatement.setInt(7, tenantId);
            preparedStatement.executeUpdate();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (IOException | SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                log.error((Object)"Error while storing session data", (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, preparedStatement);
                throw throwable;
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)preparedStatement);
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionData(String key, String type, long nanoTime) {
        if (!this.enablePersist) {
            return;
        }
        if (tempDataCleanupEnabled && maxTempDataPoolSize > 0 && this.isTempCache(type)) {
            tempAuthnContextDataDeleteQueue.push(new SessionContextDO(key, type, null, nanoTime));
            return;
        }
        Connection connection = null;
        try {
            connection = IdentityDatabaseUtil.getDBConnection();
        }
        catch (IdentityRuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        PreparedStatement preparedStatement = null;
        long timeoutNano = nanoTime + this.getCleanupTimeout(type, -1);
        try {
            preparedStatement = connection.prepareStatement(this.getSessionStoreDBQuery(this.sqlInsertDELETE, type));
            preparedStatement.setString(1, key);
            preparedStatement.setString(2, type);
            preparedStatement.setString(3, OPERATION_DELETE);
            preparedStatement.setLong(4, nanoTime);
            preparedStatement.setLong(5, timeoutNano);
            preparedStatement.executeUpdate();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (Exception e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                log.error((Object)"Error while storing DELETE operation session data", (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, preparedStatement);
                throw throwable;
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)preparedStatement);
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTempAuthnContextData(String key, String type) {
        if (!this.enablePersist) {
            return;
        }
        Connection connection = null;
        try {
            connection = IdentityDatabaseUtil.getDBConnection();
        }
        catch (IdentityRuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(SQL_DELETE_TEMP_RECORDS);
            preparedStatement.setString(1, key);
            preparedStatement.setString(2, type);
            preparedStatement.executeUpdate();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (Exception e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            log.error((Object)"Error while deleting temporary authentication context data", (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)preparedStatement);
        }
    }

    private void setBlobObject(PreparedStatement prepStmt, Object value, int index) throws SQLException, IOException {
        if (value != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            oos.flush();
            oos.close();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(baos.toByteArray());
            prepStmt.setBinaryStream(index, (InputStream)inputStream, ((InputStream)inputStream).available());
        } else {
            prepStmt.setBinaryStream(index, (InputStream)null, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getBlobObject(InputStream is) throws IdentityApplicationManagementException, IOException, ClassNotFoundException {
        if (is != null) {
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(is);
                Object object = ois.readObject();
                return object;
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"IOException while trying to close ObjectInputStream.", (Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInvalidatedSTOREOperations() {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = IdentityDatabaseUtil.getDBConnection();
        }
        catch (IdentityRuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        try {
            if (StringUtils.isBlank((String)this.sqlDeleteSTORETask)) {
                String driverName = connection.getMetaData().getDriverName();
                this.sqlDeleteSTORETask = driverName.contains(MYSQL_DATABASE) || driverName.contains(MARIA_DATABASE) ? SQL_DELETE_STORE_OPERATIONS_TASK_MYSQL : SQL_DELETE_STORE_OPERATIONS_TASK;
            }
            statement = connection.prepareStatement(this.sqlDeleteSTORETask);
            statement.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                log.error((Object)"Error while removing STORE operation data from the database. ", (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, statement);
                throw throwable;
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)statement);
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)statement);
        return;
    }

    private boolean isTempCache(String type) {
        IdentityCacheConfig identityCacheConfig = IdentityUtil.getIdentityCacheConfig((String)CACHE_MANAGER_NAME, (String)type);
        if (identityCacheConfig != null) {
            return identityCacheConfig.isTemporary();
        }
        return false;
    }

    private String getSessionStoreDBQuery(String query, String type) {
        if (tempDataCleanupEnabled && this.isTempCache(type)) {
            query = this.replaceTableName(query);
        }
        return query;
    }

    private String replaceTableName(String query) {
        query = query.replace(DEFAULT_SESSION_STORE_TABLE_NAME, DEFAULT_TEMP_SESSION_STORE_TABLE_NAME);
        return query;
    }

    private long getCleanupTimeout(String type, int tenantId) {
        if (this.isTempCache(type)) {
            return TimeUnit.MINUTES.toNanos(IdentityUtil.getTempDataCleanUpTimeout());
        }
        if (tenantId != -1) {
            String tenantDomain = IdentityTenantUtil.getTenantDomain((int)tenantId);
            return TimeUnit.SECONDS.toNanos(IdPManagementUtil.getRememberMeTimeout((String)tenantDomain));
        }
        return TimeUnit.MINUTES.toNanos(IdentityUtil.getCleanUpTimeout());
    }

    static {
        ExecutorService threadPool;
        log = LogFactory.getLog(SessionDataStore.class);
        maxSessionDataPoolSize = 100;
        maxTempDataPoolSize = 50;
        sessionContextQueue = new LinkedBlockingDeque<SessionContextDO>();
        tempAuthnContextDataDeleteQueue = new LinkedBlockingDeque<SessionContextDO>();
        tempDataCleanupEnabled = false;
        try {
            String maxTempDataPoolSizeValue;
            String isTempDataCleanupEnabledVal;
            String maxPoolSizeValue = IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.PoolSize");
            if (StringUtils.isNotBlank((String)maxPoolSizeValue)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Session data pool size config value: " + maxPoolSizeValue));
                }
                maxSessionDataPoolSize = Integer.parseInt(maxPoolSizeValue);
            }
            if (StringUtils.isNotBlank((String)(isTempDataCleanupEnabledVal = IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.TempDataCleanup.Enable")))) {
                tempDataCleanupEnabled = Boolean.parseBoolean(isTempDataCleanupEnabledVal);
            }
            if (StringUtils.isNotBlank((String)(maxTempDataPoolSizeValue = IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.TempDataCleanup.PoolSize")))) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Temporary data pool size config value: " + maxPoolSizeValue));
                }
                maxTempDataPoolSize = Integer.parseInt(maxTempDataPoolSizeValue);
            }
        }
        catch (NumberFormatException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception ignored : ", (Throwable)e);
            }
            log.warn((Object)"One or more pool size configurations cause NumberFormatException. Default values would be used");
        }
        if (maxSessionDataPoolSize > 0) {
            log.info((Object)("Thread pool size for session persistent consumer : " + maxSessionDataPoolSize));
            threadPool = Executors.newFixedThreadPool(maxSessionDataPoolSize);
            for (int i = 0; i < maxSessionDataPoolSize; ++i) {
                threadPool.execute(new SessionDataPersistTask(sessionContextQueue));
            }
        }
        if (tempDataCleanupEnabled && maxTempDataPoolSize > 0) {
            log.info((Object)("Thread pool size for temporary authentication context data delete task: " + maxTempDataPoolSize));
            threadPool = Executors.newFixedThreadPool(maxTempDataPoolSize);
            for (int i = 0; i < maxTempDataPoolSize; ++i) {
                threadPool.execute(new TempAuthContextDataDeleteTask(tempAuthnContextDataDeleteQueue));
            }
        }
    }
}

