/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.store;

import java.util.concurrent.BlockingDeque;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.store.SessionContextDO;
import org.wso2.carbon.identity.application.authentication.framework.store.SessionDataStore;

public class SessionDataPersistTask
implements Runnable {
    private static final Log log = LogFactory.getLog(SessionDataPersistTask.class);
    private BlockingDeque<SessionContextDO> sessionContextQueue;
    private static volatile boolean running;

    public SessionDataPersistTask(BlockingDeque<SessionContextDO> sessionContextQueue) {
        this.sessionContextQueue = sessionContextQueue;
    }

    @Override
    public void run() {
        log.debug((Object)"Session Context persist consumer is started");
        running = true;
        while (running) {
            try {
                SessionContextDO sessionContextDO = this.sessionContextQueue.take();
                if (sessionContextDO == null) continue;
                if (sessionContextDO.getEntry() == null) {
                    log.debug((Object)"Session Data removing Task is started to run");
                    SessionDataStore.getInstance().removeSessionData(sessionContextDO.getKey(), sessionContextDO.getType(), sessionContextDO.getNanoTime());
                    continue;
                }
                log.debug((Object)"Session Data persisting Task is started to run");
                SessionDataStore.getInstance().persistSessionData(sessionContextDO.getKey(), sessionContextDO.getType(), sessionContextDO.getEntry(), sessionContextDO.getNanoTime(), sessionContextDO.getTenantId());
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
        }
    }

    public static void shutdown() {
        running = false;
    }
}

