/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.store;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.authentication.framework.store.SessionDataStore;
import org.wso2.carbon.identity.application.authentication.framework.store.UserSessionStore;

public final class SessionCleanUpService {
    private static final int NUM_THREADS = 1;
    private static final Log log = LogFactory.getLog(SessionCleanUpService.class);
    private final ScheduledExecutorService scheduler;
    private final long initialDelay;
    private final long delayBetweenRuns;

    public SessionCleanUpService(long initialDelay, long delayBetweenRuns) {
        this.initialDelay = initialDelay;
        this.delayBetweenRuns = delayBetweenRuns;
        this.scheduler = Executors.newScheduledThreadPool(1);
    }

    public void activateCleanUp() {
        DatabaseCleanUpTask databaseCleanUpTask = new DatabaseCleanUpTask();
        this.scheduler.scheduleWithFixedDelay(databaseCleanUpTask, this.initialDelay, this.delayBetweenRuns, TimeUnit.MINUTES);
    }

    private static final class DatabaseCleanUpTask
    implements Runnable {
        private DatabaseCleanUpTask() {
        }

        @Override
        public void run() {
            log.debug((Object)"Start running the Session Data cleanup task.");
            if (FrameworkServiceDataHolder.getInstance().isUserSessionMappingEnabled()) {
                UserSessionStore.getInstance().removeExpiredSessionRecords();
            }
            SessionDataStore.getInstance().removeExpiredSessionData();
            log.debug((Object)"Stop running the Session Data cleanup task.");
            log.info((Object)"Session Data cleanup task is running successfully for removing expired Data");
        }
    }
}

