/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.store;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.store.SessionDataStore;

public final class OperationCleanUpService {
    private static final int NUM_THREADS = 1;
    private static final Log log = LogFactory.getLog(OperationCleanUpService.class);
    private final ScheduledExecutorService scheduler;
    private final long initialDelay;
    private final long delayBetweenRuns;

    @Deprecated
    public OperationCleanUpService(long initialDelay, long delayBetweenRuns) {
        this.initialDelay = initialDelay;
        this.delayBetweenRuns = delayBetweenRuns;
        this.scheduler = Executors.newScheduledThreadPool(1);
    }

    public void activateCleanUp() {
        DatabaseOperationCleanUpTask databaseCleanUpTask = new DatabaseOperationCleanUpTask();
        this.scheduler.scheduleWithFixedDelay(databaseCleanUpTask, this.initialDelay, this.delayBetweenRuns, TimeUnit.MINUTES);
    }

    private static final class DatabaseOperationCleanUpTask
    implements Runnable {
        private DatabaseOperationCleanUpTask() {
        }

        @Override
        public void run() {
            log.debug((Object)"Start running the Session Operation Data cleanup task.");
            SessionDataStore.getInstance().removeExpiredOperationData();
            log.debug((Object)"Stop running the Operation Data cleanup task.");
            log.info((Object)"Session Operation Data cleanup task is running successfully for removing expired Operation Data");
        }
    }
}

