/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.store;

import java.sql.Timestamp;
import java.util.Date;
import org.wso2.carbon.identity.application.authentication.framework.dao.LongWaitStatusDAO;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.model.LongWaitStatus;

public class LongWaitStatusStoreService {
    private LongWaitStatusDAO statusDAO;
    private int connectionTimeout;

    public LongWaitStatusStoreService(LongWaitStatusDAO statusDAO, int connectionTimeout) {
        this.statusDAO = statusDAO;
        this.connectionTimeout = connectionTimeout;
    }

    public void addWait(int tenantId, String sessionId, LongWaitStatus longWaitStatus) throws FrameworkException {
        Date now = new Date();
        Timestamp createdTime = new Timestamp(now.getTime());
        Timestamp expireTime = new Timestamp(now.getTime() + (long)this.connectionTimeout);
        this.statusDAO.addWaitStatus(tenantId, sessionId, longWaitStatus, createdTime, expireTime);
    }

    public LongWaitStatus getWait(String sessionId) throws FrameworkException {
        return this.statusDAO.getWaitStatus(sessionId);
    }

    public void removeWait(String sessionId) throws FrameworkException {
        this.statusDAO.removeWaitStatus(sessionId);
    }
}

