/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.servlet;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.authentication.framework.javascript.flow.LongWaitStatusRequest;
import org.wso2.carbon.identity.application.authentication.framework.javascript.flow.LongWaitStatusResponse;
import org.wso2.carbon.identity.application.authentication.framework.model.LongWaitStatus;
import org.wso2.carbon.identity.application.authentication.framework.store.LongWaitStatusStoreService;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;

public class LongWaitStatusServlet
extends HttpServlet {
    private static final long serialVersionUID = -3714283612680472526L;
    private static final String PROP_WAITING_ID = "waitingId";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String id;
        if (FrameworkUtils.getMaxInactiveInterval() == 0) {
            FrameworkUtils.setMaxInactiveInterval(request.getSession().getMaxInactiveInterval());
        }
        if ((id = request.getParameter(PROP_WAITING_ID)) == null && request.getContentType() != null && request.getContentType().startsWith("application/json")) {
            Gson gson = new Gson();
            LongWaitStatusRequest longWaitStatusRequest = (LongWaitStatusRequest)gson.fromJson((Reader)request.getReader(), LongWaitStatusRequest.class);
            id = longWaitStatusRequest.getWaitId();
        }
        LongWaitStatusResponse longWaitResponse = new LongWaitStatusResponse();
        longWaitResponse.setWaitId(id);
        if (id == null) {
            longWaitResponse.setStatus(LongWaitStatus.Status.UNKNOWN.name());
            response.setStatus(404);
        } else {
            LongWaitStatusStoreService longWaitStatusStoreService = FrameworkServiceDataHolder.getInstance().getLongWaitStatusStoreService();
            if (longWaitStatusStoreService == null) {
                response.setStatus(500);
            } else {
                LongWaitStatus longWaitStatus = null;
                try {
                    longWaitStatus = longWaitStatusStoreService.getWait(id);
                }
                catch (FrameworkException e) {
                    response.setStatus(500);
                }
                if (longWaitStatus == null) {
                    longWaitResponse.setStatus(LongWaitStatus.Status.COMPLETED.name());
                } else if (longWaitStatus.getStatus() != null) {
                    if (longWaitStatus.getStatus() == LongWaitStatus.Status.UNKNOWN) {
                        longWaitResponse.setStatus(LongWaitStatus.Status.COMPLETED.name());
                    } else {
                        longWaitResponse.setStatus(longWaitStatus.getStatus().name());
                    }
                } else {
                    longWaitResponse.setStatus(LongWaitStatus.Status.COMPLETED.name());
                }
            }
        }
        response.setContentType("application/json");
        String json = new Gson().toJson((Object)longWaitResponse);
        try (PrintWriter out = response.getWriter();){
            out.print(json);
            out.flush();
        }
    }
}

