/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.services;

import org.apache.commons.lang.StringUtils;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.identity.application.authentication.framework.cache.SessionContextCache;
import org.wso2.carbon.identity.application.authentication.framework.context.SessionContext;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;

public class SessionManagementService
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(SessionManagementService.class);

    public boolean removeSession(String sessionId) {
        if (StringUtils.isBlank((String)sessionId)) {
            return false;
        }
        SessionContext sessionContext = FrameworkUtils.getSessionContextFromCache(sessionId);
        this.terminateSession(sessionContext, sessionId);
        return true;
    }

    public boolean removeMySession(String sessionId) {
        AuthenticatedUser authenticatedUser;
        if (StringUtils.isBlank((String)sessionId)) {
            return false;
        }
        SessionContext sessionContext = FrameworkUtils.getSessionContextFromCache(sessionId);
        CarbonContext carbonContext = CarbonContext.getThreadLocalCarbonContext();
        String username = carbonContext.getUsername();
        String userStoreDomain = "PRIMARY";
        String[] usernameTokens = username.split("/");
        if (usernameTokens.length > 1) {
            userStoreDomain = usernameTokens[0];
            username = usernameTokens[1];
        }
        if (!(username.equals((authenticatedUser = (AuthenticatedUser)((Object)sessionContext.getProperty("AuthenticatedUser"))).getUserName()) && userStoreDomain.equals(authenticatedUser.getUserStoreDomain()) && carbonContext.getTenantDomain().equals(authenticatedUser.getTenantDomain()))) {
            log.warn((Object)String.format("Trying to terminate a session which does not belong to logged in user (%s). This might be an attempt for a security breach", username));
            return false;
        }
        this.terminateSession(sessionContext, sessionId);
        return true;
    }

    private void terminateSession(SessionContext sessionContext, String sessionId) {
        if (FrameworkServiceDataHolder.getInstance().getAuthnDataPublisherProxy() != null && FrameworkServiceDataHolder.getInstance().getAuthnDataPublisherProxy().isEnabled(null) && sessionContext != null) {
            Object authenticatedUserObj = sessionContext.getProperty("AuthenticatedUser");
            AuthenticatedUser authenticatedUser = new AuthenticatedUser();
            if (authenticatedUserObj != null) {
                authenticatedUser = (AuthenticatedUser)((Object)authenticatedUserObj);
            }
            FrameworkUtils.publishSessionEvent(sessionId, null, null, sessionContext, authenticatedUser, "sessionTerminated");
        }
        SessionContextCache.getInstance().clearCacheEntry(sessionId);
    }
}

