/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.services;

import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticatorFlowStatus;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.exception.PostAuthenticationFailedException;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.PostAuthenticationHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.PostAuthnHandlerFlowStatus;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.authentication.framework.util.LoginContextManagementUtil;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;

public class PostAuthenticationMgtService {
    private static final Log log = LogFactory.getLog(PostAuthenticationMgtService.class);

    public void handlePostAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationContext authenticationContext) throws FrameworkException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing Post Authentication Management Service for context " + authenticationContext.getContextIdentifier()));
        }
        List<PostAuthenticationHandler> postAuthenticationHandlers = FrameworkServiceDataHolder.getInstance().getPostAuthenticationHandlers();
        int currentPostHandlerIndex = authenticationContext.getCurrentPostAuthHandlerIndex();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting from current post handler index " + currentPostHandlerIndex + " for context : " + authenticationContext.getContextIdentifier()));
        }
        if (this.isPostAuthenticationInProgress(authenticationContext, postAuthenticationHandlers, currentPostHandlerIndex)) {
            this.validatePASTRCookie(authenticationContext, request);
            this.setPASTRCookie(authenticationContext, request, response);
            while (currentPostHandlerIndex < postAuthenticationHandlers.size()) {
                PostAuthenticationHandler currentHandler = postAuthenticationHandlers.get(currentPostHandlerIndex);
                if (this.executePostAuthnHandler(request, response, authenticationContext, currentHandler)) {
                    request.setAttribute("authenticatorFlowStatus", (Object)AuthenticatorFlowStatus.INCOMPLETE);
                    return;
                }
                ++currentPostHandlerIndex;
            }
            this.endPostAuthenticationHandlerFlow(authenticationContext, request, response);
        } else {
            this.endPostAuthenticationHandlerFlow(authenticationContext, request, response);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean executePostAuthnHandler(HttpServletRequest request, HttpServletResponse response, AuthenticationContext authenticationContext, PostAuthenticationHandler currentHandler) throws PostAuthenticationFailedException {
        if (!currentHandler.isEnabled()) {
            if (!log.isDebugEnabled()) return false;
            log.debug((Object)("Post authentication handler " + currentHandler.getName() + " is disabled. Hence returning without executing for context : " + authenticationContext.getContextIdentifier()));
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(currentHandler.getName() + " is enabled. Hence executing for context : " + authenticationContext.getContextIdentifier()));
        }
        PostAuthnHandlerFlowStatus flowStatus = currentHandler.handle(request, response, authenticationContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Post authentication handler " + currentHandler.getName() + " returned with status : " + flowStatus + " for context identifier : " + authenticationContext.getContextIdentifier()));
        }
        if (!this.isExecutionFinished(flowStatus)) {
            if (!log.isDebugEnabled()) return true;
            log.debug((Object)("Post authentication handler " + currentHandler.getName() + " is not completed yet. Hence returning for context : " + authenticationContext.getContextIdentifier()));
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Post authentication handler " + currentHandler.getName() + " completed execution for session context : " + authenticationContext.getContextIdentifier()));
        }
        authenticationContext.setExecutedPostAuthHandler(currentHandler.getName());
        return false;
    }

    private boolean isExecutionFinished(PostAuthnHandlerFlowStatus flowStatus) {
        return PostAuthnHandlerFlowStatus.SUCCESS_COMPLETED.equals(flowStatus) || PostAuthnHandlerFlowStatus.UNSUCCESS_COMPLETED.equals(flowStatus);
    }

    private boolean isPostAuthenticationInProgress(AuthenticationContext authenticationContext, List<PostAuthenticationHandler> postAuthenticationHandlers, int currentPostHandlerIndex) {
        return !LoginContextManagementUtil.isPostAuthenticationExtensionCompleted(authenticationContext) && postAuthenticationHandlers.size() > currentPostHandlerIndex;
    }

    private void markPostAuthenticationCompleted(AuthenticationContext authenticationContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Post authentication evaluation has completed for the flow with session data key : " + authenticationContext.getContextIdentifier()));
        }
        LoginContextManagementUtil.markPostAuthenticationCompleted(authenticationContext);
    }

    private void setPASTRCookie(AuthenticationContext context, HttpServletRequest request, HttpServletResponse response) {
        if (context.getParameter("pastr") != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("PASTR cookie is already set to context : " + context.getContextIdentifier()));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("PASTR cookie is not set to context : " + context.getContextIdentifier() + ". Hence setting the cookie"));
        }
        String pastrCookieValue = UUIDGenerator.generateUUID();
        FrameworkUtils.setCookie(request, response, FrameworkUtils.getPASTRCookieName(context.getContextIdentifier()), pastrCookieValue, -1);
        context.addParameter("pastr", pastrCookieValue);
    }

    private void validatePASTRCookie(AuthenticationContext context, HttpServletRequest request) throws PostAuthenticationFailedException {
        Object pstrCookieObj = context.getParameter("pastr");
        if (pstrCookieObj != null) {
            String storedPastrCookieValue = (String)pstrCookieObj;
            Cookie pastrCookie = FrameworkUtils.getCookie(request, FrameworkUtils.getPASTRCookieName(context.getContextIdentifier()));
            if (pastrCookie != null && StringUtils.equals((String)storedPastrCookieValue, (String)pastrCookie.getValue())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("pastr cookie validated successfully for sequence : " + context.getContextIdentifier()));
                }
                return;
            }
            throw new PostAuthenticationFailedException("Invalid Request: Your authentication flow is ended or invalid. Please initiate again.", "Post authentication sequence tracking cookie not found in request with context id : " + context.getContextIdentifier());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("No stored pastr cookie found in authentication context for : " + context.getContextIdentifier() + " . Hence returning without validating"));
        }
    }

    private void removePASTRCookie(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) {
        Object pstrCookieObj = context.getParameter("pastr");
        if (pstrCookieObj != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing post authentication sequnce tracker cookie for context : " + context.getContextIdentifier()));
            }
            FrameworkUtils.setCookie(request, response, FrameworkUtils.getPASTRCookieName(context.getContextIdentifier()), pstrCookieObj.toString(), 0);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("PASTR cookie is not set to context : " + context.getContextIdentifier()));
        }
    }

    private void endPostAuthenticationHandlerFlow(AuthenticationContext authenticationContext, HttpServletRequest request, HttpServletResponse response) {
        this.markPostAuthenticationCompleted(authenticationContext);
        this.removePASTRCookie(request, response, authenticationContext);
    }
}

