/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CommonAuthResponseWrapper
extends HttpServletResponseWrapper {
    private Map extraParameters;
    private HttpServletRequest request;
    private boolean isRedirect = false;
    private String redirectURL;
    private CommonAuthServletPrintWriter printWriter;
    private boolean wrappedByFramework = false;

    public CommonAuthResponseWrapper(HttpServletResponse response) {
        super(response);
        this.extraParameters = new HashMap();
        this.printWriter = new CommonAuthServletPrintWriter(new ByteArrayOutputStream());
    }

    public CommonAuthResponseWrapper(HttpServletResponse response, HttpServletRequest request) {
        super(response);
        this.request = request;
        this.extraParameters = new HashMap();
        this.printWriter = new CommonAuthServletPrintWriter(new ByteArrayOutputStream());
    }

    public void sendRedirect(String location) throws IOException {
        this.redirectURL = location;
        this.isRedirect = true;
    }

    public boolean isRedirect() {
        return this.isRedirect;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public PrintWriter getWriter() throws IOException {
        return this.printWriter;
    }

    public byte[] getContent() throws IOException {
        return this.printWriter.getBufferedString().getBytes();
    }

    public void write() throws IOException {
        this.writeContent();
    }

    private void writeContent() throws IOException {
        byte[] content = this.getContent();
        ServletResponse response = this.getResponse();
        ServletOutputStream os = response.getOutputStream();
        response.setContentLength(content.length);
        os.write(content);
        os.close();
    }

    public boolean isWrappedByFramework() {
        return this.wrappedByFramework;
    }

    public void setWrappedByFramework(boolean wrappedByFramework) {
        this.wrappedByFramework = wrappedByFramework;
    }

    private final class CommonAuthServletPrintWriter
    extends PrintWriter {
        StringBuffer buffer;

        public CommonAuthServletPrintWriter(OutputStream stream) {
            super(stream);
            this.buffer = new StringBuffer();
        }

        @Override
        public void print(String s) {
            this.buffer.append(s);
        }

        @Override
        public void println(String s) {
            this.buffer.append(s + "\n");
        }

        public String getBufferedString() {
            return this.buffer.toString();
        }
    }
}

