/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.model;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthenticationFrameworkWrapper
extends HttpServletRequestWrapper {
    private static final Log log = LogFactory.getLog(AuthenticationFrameworkWrapper.class);
    private final Map<String, String[]> modifiableParameters = new TreeMap<String, String[]>();
    private final Map<String, String> modifiableHeaders;
    private Map<String, String[]> allParameters = null;

    public AuthenticationFrameworkWrapper(HttpServletRequest request, Map<String, String[]> additionalParams, Map<String, String> additionalHeaders) {
        super(request);
        this.modifiableParameters.putAll(additionalParams);
        this.modifiableHeaders = new TreeMap<String, String>();
        this.modifiableHeaders.putAll(additionalHeaders);
    }

    public String getParameter(String name) {
        String[] strings = this.getParameterMap().get(name);
        if (strings != null) {
            return strings[0];
        }
        return super.getParameter(name);
    }

    public String getHeader(String name) {
        String header = super.getHeader(name);
        return header != null ? header : this.modifiableHeaders.get(name);
    }

    public Enumeration<String> getHeaderNames() {
        ArrayList list = new ArrayList();
        Enumeration headerNames = super.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            list.add(headerNames.nextElement());
        }
        for (String keys : this.modifiableHeaders.keySet()) {
            list.add(keys);
        }
        return Collections.enumeration(list);
    }

    public Map<String, String[]> getParameterMap() {
        if (this.allParameters == null) {
            this.allParameters = new TreeMap<String, String[]>();
            this.allParameters.putAll(super.getParameterMap());
            this.allParameters.putAll(this.modifiableParameters);
        }
        return Collections.unmodifiableMap(this.allParameters);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public String getQueryString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String[]> entry : this.getParameterMap().entrySet()) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            try {
                sb.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append('=').append(URLEncoder.encode(entry.getValue()[0], "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)("Error while encoding query string built using entry key : " + entry.getKey() + " and value : " + entry.getValue()[0]), (Throwable)e);
            }
        }
        return sb.toString();
    }

    public void addHeader(String key, String values) {
        this.modifiableHeaders.put(key, values);
    }
}

