/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class AuthenticatedUser
extends User {
    private static final long serialVersionUID = -6919627053686253276L;
    private String authenticatedSubjectIdentifier;
    private String federatedIdPName;
    private boolean isFederatedUser;
    private Map<ClaimMapping, String> userAttributes = new HashMap<ClaimMapping, String>();

    public AuthenticatedUser() {
    }

    public AuthenticatedUser(AuthenticatedUser authenticatedUser) {
        this.authenticatedSubjectIdentifier = authenticatedUser.getAuthenticatedSubjectIdentifier();
        this.tenantDomain = authenticatedUser.getTenantDomain();
        this.userName = authenticatedUser.getUserName();
        this.userStoreDomain = authenticatedUser.getUserStoreDomain();
        if (authenticatedUser.getUserAttributes() != null) {
            this.userAttributes.putAll(authenticatedUser.getUserAttributes());
        }
        this.isFederatedUser = authenticatedUser.isFederatedUser();
        this.federatedIdPName = authenticatedUser.getFederatedIdPName();
        if (!this.isFederatedUser && StringUtils.isNotEmpty((String)this.userStoreDomain) && StringUtils.isNotEmpty((String)this.tenantDomain)) {
            this.updateCaseSensitivity();
        }
    }

    public static AuthenticatedUser createLocalAuthenticatedUserFromSubjectIdentifier(String authenticatedSubjectIdentifier) {
        if (authenticatedSubjectIdentifier == null || authenticatedSubjectIdentifier.trim().isEmpty()) {
            throw new IllegalArgumentException("Failed to create Local Authenticated User from the given subject identifier. Invalid argument. authenticatedSubjectIdentifier : " + authenticatedSubjectIdentifier);
        }
        AuthenticatedUser authenticatedUser = new AuthenticatedUser();
        if (StringUtils.isNotEmpty((String)UserCoreUtil.getDomainFromThreadLocal())) {
            if (authenticatedSubjectIdentifier.indexOf(CarbonConstants.DOMAIN_SEPARATOR) > 0) {
                String[] subjectIdentifierSplits = authenticatedSubjectIdentifier.split(CarbonConstants.DOMAIN_SEPARATOR, 2);
                if (UserCoreUtil.getDomainFromThreadLocal().equalsIgnoreCase(subjectIdentifierSplits[0])) {
                    authenticatedUser.setUserStoreDomain(subjectIdentifierSplits[0]);
                    authenticatedUser.setUserName(MultitenantUtils.getTenantAwareUsername((String)subjectIdentifierSplits[1]));
                }
            } else {
                authenticatedUser.setUserStoreDomain(UserCoreUtil.getDomainFromThreadLocal());
                authenticatedUser.setUserName(MultitenantUtils.getTenantAwareUsername((String)authenticatedSubjectIdentifier));
            }
        } else {
            authenticatedUser.setUserStoreDomain(IdentityUtil.getPrimaryDomainName());
            authenticatedUser.setUserName(MultitenantUtils.getTenantAwareUsername((String)authenticatedSubjectIdentifier));
        }
        authenticatedUser.setTenantDomain(MultitenantUtils.getTenantDomain((String)authenticatedSubjectIdentifier));
        authenticatedUser.setAuthenticatedSubjectIdentifier(authenticatedSubjectIdentifier);
        return authenticatedUser;
    }

    public static AuthenticatedUser createFederateAuthenticatedUserFromSubjectIdentifier(String authenticatedSubjectIdentifier) {
        if (authenticatedSubjectIdentifier == null || authenticatedSubjectIdentifier.trim().isEmpty()) {
            throw new IllegalArgumentException("Failed to create Federated Authenticated User from the given subject identifier. Invalid argument. authenticatedSubjectIdentifier : " + authenticatedSubjectIdentifier);
        }
        AuthenticatedUser authenticatedUser = new AuthenticatedUser();
        authenticatedUser.setAuthenticatedSubjectIdentifier(authenticatedSubjectIdentifier);
        authenticatedUser.setFederatedUser(true);
        return authenticatedUser;
    }

    public String getAuthenticatedSubjectIdentifier() {
        return this.authenticatedSubjectIdentifier;
    }

    public void setAuthenticatedSubjectIdentifier(String authenticatedSubjectIdentifier) {
        this.authenticatedSubjectIdentifier = authenticatedSubjectIdentifier;
    }

    public void setAuthenticatedSubjectIdentifier(String authenticatedSubjectIdentifier, ServiceProvider serviceProvider) {
        if (!this.isFederatedUser() && serviceProvider != null) {
            boolean useUserstoreDomainInLocalSubjectIdentifier = serviceProvider.getLocalAndOutBoundAuthenticationConfig().isUseUserstoreDomainInLocalSubjectIdentifier();
            boolean useTenantDomainInLocalSubjectIdentifier = serviceProvider.getLocalAndOutBoundAuthenticationConfig().isUseTenantDomainInLocalSubjectIdentifier();
            if (useUserstoreDomainInLocalSubjectIdentifier && StringUtils.isNotEmpty((String)this.userStoreDomain)) {
                authenticatedSubjectIdentifier = IdentityUtil.addDomainToName((String)this.userName, (String)this.userStoreDomain);
            }
            if (useTenantDomainInLocalSubjectIdentifier && StringUtils.isNotEmpty((String)this.tenantDomain) && StringUtils.isNotEmpty((String)authenticatedSubjectIdentifier)) {
                authenticatedSubjectIdentifier = UserCoreUtil.addTenantDomainToEntry((String)authenticatedSubjectIdentifier, (String)this.tenantDomain);
            }
        }
        this.authenticatedSubjectIdentifier = authenticatedSubjectIdentifier;
    }

    public Map<ClaimMapping, String> getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(Map<ClaimMapping, String> userAttributes) {
        this.userAttributes = userAttributes;
    }

    public String getUsernameAsSubjectIdentifier(boolean useUserstoreDomainInLocalSubjectIdentifier, boolean useTenantDomainInLocalSubjectIdentifier) {
        String userName = this.userName;
        if (useUserstoreDomainInLocalSubjectIdentifier && this.userStoreDomain != null) {
            userName = UserCoreUtil.addDomainToName((String)userName, (String)this.userStoreDomain);
        }
        if (useTenantDomainInLocalSubjectIdentifier && this.tenantDomain != null) {
            userName = UserCoreUtil.addTenantDomainToEntry((String)userName, (String)this.tenantDomain);
        }
        return userName;
    }

    public boolean isFederatedUser() {
        return this.isFederatedUser;
    }

    public void setFederatedUser(boolean isFederatedUser) {
        this.isFederatedUser = isFederatedUser;
    }

    public String getFederatedIdPName() {
        return this.federatedIdPName;
    }

    public void setFederatedIdPName(String federatedIdPName) {
        this.federatedIdPName = federatedIdPName;
    }

    public boolean equals(Object o) {
        if (!this.isFederatedUser) {
            return super.equals(o);
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthenticatedUser)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthenticatedUser that = (AuthenticatedUser)((Object)o);
        if (!this.authenticatedSubjectIdentifier.equals(that.authenticatedSubjectIdentifier)) {
            return false;
        }
        return this.federatedIdPName != null ? this.federatedIdPName.equals(that.federatedIdPName) : that.federatedIdPName == null;
    }

    public int hashCode() {
        if (!this.isFederatedUser) {
            return super.hashCode();
        }
        int result = this.authenticatedSubjectIdentifier.hashCode();
        result = 31 * result + (this.federatedIdPName != null ? this.federatedIdPName.hashCode() : 0);
        return result;
    }

    public String toFullQualifiedUsername() {
        if (this.isFederatedUser && StringUtils.isBlank((String)this.userName)) {
            return this.authenticatedSubjectIdentifier;
        }
        return super.toFullQualifiedUsername();
    }

    public String toString() {
        if (this.isFederatedUser && StringUtils.isBlank((String)this.userName)) {
            return this.authenticatedSubjectIdentifier;
        }
        return super.toString();
    }
}

