/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.config.model.AuthenticatorConfig;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;

public class AuthenticatedIdPData
implements Serializable {
    private static final long serialVersionUID = 5576595024956777804L;
    private static final Log log = LogFactory.getLog(AuthenticatedIdPData.class);
    private String idpName;
    @Deprecated
    private AuthenticatorConfig authenticator;
    private List<AuthenticatorConfig> authenticators = new ArrayList<AuthenticatorConfig>();
    private AuthenticatedUser user;

    public String getIdpName() {
        return this.idpName;
    }

    public void setIdpName(String idpName) {
        this.idpName = idpName;
    }

    public AuthenticatedUser getUser() {
        return this.user;
    }

    public void setUser(AuthenticatedUser user) {
        this.user = user;
    }

    @Deprecated
    public AuthenticatorConfig getAuthenticator() {
        if (this.authenticator != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Serialized and stored AuthenticatedIdPData object was initially serialized using the old class definition. Handling it in a backward compatible manner");
            }
            return this.authenticator;
        }
        if (CollectionUtils.isNotEmpty(this.authenticators)) {
            return this.authenticators.get(this.authenticators.size() - 1);
        }
        return null;
    }

    @Deprecated
    public void setAuthenticator(AuthenticatorConfig authenticator) {
        this.addAuthenticator(authenticator);
    }

    public void addAuthenticator(AuthenticatorConfig authenticator) {
        if (this.authenticators == null) {
            this.authenticators = new ArrayList<AuthenticatorConfig>();
        }
        this.authenticators.add(authenticator);
    }

    public List<AuthenticatorConfig> getAuthenticators() {
        ArrayList<AuthenticatorConfig> authenticatorsToBeReturned = null;
        if (this.authenticators != null) {
            authenticatorsToBeReturned = new ArrayList<AuthenticatorConfig>(this.authenticators);
        }
        if (this.authenticator != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Serialized and stored AuthenticatedIdPData object was initially serialized using the old class definition. Handling it in a backward compatible manner");
            }
            if (authenticatorsToBeReturned == null) {
                authenticatorsToBeReturned = new ArrayList(1);
            }
            authenticatorsToBeReturned.add(this.authenticator);
        }
        return authenticatorsToBeReturned;
    }

    @Deprecated
    public boolean isAlreadyAuthenticatedUsing(String authenticatorName) {
        for (AuthenticatorConfig authenticator : this.getAuthenticators()) {
            if (!authenticator.getName().equals(authenticatorName)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("User '%s' is already authenticated using the IDP : '%s'and the authenticator : '%s'.", this.user.getUserName(), this.idpName, authenticator.getName()));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("User '%s' was not authenticated using the IDP : '%s'and the authenticator : '%s' before.", this.user.getUserName(), this.idpName, authenticatorName));
        }
        return false;
    }

    public boolean isAlreadyAuthenticatedUsing(String authenticatorName, String authMechanism) {
        String username = null;
        if (this.user != null) {
            username = this.user.getUserName();
        }
        for (AuthenticatorConfig authenticator : this.getAuthenticators()) {
            if (!authenticator.getName().equals(authenticatorName) && (authenticator.getApplicationAuthenticator() == null || !authenticator.getApplicationAuthenticator().getAuthMechanism().equals(authMechanism))) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("User '%s' is already authenticated using the IDP : '%s'and the authenticator : '%s'.", username, this.idpName, authenticator.getName()));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("User '%s' was not authenticated using the IDP : '%s'and the authenticator : '%s' before.", username, this.idpName, authenticatorName));
        }
        return false;
    }
}

