/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.listener;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.config.ConfigurationFacade;
import org.wso2.carbon.identity.core.AbstractIdentityTenantMgtListener;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public class AuthenticationEndpointTenantActivityListener
extends AbstractIdentityTenantMgtListener {
    private static final Log log = LogFactory.getLog(AuthenticationEndpointTenantActivityListener.class);
    private static final String TENANT_LIST_QUERY_PARAM = "isTenantListModified";
    private static final String TENANT_LIST_DATA_SEPARATOR = ",";
    private List<String> tenantDataReceiveURLs;
    private boolean initialized;
    private String serverURL;

    private synchronized void init() {
        try {
            this.tenantDataReceiveURLs = ConfigurationFacade.getInstance().getTenantDataEndpointURLs();
            if (!this.tenantDataReceiveURLs.isEmpty()) {
                this.serverURL = IdentityUtil.getServerURL((String)"", (boolean)true, (boolean)true);
                int index = 0;
                for (String tenantDataReceiveUrl : this.tenantDataReceiveURLs) {
                    URI tenantDataReceiveURI = new URI(tenantDataReceiveUrl);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Tenant list receiving url added : " + tenantDataReceiveUrl));
                    }
                    if (!tenantDataReceiveURI.isAbsolute()) {
                        this.tenantDataReceiveURLs.set(index, this.serverURL + tenantDataReceiveUrl);
                    }
                    ++index;
                }
                this.initialized = true;
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"TenantDataListenerURLs are not set in configuration");
            }
        }
        catch (URISyntaxException e) {
            log.error((Object)"Error while getting TenantDataListenerURLs", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTenantList() {
        if (!this.initialized) {
            this.init();
        }
        if (!this.initialized) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"AuthenticationEndpointTenantActivityListener is not initialized. Tenant list not sent to authentication endpoint");
            }
            return;
        }
        if (this.tenantDataReceiveURLs != null && !this.tenantDataReceiveURLs.isEmpty()) {
            StringBuilder paramsBuilder = new StringBuilder();
            paramsBuilder.append("?").append(TENANT_LIST_QUERY_PARAM).append("=true");
            InputStream inputStream = null;
            for (String tenantDataReceiveURL : this.tenantDataReceiveURLs) {
                try {
                    inputStream = new URL(tenantDataReceiveURL + paramsBuilder.toString()).openStream();
                }
                catch (IOException e) {
                    log.error((Object)("Sending tenant domain list to " + tenantDataReceiveURL + " failed."), (Throwable)e);
                }
                finally {
                    if (inputStream == null) continue;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while closing the tenant data receiving stream", (Throwable)e);
                    }
                }
            }
        }
    }
}

