/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.internal.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.UserSessionManagementService;
import org.wso2.carbon.identity.application.authentication.framework.context.SessionContext;
import org.wso2.carbon.identity.application.authentication.framework.dao.impl.UserSessionDAOImpl;
import org.wso2.carbon.identity.application.authentication.framework.exception.UserSessionException;
import org.wso2.carbon.identity.application.authentication.framework.exception.session.mgt.SessionManagementClientException;
import org.wso2.carbon.identity.application.authentication.framework.exception.session.mgt.SessionManagementException;
import org.wso2.carbon.identity.application.authentication.framework.exception.session.mgt.SessionManagementServerException;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceComponent;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.authentication.framework.model.UserSession;
import org.wso2.carbon.identity.application.authentication.framework.services.SessionManagementService;
import org.wso2.carbon.identity.application.authentication.framework.store.UserSessionStore;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.authentication.framework.util.SessionMgtConstants;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;

public class UserSessionManagementServiceImpl
implements UserSessionManagementService {
    private static final Log log = LogFactory.getLog(UserSessionManagementServiceImpl.class);
    private SessionManagementService sessionManagementService = new SessionManagementService();

    @Override
    public void terminateSessionsOfUser(String username, String userStoreDomain, String tenantDomain) throws UserSessionException {
        this.validate(username, userStoreDomain, tenantDomain);
        String userId = this.resolveUserIdFromUsername(this.getTenantId(tenantDomain), userStoreDomain, username);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Terminating all the active sessions of user: " + username + " of userstore domain: " + userStoreDomain + " in tenant: " + tenantDomain));
            }
            this.terminateSessionsByUserId(userId);
        }
        catch (SessionManagementException e) {
            throw new UserSessionException("Error while terminating sessions of user:" + username + " of userstore domain: " + userStoreDomain + " in tenant: " + tenantDomain, (Throwable)((Object)e));
        }
    }

    private String resolveUserIdFromUsername(int tenantId, String userStoreDomain, String username) throws UserSessionException {
        try {
            if (userStoreDomain == null) {
                userStoreDomain = "PRIMARY";
            }
            UserStoreManager userStoreManager = UserSessionManagementServiceImpl.getUserStoreManager(tenantId, userStoreDomain);
            try {
                if (userStoreManager instanceof AbstractUserStoreManager) {
                    return ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(username);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Provided user store manager for the user: " + username + " of userstore domain: " + userStoreDomain + ", is not an instance of the AbstractUserStore manager"));
                }
                throw new UserSessionException("Unable to get the unique id of the user: " + username + ".");
            }
            catch (UserStoreException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Error occurred while resolving Id for the user: " + username), (Throwable)e);
                }
                throw new UserSessionException("Error occurred while resolving Id for the user: " + username, e);
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserSessionException("Error occurred while retrieving the userstore manager to resolve Id for the user: " + username, e);
        }
    }

    private static UserStoreManager getUserStoreManager(int tenantId, String userStoreDomain) throws org.wso2.carbon.user.api.UserStoreException {
        UserStoreManager userStoreManager = FrameworkServiceComponent.getRealmService().getTenantUserRealm(tenantId).getUserStoreManager();
        if (userStoreManager instanceof org.wso2.carbon.user.core.UserStoreManager) {
            return ((org.wso2.carbon.user.core.UserStoreManager)userStoreManager).getSecondaryUserStoreManager(userStoreDomain);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unable to resolve the corresponding user store manager for the domain: " + userStoreDomain + ", as the provided user store manager: " + userStoreManager.getClass() + ", is not an instance of org.wso2.carbon.user.core.UserStoreManager. Therefore returning the user store manager: " + userStoreManager.getClass() + ", from the realm."));
        }
        return userStoreManager;
    }

    private void validate(String username, String userStoreDomain, String tenantDomain) throws UserSessionException {
        if (StringUtils.isBlank((String)username) || StringUtils.isBlank((String)userStoreDomain) || StringUtils.isBlank((String)tenantDomain)) {
            throw new UserSessionException("Username, userstore domain or tenant domain cannot be empty");
        }
        int tenantId = this.getTenantId(tenantDomain);
        if (-1 == tenantId) {
            throw new UserSessionException("Invalid tenant domain: " + tenantDomain + " provided.");
        }
    }

    private void terminateSessionsOfUser(List<String> sessionList) {
        for (String session : sessionList) {
            this.sessionManagementService.removeSession(session);
        }
    }

    private int getTenantId(String tenantDomain) throws UserSessionException {
        try {
            RealmService realmService = FrameworkServiceDataHolder.getInstance().getRealmService();
            return realmService.getTenantManager().getTenantId(tenantDomain);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserSessionException("Failed to retrieve tenant id for tenant domain: " + tenantDomain);
        }
    }

    @Override
    public List<UserSession> getSessionsByUserId(String userId) throws SessionManagementException {
        if (userId == null || userId.isEmpty()) {
            throw this.handleSessionManagementClientException(SessionMgtConstants.ErrorMessages.ERROR_CODE_INVALID_USER, null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving all the active sessions of user: " + userId + "."));
        }
        return this.getActiveSessionList(this.getSessionIdListByUserId(userId));
    }

    @Override
    public boolean terminateSessionsByUserId(String userId) throws SessionManagementException {
        if (userId == null || userId.isEmpty()) {
            throw this.handleSessionManagementClientException(SessionMgtConstants.ErrorMessages.ERROR_CODE_INVALID_USER, null);
        }
        List<String> sessionIdList = this.getSessionIdListByUserId(userId);
        boolean isSessionPreservingAtPasswordUpdateEnabled = Boolean.parseBoolean(IdentityUtil.getProperty((String)"PasswordUpdate.PreserveLoggedInSession"));
        String currentSessionId = "";
        boolean isSessionTerminationSkipped = false;
        if (isSessionPreservingAtPasswordUpdateEnabled) {
            if (((Map)IdentityUtil.threadLocalProperties.get()).get("currentSessionIdentifier") != null) {
                currentSessionId = (String)((Map)IdentityUtil.threadLocalProperties.get()).get("currentSessionIdentifier");
            }
            if (sessionIdList.remove(currentSessionId)) {
                isSessionTerminationSkipped = true;
            }
        }
        if (log.isDebugEnabled()) {
            if (isSessionTerminationSkipped) {
                log.debug((Object)("Terminating the active sessions of user: " + userId + "except the current session."));
            } else {
                log.debug((Object)("Terminating all the active sessions of user: " + userId + "."));
            }
        }
        this.terminateSessionsOfUser(sessionIdList);
        if (!sessionIdList.isEmpty()) {
            UserSessionStore.getInstance().removeTerminatedSessionRecords(sessionIdList);
        }
        return true;
    }

    @Override
    public boolean terminateSessionBySessionId(String userId, String sessionId) throws SessionManagementException {
        if (userId == null || userId.isEmpty()) {
            throw this.handleSessionManagementClientException(SessionMgtConstants.ErrorMessages.ERROR_CODE_INVALID_USER, null);
        }
        if (sessionId == null || sessionId.isEmpty()) {
            throw this.handleSessionManagementClientException(SessionMgtConstants.ErrorMessages.ERROR_CODE_INVALID_SESSION, null);
        }
        if (this.isUserSessionMappingExist(userId, sessionId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Terminating the session: " + sessionId + " which belongs to the user: " + userId + "."));
            }
            this.sessionManagementService.removeSession(sessionId);
            ArrayList<String> sessionIdList = new ArrayList<String>();
            sessionIdList.add(sessionId);
            UserSessionStore.getInstance().removeTerminatedSessionRecords(sessionIdList);
            return true;
        }
        throw this.handleSessionManagementClientException(SessionMgtConstants.ErrorMessages.ERROR_CODE_FORBIDDEN_ACTION, userId);
    }

    @Override
    public List<UserSession> getSessionsByUser(User user, int idpId) throws SessionManagementException {
        if (user == null) {
            throw this.handleSessionManagementClientException(SessionMgtConstants.ErrorMessages.ERROR_CODE_INVALID_USER, null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving all the active sessions of user: " + user.getUserName() + " of user store domain: " + user.getUserStoreDomain() + "."));
        }
        return this.getActiveSessionList(this.getSessionIdListByUser(user, idpId));
    }

    @Override
    public boolean terminateSessionsByUser(User user, int idpId) throws SessionManagementException {
        if (user == null) {
            throw this.handleSessionManagementClientException(SessionMgtConstants.ErrorMessages.ERROR_CODE_INVALID_USER, null);
        }
        List<String> sessionIdList = this.getSessionIdListByUser(user, idpId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Terminating all the active sessions of user: " + user.getUserName() + " of user store domain: " + user.getUserStoreDomain() + "."));
        }
        this.terminateSessionsOfUser(sessionIdList);
        if (!sessionIdList.isEmpty()) {
            UserSessionStore.getInstance().removeTerminatedSessionRecords(sessionIdList);
        }
        return true;
    }

    @Override
    public boolean terminateSessionBySessionId(User user, int idpId, String sessionId) throws SessionManagementException {
        if (user == null) {
            throw this.handleSessionManagementClientException(SessionMgtConstants.ErrorMessages.ERROR_CODE_INVALID_USER, null);
        }
        if (sessionId == null || sessionId.isEmpty()) {
            throw this.handleSessionManagementClientException(SessionMgtConstants.ErrorMessages.ERROR_CODE_INVALID_SESSION, null);
        }
        if (this.isUserSessionMappingExist(user, idpId, sessionId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Terminating the session: " + sessionId + " which belongs to the user: " + user.getUserName() + " of user store domain: " + user.getUserStoreDomain() + "."));
            }
            this.sessionManagementService.removeSession(sessionId);
            ArrayList<String> sessionIdList = new ArrayList<String>();
            sessionIdList.add(sessionId);
            UserSessionStore.getInstance().removeTerminatedSessionRecords(sessionIdList);
            return true;
        }
        throw this.handleSessionManagementClientException(SessionMgtConstants.ErrorMessages.ERROR_CODE_FORBIDDEN_ACTION, user.getUserName());
    }

    private List<String> getSessionIdListByUserId(String userId) throws SessionManagementServerException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving the list of sessions owned by the user: " + userId + "."));
            }
            return UserSessionStore.getInstance().getSessionId(userId);
        }
        catch (UserSessionException e) {
            throw this.handleSessionManagementServerException(SessionMgtConstants.ErrorMessages.ERROR_CODE_UNABLE_TO_GET_SESSIONS, userId, (Throwable)((Object)e));
        }
    }

    private List<String> getSessionIdListByUser(User user, int idpId) throws SessionManagementServerException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving the list of sessions owned by the user: " + user.getUserName() + " of user store domain: " + user.getUserStoreDomain() + "."));
            }
            return UserSessionStore.getInstance().getSessionId(user, idpId);
        }
        catch (UserSessionException e) {
            throw this.handleSessionManagementServerException(SessionMgtConstants.ErrorMessages.ERROR_CODE_UNABLE_TO_GET_SESSIONS, user.getUserName(), (Throwable)((Object)e));
        }
    }

    private List<UserSession> getActiveSessionList(List<String> sessionIdList) throws SessionManagementServerException {
        ArrayList<UserSession> sessionsList = new ArrayList<UserSession>();
        for (String sessionId : sessionIdList) {
            UserSessionDAOImpl userSessionDTO;
            UserSession userSession;
            SessionContext sessionContext;
            if (sessionId == null || (sessionContext = FrameworkUtils.getSessionContextFromCache(sessionId)) == null || (userSession = (userSessionDTO = new UserSessionDAOImpl()).getSession(sessionId)) == null) continue;
            sessionsList.add(userSession);
        }
        return sessionsList;
    }

    private boolean isUserSessionMappingExist(String userId, String sessionId) throws SessionManagementServerException {
        boolean isUserAuthorized;
        try {
            isUserAuthorized = UserSessionStore.getInstance().isExistingMapping(userId, sessionId);
        }
        catch (UserSessionException e) {
            throw this.handleSessionManagementServerException(SessionMgtConstants.ErrorMessages.ERROR_CODE_UNABLE_TO_AUTHORIZE_USER, userId, (Throwable)((Object)e));
        }
        return isUserAuthorized;
    }

    private boolean isUserSessionMappingExist(User user, int idpId, String sessionId) throws SessionManagementServerException {
        boolean isUserAuthorized;
        try {
            isUserAuthorized = UserSessionStore.getInstance().isExistingMapping(user, idpId, sessionId);
        }
        catch (UserSessionException e) {
            throw this.handleSessionManagementServerException(SessionMgtConstants.ErrorMessages.ERROR_CODE_UNABLE_TO_AUTHORIZE_USER, user.getUserName(), (Throwable)((Object)e));
        }
        return isUserAuthorized;
    }

    private SessionManagementServerException handleSessionManagementServerException(SessionMgtConstants.ErrorMessages error, String data, Throwable e) {
        String description = StringUtils.isNotBlank((String)data) ? String.format(error.getDescription(), data) : error.getDescription();
        return new SessionManagementServerException(error, description, e);
    }

    private SessionManagementClientException handleSessionManagementClientException(SessionMgtConstants.ErrorMessages error, String data) {
        String description = StringUtils.isNotBlank((String)data) ? String.format(error.getDescription(), data) : error.getDescription();
        return new SessionManagementClientException(error, description);
    }
}

