/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.internal.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticationMethodNameTranslator;
import org.wso2.carbon.identity.core.util.IdentityConfigParser;

public class AuthenticationMethodNameTranslatorImpl
implements AuthenticationMethodNameTranslator {
    private static final Log log = LogFactory.getLog(AuthenticationMethodNameTranslatorImpl.class);
    private static final String NS_CARBON = "http://wso2.org/projects/carbon/carbon.xml";
    private static final String CONTEXT_MAPPINGS = "AuthenticationContext";
    private static final String METHOD_REF_LOCAL_NAME = "MethodRef";
    private static final QName NIL_QNAME = new QName("http://www.w3.org/2001/XMLSchema-instance", "nil");
    private static final QName AUTH_CTX_QNAME = new QName("http://wso2.org/projects/carbon/carbon.xml", "AuthenticationContext");
    private static final QName AMR_MAPPING_QNAME = new QName("http://wso2.org/projects/carbon/carbon.xml", "MethodRefs");
    private static final QName METHOD_REF_QNAME = new QName("http://wso2.org/projects/carbon/carbon.xml", "MethodRef");
    private static final QName URI_ATTR_QNAME = new QName(null, "uri");
    private static final QName LEVEL_ATTR_QNAME = new QName(null, "level");
    private static final QName METHOD_ATTR_QNAME = new QName(null, "method");
    private Map<String, String> amrExternalToInternalMap = new HashMap<String, String>();
    private Map<String, Set<String>> amrInternalToExternalMap = new HashMap<String, Set<String>>();

    public void initializeConfigsWithServerConfig() {
        IdentityConfigParser configParser = IdentityConfigParser.getInstance();
        this.initializeConfigs(configParser.getConfigElement(CONTEXT_MAPPINGS));
    }

    void initializeConfigs(OMElement mappingsElement) {
        OMElement amrRefsElement;
        if (mappingsElement == null) {
            return;
        }
        if (mappingsElement.getLocalName().equals("Server")) {
            mappingsElement = mappingsElement.getFirstChildWithName(AUTH_CTX_QNAME);
        }
        if ((amrRefsElement = mappingsElement.getFirstChildWithName(AMR_MAPPING_QNAME)) != null) {
            this.processAmrMappings(amrRefsElement);
        }
    }

    private void processAmrMappings(OMElement amrMapElement) {
        Iterator children = amrMapElement.getChildrenWithName(METHOD_REF_QNAME);
        int i = 0;
        while (children.hasNext()) {
            OMElement child = (OMElement)children.next();
            this.processAmrEntry(child, this.amrInternalToExternalMap, this.amrExternalToInternalMap);
            ++i;
        }
    }

    private void processAmrEntry(OMElement amrEntryElement, Map<String, Set<String>> amrInternalToExternalMap, Map<String, String> amrExternalToInternalMap) {
        String uri = amrEntryElement.getAttributeValue(URI_ATTR_QNAME);
        String method = amrEntryElement.getAttributeValue(METHOD_ATTR_QNAME);
        if (amrEntryElement.getAttribute(NIL_QNAME) == null) {
            Set<String> externalMappings = amrInternalToExternalMap.get(method);
            if (externalMappings == null) {
                externalMappings = new HashSet<String>();
                amrInternalToExternalMap.put(method, externalMappings);
            }
            externalMappings.add(uri);
        }
        amrExternalToInternalMap.put(uri, method);
    }

    private void processAcrEntry(OMElement amrEntryElement, Map<String, String> acrExternalToInternalMap, Map<String, Set<String>> acrInternalToExternalMap) {
        String uri = amrEntryElement.getAttributeValue(URI_ATTR_QNAME);
        String level = amrEntryElement.getAttributeValue(LEVEL_ATTR_QNAME);
        acrExternalToInternalMap.put(uri, level);
        Set<String> externalMappings = acrInternalToExternalMap.get(level);
        if (externalMappings == null) {
            externalMappings = new HashSet<String>();
            acrInternalToExternalMap.put(level, externalMappings);
        }
        externalMappings.add(uri);
        acrExternalToInternalMap.put(uri, level);
    }

    @Override
    public String translateToInternalAmr(String uri, String protocol) {
        return this.amrExternalToInternalMap.get(uri);
    }

    @Override
    public Set<String> translateToExternalAmr(String method, String protocol) {
        Set<String> result = this.amrInternalToExternalMap.get(method);
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }
}

