/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.consent.mgt.core.ConsentManager;
import org.wso2.carbon.identity.application.authentication.framework.ApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticationDataPublisher;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticationMethodNameTranslator;
import org.wso2.carbon.identity.application.authentication.framework.JsFunctionRegistry;
import org.wso2.carbon.identity.application.authentication.framework.config.loader.SequenceLoader;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.JsGraphBuilderFactory;
import org.wso2.carbon.identity.application.authentication.framework.handler.claims.ClaimFilter;
import org.wso2.carbon.identity.application.authentication.framework.handler.claims.impl.DefaultClaimFilter;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.PostAuthenticationHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.consent.SSOConsentService;
import org.wso2.carbon.identity.application.authentication.framework.handler.sequence.impl.AsyncSequenceExecutor;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityRequestFactory;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityResponseFactory;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityProcessor;
import org.wso2.carbon.identity.application.authentication.framework.services.PostAuthenticationMgtService;
import org.wso2.carbon.identity.application.authentication.framework.store.LongWaitStatusStoreService;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataManagementService;
import org.wso2.carbon.identity.core.handler.HandlerComparator;
import org.wso2.carbon.identity.event.services.IdentityEventService;
import org.wso2.carbon.identity.functions.library.mgt.FunctionLibraryManagementService;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.FederatedAssociationManager;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;

public class FrameworkServiceDataHolder {
    private static final Log log = LogFactory.getLog(FrameworkServiceDataHolder.class);
    private static FrameworkServiceDataHolder instance = new FrameworkServiceDataHolder();
    private BundleContext bundleContext = null;
    private RealmService realmService = null;
    private RegistryService registryService = null;
    private List<ApplicationAuthenticator> authenticators = new ArrayList<ApplicationAuthenticator>();
    private long nanoTimeReference = 0L;
    private long unixTimeReference = 0L;
    private List<IdentityProcessor> identityProcessors = new ArrayList<IdentityProcessor>();
    private List<HttpIdentityRequestFactory> httpIdentityRequestFactories = new ArrayList<HttpIdentityRequestFactory>();
    private List<HttpIdentityResponseFactory> httpIdentityResponseFactories = new ArrayList<HttpIdentityResponseFactory>();
    private AuthenticationDataPublisher authnDataPublisherProxy = null;
    private SequenceLoader sequenceLoader = null;
    private JsGraphBuilderFactory JsGraphBuilderFactory;
    private AuthenticationMethodNameTranslator authenticationMethodNameTranslator;
    private List<PostAuthenticationHandler> postAuthenticationHandlers = new ArrayList<PostAuthenticationHandler>();
    private PostAuthenticationMgtService postAuthenticationMgtService = null;
    private ConsentManager consentManager = null;
    private ClaimMetadataManagementService claimMetadataManagementService = null;
    private SSOConsentService ssoConsentService;
    private JsFunctionRegistry jsFunctionRegistry;
    private List<ClaimFilter> claimFilters = new ArrayList<ClaimFilter>();
    private AsyncSequenceExecutor asyncSequenceExecutor;
    private LongWaitStatusStoreService longWaitStatusStoreService;
    private IdentityEventService identityEventService;
    private FunctionLibraryManagementService functionLibraryManagementService = null;
    private String requireCode = "";
    private boolean userSessionMappingEnabled;
    private FederatedAssociationManager federatedAssociationManager;

    private FrameworkServiceDataHolder() {
        this.setNanoTimeReference(System.nanoTime());
        this.setUnixTimeReference(System.currentTimeMillis());
    }

    public static FrameworkServiceDataHolder getInstance() {
        return instance;
    }

    public RegistryService getRegistryService() {
        return this.registryService;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    public RealmService getRealmService() {
        return this.realmService;
    }

    public void setRealmService(RealmService realmService) {
        this.realmService = realmService;
    }

    @Deprecated
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public List<ApplicationAuthenticator> getAuthenticators() {
        return this.authenticators;
    }

    public long getNanoTimeReference() {
        return this.nanoTimeReference;
    }

    private void setNanoTimeReference(long nanoTimeReference) {
        this.nanoTimeReference = nanoTimeReference;
    }

    public long getUnixTimeReference() {
        return this.unixTimeReference;
    }

    private void setUnixTimeReference(long unixTimeReference) {
        this.unixTimeReference = unixTimeReference;
    }

    public List<HttpIdentityRequestFactory> getHttpIdentityRequestFactories() {
        return this.httpIdentityRequestFactories;
    }

    public List<IdentityProcessor> getIdentityProcessors() {
        return this.identityProcessors;
    }

    public List<HttpIdentityResponseFactory> getHttpIdentityResponseFactories() {
        return this.httpIdentityResponseFactories;
    }

    public AuthenticationDataPublisher getAuthnDataPublisherProxy() {
        return this.authnDataPublisherProxy;
    }

    public void setAuthnDataPublisherProxy(AuthenticationDataPublisher authnDataPublisherProxy) {
        this.authnDataPublisherProxy = authnDataPublisherProxy;
    }

    public SequenceLoader getSequenceLoader() {
        return this.sequenceLoader;
    }

    public void setSequenceLoader(SequenceLoader sequenceLoader) {
        this.sequenceLoader = sequenceLoader;
    }

    public AuthenticationMethodNameTranslator getAuthenticationMethodNameTranslator() {
        return this.authenticationMethodNameTranslator;
    }

    public void setAuthenticationMethodNameTranslator(AuthenticationMethodNameTranslator authenticationMethodNameTranslator) {
        this.authenticationMethodNameTranslator = authenticationMethodNameTranslator;
    }

    public JsGraphBuilderFactory getJsGraphBuilderFactory() {
        return this.JsGraphBuilderFactory;
    }

    public void setJsGraphBuilderFactory(JsGraphBuilderFactory jsGraphBuilderFactory) {
        this.JsGraphBuilderFactory = jsGraphBuilderFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPostAuthenticationHandler(PostAuthenticationHandler postAuthenticationHandler) {
        List<PostAuthenticationHandler> list = this.postAuthenticationHandlers;
        synchronized (list) {
            this.postAuthenticationHandlers.add(postAuthenticationHandler);
            this.postAuthenticationHandlers.sort((Comparator<PostAuthenticationHandler>)new HandlerComparator());
        }
    }

    public List<PostAuthenticationHandler> getPostAuthenticationHandlers() {
        return this.postAuthenticationHandlers;
    }

    public PostAuthenticationMgtService getPostAuthenticationMgtService() {
        return this.postAuthenticationMgtService;
    }

    public void setPostAuthenticationMgtService(PostAuthenticationMgtService postAuthenticationMgtService) {
        this.postAuthenticationMgtService = postAuthenticationMgtService;
    }

    public ConsentManager getConsentManager() {
        return this.consentManager;
    }

    public void setConsentManager(ConsentManager consentManager) {
        this.consentManager = consentManager;
    }

    public ClaimMetadataManagementService getClaimMetadataManagementService() {
        return this.claimMetadataManagementService;
    }

    public void setClaimMetadataManagementService(ClaimMetadataManagementService claimMetadataManagementService) {
        this.claimMetadataManagementService = claimMetadataManagementService;
    }

    public SSOConsentService getSSOConsentService() {
        return this.ssoConsentService;
    }

    public void setSSOConsentService(SSOConsentService ssoConsentService) {
        this.ssoConsentService = ssoConsentService;
    }

    public JsFunctionRegistry getJsFunctionRegistry() {
        return this.jsFunctionRegistry;
    }

    public void setJsFunctionRegistry(JsFunctionRegistry jsFunctionRegistry) {
        this.jsFunctionRegistry = jsFunctionRegistry;
    }

    public ClaimFilter getHighestPriorityClaimFilter() {
        if (this.claimFilters.isEmpty()) {
            log.info((Object)"No Registered Claim Filters available. Using the default claim filter.");
            return new DefaultClaimFilter();
        }
        return this.claimFilters.get(0);
    }

    public List<ClaimFilter> getClaimFilters() {
        return this.claimFilters;
    }

    public void addClaimFilter(ClaimFilter claimFilter) {
        this.claimFilters.add(claimFilter);
        this.claimFilters.sort(this.getClaimFilterComparator());
    }

    public void removeClaimFilter(ClaimFilter claimFilter) {
        Iterator<ClaimFilter> claimFilterIterator = this.claimFilters.iterator();
        while (claimFilterIterator.hasNext()) {
            if (!claimFilterIterator.next().getClass().getName().equals(claimFilter.getClass().getName())) continue;
            claimFilterIterator.remove();
        }
    }

    public AsyncSequenceExecutor getAsyncSequenceExecutor() {
        return this.asyncSequenceExecutor;
    }

    public void setAsyncSequenceExecutor(AsyncSequenceExecutor asyncSequenceExecutor) {
        this.asyncSequenceExecutor = asyncSequenceExecutor;
    }

    public LongWaitStatusStoreService getLongWaitStatusStoreService() {
        return this.longWaitStatusStoreService;
    }

    public void setLongWaitStatusStoreService(LongWaitStatusStoreService longWaitStatusStoreService) {
        this.longWaitStatusStoreService = longWaitStatusStoreService;
    }

    private Comparator<ClaimFilter> getClaimFilterComparator() {
        return Comparator.comparingInt(ClaimFilter::getPriority).reversed();
    }

    public IdentityEventService getIdentityEventService() {
        return this.identityEventService;
    }

    public void setIdentityEventService(IdentityEventService identityEventService) {
        this.identityEventService = identityEventService;
    }

    public FunctionLibraryManagementService getFunctionLibraryManagementService() {
        return this.functionLibraryManagementService;
    }

    public void setFunctionLibraryManagementService(FunctionLibraryManagementService functionLibraryManagementService) {
        this.functionLibraryManagementService = functionLibraryManagementService;
    }

    public String getCodeForRequireFunction() {
        return this.requireCode;
    }

    public void setCodeForRequireFunction(String requireCode) {
        this.requireCode = requireCode;
    }

    public boolean isUserSessionMappingEnabled() {
        return this.userSessionMappingEnabled;
    }

    public void setUserSessionMappingEnabled(boolean userSessionMappingEnabled) {
        if (log.isDebugEnabled()) {
            if (userSessionMappingEnabled) {
                log.debug((Object)"User session mapping enabled for server.");
            } else {
                log.debug((Object)"User session mapping not enabled for server.");
            }
        }
        this.userSessionMappingEnabled = userSessionMappingEnabled;
    }

    public FederatedAssociationManager getFederatedAssociationManager() {
        return this.federatedAssociationManager;
    }

    public void setFederatedAssociationManager(FederatedAssociationManager federatedAssociationManager) {
        this.federatedAssociationManager = federatedAssociationManager;
    }
}

