/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.inbound;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.inbound.FrameworkClientException;
import org.wso2.carbon.identity.application.authentication.framework.inbound.FrameworkRuntimeException;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityRequestFactory;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityResponse;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityResponseFactory;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityProcessCoordinator;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityRequest;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityResponse;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public class IdentityServlet
extends HttpServlet {
    private IdentityProcessCoordinator manager = new IdentityProcessCoordinator();

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpIdentityResponse httpIdentityResponse = this.process(request, response);
        this.processHttpResponse(httpIdentityResponse, response);
    }

    private HttpIdentityResponse process(HttpServletRequest request, HttpServletResponse response) {
        HttpIdentityRequestFactory factory = this.getIdentityRequestFactory(request, response);
        IdentityRequest identityRequest = null;
        HttpIdentityResponse.HttpIdentityResponseBuilder responseBuilder = null;
        try {
            identityRequest = factory.create(request, response).build();
            if (identityRequest == null) {
                throw FrameworkRuntimeException.error("IdentityRequest is Null. Cannot proceed!!");
            }
        }
        catch (FrameworkClientException e) {
            responseBuilder = factory.handleException(e, request, response);
            if (responseBuilder == null) {
                throw FrameworkRuntimeException.error("HttpIdentityResponseBuilder is Null. Cannot proceed!!", (Throwable)((Object)e));
            }
            return responseBuilder.build();
        }
        catch (RuntimeException e) {
            responseBuilder = factory.handleException(e, request, response);
            if (responseBuilder == null) {
                throw FrameworkRuntimeException.error("HttpIdentityResponseBuilder is Null. Cannot proceed!!", e);
            }
            return responseBuilder.build();
        }
        IdentityResponse identityResponse = null;
        HttpIdentityResponseFactory responseFactory = null;
        try {
            identityResponse = this.manager.process(identityRequest);
            if (identityResponse == null) {
                throw FrameworkRuntimeException.error("IdentityResponse is Null. Cannot proceed!!");
            }
            responseFactory = this.getHttpIdentityResponseFactory(identityResponse);
            responseBuilder = responseFactory.create(identityResponse);
            if (responseBuilder == null) {
                throw FrameworkRuntimeException.error("HttpIdentityResponseBuilder is Null. Cannot proceed!!");
            }
            return responseBuilder.build();
        }
        catch (FrameworkException e) {
            responseFactory = this.getIdentityResponseFactory(e);
            responseBuilder = responseFactory.handleException(e);
            if (responseBuilder == null) {
                throw FrameworkRuntimeException.error("HttpIdentityResponseBuilder is Null. Cannot proceed!!", (Throwable)((Object)e));
            }
            return responseBuilder.build();
        }
        catch (RuntimeException e) {
            responseFactory = this.getIdentityResponseFactory(e);
            responseBuilder = responseFactory.handleException(e);
            if (responseBuilder == null) {
                throw FrameworkRuntimeException.error("HttpIdentityResponseBuilder is Null. Cannot proceed!!", e);
            }
            return responseBuilder.build();
        }
    }

    private void processHttpResponse(HttpIdentityResponse httpIdentityResponse, HttpServletResponse response) {
        for (Map.Entry<String, String> entry : httpIdentityResponse.getHeaders().entrySet()) {
            response.addHeader(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : httpIdentityResponse.getCookies().entrySet()) {
            response.addCookie((Cookie)entry.getValue());
        }
        if (StringUtils.isNotBlank((String)httpIdentityResponse.getContentType())) {
            response.setContentType(httpIdentityResponse.getContentType());
        }
        if (httpIdentityResponse.getStatusCode() == 302) {
            try {
                this.sendRedirect(response, httpIdentityResponse);
            }
            catch (IOException e) {
                throw FrameworkRuntimeException.error("Error occurred while redirecting response", e);
            }
        }
        response.setStatus(httpIdentityResponse.getStatusCode());
        try {
            PrintWriter out = response.getWriter();
            if (StringUtils.isNotBlank((String)httpIdentityResponse.getBody())) {
                out.print(httpIdentityResponse.getBody());
            }
        }
        catch (IOException e) {
            throw FrameworkRuntimeException.error("Error occurred while getting Response writer object", e);
        }
    }

    private HttpIdentityRequestFactory getIdentityRequestFactory(HttpServletRequest request, HttpServletResponse response) {
        List<HttpIdentityRequestFactory> factories = FrameworkServiceDataHolder.getInstance().getHttpIdentityRequestFactories();
        for (HttpIdentityRequestFactory requestBuilder : factories) {
            if (!requestBuilder.canHandle(request, response)) continue;
            return requestBuilder;
        }
        throw FrameworkRuntimeException.error("No HttpIdentityRequestFactory found to create the request");
    }

    private HttpIdentityResponseFactory getHttpIdentityResponseFactory(IdentityResponse identityResponse) {
        List<HttpIdentityResponseFactory> factories = FrameworkServiceDataHolder.getInstance().getHttpIdentityResponseFactories();
        for (HttpIdentityResponseFactory responseFactory : factories) {
            if (!responseFactory.canHandle(identityResponse)) continue;
            return responseFactory;
        }
        throw FrameworkRuntimeException.error("No HttpIdentityResponseFactory found to create the request");
    }

    private HttpIdentityResponseFactory getIdentityResponseFactory(FrameworkException exception) {
        List<HttpIdentityResponseFactory> factories = FrameworkServiceDataHolder.getInstance().getHttpIdentityResponseFactories();
        for (HttpIdentityResponseFactory responseFactory : factories) {
            if (!responseFactory.canHandle(exception)) continue;
            return responseFactory;
        }
        throw FrameworkRuntimeException.error("No HttpIdentityResponseFactory found to create the response", (Throwable)((Object)exception));
    }

    private HttpIdentityResponseFactory getIdentityResponseFactory(RuntimeException exception) {
        List<HttpIdentityResponseFactory> factories = FrameworkServiceDataHolder.getInstance().getHttpIdentityResponseFactories();
        for (HttpIdentityResponseFactory responseFactory : factories) {
            if (!responseFactory.canHandle(exception)) continue;
            return responseFactory;
        }
        throw FrameworkRuntimeException.error("No HttpIdentityResponseFactory found to create the response", exception);
    }

    private void sendRedirect(HttpServletResponse response, HttpIdentityResponse httpIdentityResponse) throws IOException {
        String redirectUrl = httpIdentityResponse.isFragmentUrl() ? IdentityUtil.buildFragmentUrl((String)httpIdentityResponse.getRedirectURL(), httpIdentityResponse.getParameters()) : IdentityUtil.buildQueryUrl((String)httpIdentityResponse.getRedirectURL(), httpIdentityResponse.getParameters());
        response.sendRedirect(redirectUrl);
    }
}

