/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.inbound;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationRequestCacheEntry;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationResultCacheEntry;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.inbound.FrameworkLoginResponse;
import org.wso2.carbon.identity.application.authentication.framework.inbound.FrameworkLogoutResponse;
import org.wso2.carbon.identity.application.authentication.framework.inbound.FrameworkRuntimeException;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityMessageContext;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityRequest;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityResponse;
import org.wso2.carbon.identity.application.authentication.framework.inbound.InboundUtil;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticationRequest;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticationResult;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.core.ServiceURLBuilder;
import org.wso2.carbon.identity.core.URLBuilderException;
import org.wso2.carbon.identity.core.handler.AbstractIdentityHandler;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.identity.core.model.IdentityEventListenerConfig;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;

public abstract class IdentityProcessor
extends AbstractIdentityHandler {
    private static Log log = LogFactory.getLog(IdentityProcessor.class);
    protected final Properties properties = new Properties();
    protected InitConfig initConfig;

    public void init(InitConfig initConfig) {
        IdentityEventListenerConfig identityEventListenerConfig;
        if (initConfig != null) {
            this.initConfig = initConfig;
        }
        if ((identityEventListenerConfig = IdentityUtil.readEventListenerProperty((String)IdentityProcessor.class.getName(), (String)((Object)((Object)this)).getClass().getName())) == null) {
            return;
        }
        if (identityEventListenerConfig.getProperties() != null) {
            for (Map.Entry<Object, Object> property : identityEventListenerConfig.getProperties().entrySet()) {
                String key = (String)property.getKey();
                String value = (String)property.getValue();
                if (!this.properties.containsKey(key)) {
                    this.properties.setProperty(key, value);
                    continue;
                }
                log.warn((Object)("Property key " + key + " already exists. Cannot add property!!"));
            }
        }
    }

    public abstract IdentityResponse.IdentityResponseBuilder process(IdentityRequest var1) throws FrameworkException;

    public abstract String getCallbackPath(IdentityMessageContext var1);

    protected String getTenantQualifiedCallbackPath(IdentityMessageContext context) {
        String callbackPath = this.getCallbackPath(context);
        try {
            if (!this.isAbsoluteURI(callbackPath) && !this.isTenantQualifiedURI(callbackPath)) {
                if (IdentityTenantUtil.isTenantQualifiedUrlsEnabled()) {
                    callbackPath = ServiceURLBuilder.create().addPath(new String[]{this.getCallbackPath(context)}).build().getAbsolutePublicURL();
                } else {
                    String serverUrl = ServiceURLBuilder.create().build().getAbsolutePublicURL();
                    String tenantDomain = this.getTenantDomainFromContext();
                    callbackPath = !this.isSuperTenantFlow(tenantDomain) ? serverUrl + "/t/" + tenantDomain + "/" + callbackPath : serverUrl + "/" + callbackPath;
                }
            }
        }
        catch (URISyntaxException | URLBuilderException e) {
            throw new RuntimeException("Error while building tenant qualified Callback Path.", e);
        }
        return callbackPath;
    }

    private boolean isAbsoluteURI(String uri) throws URISyntaxException {
        return new URI(uri).isAbsolute();
    }

    private boolean isTenantQualifiedURI(String uri) {
        return uri.startsWith("/t/") || uri.startsWith("t/");
    }

    private String getTenantDomainFromContext() {
        String tenantDomain = IdentityTenantUtil.getTenantDomainFromContext();
        if (StringUtils.isBlank((String)tenantDomain)) {
            tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        }
        return tenantDomain;
    }

    private boolean isSuperTenantFlow(String tenantDomain) {
        return "carbon.super".equals(tenantDomain);
    }

    @Deprecated
    public abstract String getRelyingPartyId();

    public abstract String getRelyingPartyId(IdentityMessageContext var1);

    public String getType(IdentityMessageContext context) {
        return this.getName();
    }

    public abstract boolean canHandle(IdentityRequest var1);

    protected FrameworkLoginResponse.FrameworkLoginResponseBuilder buildResponseForFrameworkLogin(IdentityMessageContext context) {
        IdentityRequest identityRequest = context.getRequest();
        Map<String, String[]> parameterMap = identityRequest.getParameterMap();
        AuthenticationRequest authenticationRequest = new AuthenticationRequest();
        authenticationRequest.appendRequestQueryParams(parameterMap);
        Set<Map.Entry<String, String>> headers = new HashMap<String, String>(identityRequest.getHeaderMap()).entrySet();
        for (Map.Entry<String, String> header : headers) {
            authenticationRequest.addHeader(header.getKey(), header.getValue());
        }
        authenticationRequest.setTenantDomain(identityRequest.getTenantDomain());
        authenticationRequest.setRelyingParty(this.getRelyingPartyId(context));
        authenticationRequest.setType(this.getType(context));
        authenticationRequest.setPassiveAuth(Boolean.parseBoolean(String.valueOf(context.getParameter("passiveAuth"))));
        authenticationRequest.setForceAuth(Boolean.parseBoolean(String.valueOf(context.getParameter("forceAuth"))));
        try {
            authenticationRequest.setCommonAuthCallerPath(URLEncoder.encode(this.getTenantQualifiedCallbackPath(context), StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw FrameworkRuntimeException.error("Error occurred while URL encoding callback path " + this.getTenantQualifiedCallbackPath(context), e);
        }
        AuthenticationRequestCacheEntry authRequest = new AuthenticationRequestCacheEntry(authenticationRequest);
        String sessionDataKey = UUIDGenerator.generateUUID();
        authRequest.setValidityPeriod(TimeUnit.MINUTES.toNanos(IdentityUtil.getOperationCleanUpTimeout()));
        FrameworkUtils.addAuthenticationRequestToCache(sessionDataKey, authRequest);
        InboundUtil.addContextToCache(sessionDataKey, context);
        FrameworkLoginResponse.FrameworkLoginResponseBuilder responseBuilder = new FrameworkLoginResponse.FrameworkLoginResponseBuilder(context);
        responseBuilder.setAuthName(this.getType(context));
        responseBuilder.setContextKey(sessionDataKey);
        responseBuilder.setCallbackPath(this.getTenantQualifiedCallbackPath(context));
        responseBuilder.setRelyingParty(this.getRelyingPartyId(context));
        responseBuilder.setAuthType(this.getType(context));
        String commonAuthURL = IdentityUtil.getServerURL((String)"commonauth", (boolean)true, (boolean)true);
        responseBuilder.setRedirectURL(commonAuthURL);
        return responseBuilder;
    }

    protected FrameworkLogoutResponse.FrameworkLogoutResponseBuilder buildResponseForFrameworkLogout(IdentityMessageContext context) {
        IdentityRequest identityRequest = context.getRequest();
        Map<String, String[]> parameterMap = identityRequest.getParameterMap();
        AuthenticationRequest authenticationRequest = new AuthenticationRequest();
        authenticationRequest.appendRequestQueryParams(parameterMap);
        Set<Map.Entry<String, String>> headers = new HashMap<String, String>(identityRequest.getHeaderMap()).entrySet();
        for (Map.Entry<String, String> header : headers) {
            authenticationRequest.addHeader(header.getKey(), header.getValue());
        }
        authenticationRequest.setTenantDomain(identityRequest.getTenantDomain());
        authenticationRequest.setRelyingParty(this.getRelyingPartyId(context));
        authenticationRequest.setType(this.getType(context));
        try {
            authenticationRequest.setCommonAuthCallerPath(URLEncoder.encode(this.getTenantQualifiedCallbackPath(context), StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw FrameworkRuntimeException.error("Error occurred while URL encoding callback path " + this.getTenantQualifiedCallbackPath(context), e);
        }
        authenticationRequest.addRequestQueryParam("commonAuthLogout", new String[]{"true"});
        AuthenticationRequestCacheEntry authRequest = new AuthenticationRequestCacheEntry(authenticationRequest);
        String sessionDataKey = UUIDGenerator.generateUUID();
        authRequest.setValidityPeriod(TimeUnit.MINUTES.toNanos(IdentityUtil.getOperationCleanUpTimeout()));
        FrameworkUtils.addAuthenticationRequestToCache(sessionDataKey, authRequest);
        InboundUtil.addContextToCache(sessionDataKey, context);
        FrameworkLogoutResponse.FrameworkLogoutResponseBuilder responseBuilder = new FrameworkLogoutResponse.FrameworkLogoutResponseBuilder(context);
        responseBuilder.setAuthName(this.getType(context));
        responseBuilder.setContextKey(sessionDataKey);
        responseBuilder.setCallbackPath(this.getTenantQualifiedCallbackPath(context));
        responseBuilder.setRelyingParty(this.getRelyingPartyId(context));
        responseBuilder.setAuthType(this.getType(context));
        String commonAuthURL = IdentityUtil.getServerURL((String)"commonauth", (boolean)true, (boolean)true);
        responseBuilder.setRedirectURL(commonAuthURL);
        return responseBuilder;
    }

    protected boolean isContextAvailable(IdentityRequest request) {
        IdentityMessageContext context;
        String sessionDataKey = request.getParameter("sessionDataKey");
        if (StringUtils.isBlank((String)sessionDataKey)) {
            sessionDataKey = request.getParameter("sessionDataKeyConsent");
        }
        return StringUtils.isNotBlank((String)sessionDataKey) && (context = InboundUtil.getContextFromCache(sessionDataKey)) != null;
    }

    protected IdentityMessageContext getContextIfAvailable(IdentityRequest request) {
        String sessionDataKey = request.getParameter("sessionDataKey");
        if (StringUtils.isBlank((String)sessionDataKey)) {
            sessionDataKey = request.getParameter("sessionDataKeyConsent");
        }
        IdentityMessageContext context = null;
        if (StringUtils.isNotBlank((String)sessionDataKey)) {
            context = InboundUtil.getContextFromCache(sessionDataKey);
        }
        return context;
    }

    protected AuthenticationResult processResponseFromFrameworkLogin(IdentityMessageContext context, IdentityRequest identityRequest) {
        String sessionDataKey = identityRequest.getParameter("sessionDataKey");
        AuthenticationResultCacheEntry entry = FrameworkUtils.getAuthenticationResultFromCache(sessionDataKey);
        AuthenticationResult authnResult = null;
        if (entry == null) {
            throw FrameworkRuntimeException.error("Cannot find AuthenticationResult from the cache");
        }
        authnResult = entry.getResult();
        FrameworkUtils.removeAuthenticationResultFromCache(sessionDataKey);
        if (authnResult.isAuthenticated()) {
            context.addParameter("AuthenticationResult", authnResult);
        }
        return authnResult;
    }
}

