/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.inbound;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.inbound.FrameworkRuntimeException;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityProcessor;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityRequest;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityResponse;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;

public class IdentityProcessCoordinator {
    private static final Log log = LogFactory.getLog(IdentityProcessCoordinator.class);

    public IdentityResponse process(IdentityRequest identityRequest) throws FrameworkException {
        IdentityProcessor processor = this.getIdentityProcessor(identityRequest);
        if (processor != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Starting to process IdentityProcessor : " + processor.getName()));
            }
            return processor.process(identityRequest).build();
        }
        throw FrameworkRuntimeException.error("No IdentityProcessor found to process the request");
    }

    private IdentityProcessor getIdentityProcessor(IdentityRequest identityRequest) {
        List<IdentityProcessor> processors = FrameworkServiceDataHolder.getInstance().getIdentityProcessors();
        for (IdentityProcessor requestProcessor : processors) {
            try {
                if (!requestProcessor.canHandle(identityRequest)) continue;
                return requestProcessor;
            }
            catch (Exception e) {
                log.error((Object)("Error occurred while checking if " + requestProcessor.getName() + " can handle " + identityRequest.toString()));
            }
        }
        return null;
    }
}

