/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.inbound;

import java.io.Serializable;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityMessageContext;
import org.wso2.carbon.identity.application.authentication.framework.store.SessionDataStore;
import org.wso2.carbon.identity.application.common.cache.BaseCache;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public class IdentityContextCache
extends BaseCache<String, IdentityMessageContext> {
    private static final String INBOUND_CONTEXT_CACHE_NAME = "InboundContextCache";
    private static volatile IdentityContextCache instance;
    private boolean enableRequestScopeCache = false;

    private IdentityContextCache(String cacheName) {
        super(cacheName);
        if (IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.Temporary") != null) {
            this.enableRequestScopeCache = Boolean.parseBoolean(IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.Temporary"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IdentityContextCache getInstance() {
        if (instance != null) return instance;
        Class<IdentityContextCache> clazz = IdentityContextCache.class;
        synchronized (IdentityContextCache.class) {
            if (instance != null) return instance;
            instance = new IdentityContextCache(INBOUND_CONTEXT_CACHE_NAME);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addToCache(String key, IdentityMessageContext context) {
        super.addToCache((Serializable)((Object)key), (Serializable)context);
        if (this.enableRequestScopeCache) {
            int tenantId = -1;
            String tenantDomain = context.getRequest().getTenantDomain();
            if (tenantDomain != null) {
                tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
            }
            SessionDataStore.getInstance().storeSessionData(key, INBOUND_CONTEXT_CACHE_NAME, context, tenantId);
        }
    }

    public IdentityMessageContext getValueFromCache(String key) {
        IdentityMessageContext context = (IdentityMessageContext)super.getValueFromCache((Serializable)((Object)key));
        if (context == null && this.enableRequestScopeCache) {
            context = (IdentityMessageContext)SessionDataStore.getInstance().getSessionData(key, INBOUND_CONTEXT_CACHE_NAME);
        }
        return context;
    }

    public void clearCacheEntry(String key) {
        super.clearCacheEntry((Serializable)((Object)key));
        if (this.enableRequestScopeCache) {
            SessionDataStore.getInstance().clearSessionData(key, INBOUND_CONTEXT_CACHE_NAME);
        }
    }
}

