/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.inbound;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityResponse;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityResponse;
import org.wso2.carbon.identity.core.handler.AbstractIdentityHandler;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.identity.core.model.IdentityEventListenerConfig;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public abstract class HttpIdentityResponseFactory
extends AbstractIdentityHandler {
    private static Log log = LogFactory.getLog(HttpIdentityResponseFactory.class);
    protected final Properties properties = new Properties();
    protected InitConfig initConfig;

    public void init(InitConfig initConfig) {
        this.initConfig = initConfig;
        IdentityEventListenerConfig identityEventListenerConfig = IdentityUtil.readEventListenerProperty((String)HttpIdentityResponseFactory.class.getName(), (String)((Object)((Object)this)).getClass().getName());
        if (identityEventListenerConfig == null) {
            return;
        }
        if (identityEventListenerConfig.getProperties() != null) {
            for (Map.Entry<Object, Object> property : identityEventListenerConfig.getProperties().entrySet()) {
                String key = (String)property.getKey();
                String value = (String)property.getValue();
                if (!this.properties.containsKey(key)) {
                    this.properties.setProperty(key, value);
                    continue;
                }
                log.warn((Object)("Property key " + key + " already exists. Cannot add property!!"));
            }
        }
    }

    public abstract boolean canHandle(IdentityResponse var1);

    public boolean canHandle(FrameworkException exception) {
        return false;
    }

    public boolean canHandle(RuntimeException exception) {
        return false;
    }

    public abstract HttpIdentityResponse.HttpIdentityResponseBuilder create(IdentityResponse var1);

    public abstract void create(HttpIdentityResponse.HttpIdentityResponseBuilder var1, IdentityResponse var2);

    public HttpIdentityResponse.HttpIdentityResponseBuilder handleException(FrameworkException exception) {
        HttpIdentityResponse.HttpIdentityResponseBuilder builder = new HttpIdentityResponse.HttpIdentityResponseBuilder();
        builder.setStatusCode(500);
        return builder;
    }

    public HttpIdentityResponse.HttpIdentityResponseBuilder handleException(RuntimeException exception) {
        HttpIdentityResponse.HttpIdentityResponseBuilder builder = new HttpIdentityResponse.HttpIdentityResponseBuilder();
        builder.setStatusCode(500);
        return builder;
    }
}

