/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.inbound;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.authentication.framework.inbound.FrameworkClientException;
import org.wso2.carbon.identity.application.authentication.framework.inbound.HttpIdentityResponse;
import org.wso2.carbon.identity.application.authentication.framework.inbound.IdentityRequest;
import org.wso2.carbon.identity.core.handler.AbstractIdentityHandler;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.identity.core.model.IdentityEventListenerConfig;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public class HttpIdentityRequestFactory
extends AbstractIdentityHandler {
    private static Log log = LogFactory.getLog(HttpIdentityRequestFactory.class);
    protected final Properties properties = new Properties();
    protected InitConfig initConfig;

    public void init(InitConfig initConfig) {
        this.initConfig = initConfig;
        IdentityEventListenerConfig identityEventListenerConfig = IdentityUtil.readEventListenerProperty((String)HttpIdentityRequestFactory.class.getName(), (String)((Object)((Object)this)).getClass().getName());
        if (identityEventListenerConfig == null) {
            return;
        }
        if (identityEventListenerConfig.getProperties() != null) {
            for (Map.Entry<Object, Object> property : identityEventListenerConfig.getProperties().entrySet()) {
                String key = (String)property.getKey();
                String value = (String)property.getValue();
                if (!this.properties.containsKey(key)) {
                    this.properties.setProperty(key, value);
                    continue;
                }
                log.warn((Object)("Property key " + key + " already exists. Cannot add property!!"));
            }
        }
    }

    public boolean canHandle(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    public IdentityRequest.IdentityRequestBuilder create(HttpServletRequest request, HttpServletResponse response) throws FrameworkClientException {
        IdentityRequest.IdentityRequestBuilder builder = new IdentityRequest.IdentityRequestBuilder(request, response);
        this.create(builder, request, response);
        return builder;
    }

    public void create(IdentityRequest.IdentityRequestBuilder builder, HttpServletRequest request, HttpServletResponse response) throws FrameworkClientException {
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            builder.addHeader(headerName, request.getHeader(headerName));
        }
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>(request.getParameterMap());
        builder.setParameters(paramMap);
        Enumeration attrNames = request.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            builder.addAttribute(attrName, request.getAttribute(attrName));
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                builder.addCookie(cookie.getName(), cookie);
            }
        }
        String requestURI = request.getRequestURI();
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        if (StringUtils.isNotBlank((String)tenantDomain)) {
            builder.setTenantDomain(tenantDomain);
        } else {
            builder.setTenantDomain("carbon.super");
        }
        builder.setContentType(request.getContentType());
        builder.setContextPath(request.getContextPath());
        builder.setMethod(request.getMethod());
        builder.setPathInfo(request.getPathInfo());
        builder.setPathTranslated(request.getPathTranslated());
        builder.setQueryString(request.getQueryString());
        builder.setRequestURI(requestURI);
        builder.setRequestURL(request.getRequestURL());
        builder.setServletPath(request.getServletPath());
    }

    public HttpIdentityResponse.HttpIdentityResponseBuilder handleException(FrameworkClientException exception, HttpServletRequest request, HttpServletResponse response) {
        HttpIdentityResponse.HttpIdentityResponseBuilder builder = new HttpIdentityResponse.HttpIdentityResponseBuilder();
        builder.setStatusCode(400);
        builder.setBody(exception.getMessage());
        return builder;
    }

    public HttpIdentityResponse.HttpIdentityResponseBuilder handleException(RuntimeException exception, HttpServletRequest request, HttpServletResponse response) {
        HttpIdentityResponse.HttpIdentityResponseBuilder builder = new HttpIdentityResponse.HttpIdentityResponseBuilder();
        builder.setStatusCode(500);
        return builder;
    }
}

