/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.handler.step.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticatorFlowStatus;
import org.wso2.carbon.identity.application.authentication.framework.config.model.AuthenticatorConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.handler.step.StepHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.step.impl.DefaultStepHandler;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.model.User;

public class GraphBasedStepHandler
extends DefaultStepHandler
implements StepHandler {
    private static final Log log = LogFactory.getLog(GraphBasedStepHandler.class);

    @Override
    protected void handleFailedAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context, AuthenticatorConfig authenticatorConfig, User user) {
        super.handleFailedAuthentication(request, response, context, authenticatorConfig, user);
        if (user != null) {
            AuthenticatedUser lastAttemptedUser = this.buildAuthenticatedUser(user);
            context.setProperty("lastLoginFailedUser", (Object)lastAttemptedUser);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Last attempted user : " + lastAttemptedUser.toFullQualifiedUsername() + " is set in the authentication context for failed login attempt to service provider: " + context.getServiceProviderName()));
            }
        }
        request.setAttribute("authenticatorFlowStatus", (Object)AuthenticatorFlowStatus.FAIL_COMPLETED);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authentication flow status set to '" + AuthenticatorFlowStatus.FAIL_COMPLETED + "' for authentication attempt made to service provider: " + context.getServiceProviderName()));
        }
    }

    private AuthenticatedUser buildAuthenticatedUser(User user) {
        AuthenticatedUser authenticatedUser = new AuthenticatedUser();
        authenticatedUser.setUserName(user.getUserName());
        authenticatedUser.setTenantDomain(user.getTenantDomain());
        authenticatedUser.setUserStoreDomain(user.getUserStoreDomain());
        return authenticatedUser;
    }
}

