/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.handler.step.impl;

import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.ApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticatorFlowStatus;
import org.wso2.carbon.identity.application.authentication.framework.FederatedApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.config.ConfigurationFacade;
import org.wso2.carbon.identity.application.authentication.framework.config.builder.FileBasedConfigurationBuilder;
import org.wso2.carbon.identity.application.authentication.framework.config.model.AuthenticatorConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ExternalIdPConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthHistory;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.AuthenticationFailedException;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.exception.InvalidCredentialsException;
import org.wso2.carbon.identity.application.authentication.framework.exception.LogoutFailedException;
import org.wso2.carbon.identity.application.authentication.framework.handler.step.StepHandler;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedIdPData;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.core.model.IdentityErrorMsgContext;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;

public class DefaultStepHandler
implements StepHandler {
    private static final Log log = LogFactory.getLog(DefaultStepHandler.class);
    private static volatile DefaultStepHandler instance;
    private static String RE_CAPTCHA_USER_DOMAIN;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultStepHandler getInstance() {
        if (instance != null) return instance;
        Class<DefaultStepHandler> clazz = DefaultStepHandler.class;
        synchronized (DefaultStepHandler.class) {
            if (instance != null) return instance;
            instance = new DefaultStepHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws FrameworkException {
        if (context.getAnalyticsData("currentAuthenticatorStartTime") == null) {
            context.setAnalyticsData("currentAuthenticatorStartTime", Long.valueOf(System.currentTimeMillis()));
        }
        StepConfig stepConfig = context.getSequenceConfig().getStepMap().get(context.getCurrentStep());
        List<AuthenticatorConfig> authConfigList = stepConfig.getAuthenticatorList();
        String authenticatorNames = FrameworkUtils.getAuthenticatorIdPMappingString(authConfigList);
        String loginPage = ConfigurationFacade.getInstance().getAuthenticationEndpointURL();
        String fidp = request.getParameter("fidp");
        Map<String, AuthenticatedIdPData> authenticatedIdPs = context.getCurrentAuthenticatedIdPs();
        if (MapUtils.isEmpty(authenticatedIdPs)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No current authenticated IDPs in the authentication context. Continuing with the previous authenticated IDPs");
            }
            authenticatedIdPs = context.getPreviousAuthenticatedIdPs();
        }
        if (log.isDebugEnabled()) {
            if (MapUtils.isEmpty(authenticatedIdPs)) {
                log.debug((Object)"No previous authenticated IDPs found in the authentication context.");
            } else {
                log.debug((Object)String.format("Found authenticated IdPs. Count: %d", authenticatedIdPs.size()));
            }
        }
        Map<String, AuthenticatorConfig> authenticatedStepIdps = FrameworkUtils.getAuthenticatedStepIdPs(stepConfig, authenticatedIdPs);
        if (context.isPassiveAuthenticate()) {
            if (authenticatedStepIdps.isEmpty()) {
                context.setRequestAuthenticated(false);
            } else {
                String authenticatedIdP = authenticatedStepIdps.entrySet().iterator().next().getKey();
                AuthenticatedIdPData authenticatedIdPData = authenticatedIdPs.get(authenticatedIdP);
                this.populateStepConfigWithAuthenticationDetails(stepConfig, authenticatedIdPData, authenticatedStepIdps.get(authenticatedIdP));
            }
            stepConfig.setCompleted(true);
            return;
        }
        long authTime = 0L;
        String max_age = request.getParameter("max_age");
        if (StringUtils.isNotBlank((String)max_age) && StringUtils.isNotBlank((String)context.getSessionIdentifier())) {
            long maxAge = Long.parseLong(max_age);
            authTime = FrameworkUtils.getSessionContextFromCache(context.getSessionIdentifier()).getProperty("UpdatedTimestamp") != null ? Long.parseLong(FrameworkUtils.getSessionContextFromCache(context.getSessionIdentifier()).getProperty("UpdatedTimestamp").toString()) : Long.parseLong(FrameworkUtils.getSessionContextFromCache(context.getSessionIdentifier()).getProperty("CreatedTimestamp").toString());
            long current_time = System.currentTimeMillis();
            if (maxAge < (current_time - authTime) / 1000L) {
                context.setForceAuthenticate(true);
            } else {
                context.setPreviousAuthTime(true);
            }
        }
        if (request.getParameter("userAbort") != null && Boolean.parseBoolean(request.getParameter("userAbort"))) {
            request.setAttribute("authenticatorFlowStatus", (Object)AuthenticatorFlowStatus.USER_ABORT);
            stepConfig.setCompleted(true);
            return;
        }
        if (fidp != null && stepConfig.getOrder() == 1) {
            this.handleHomeRealmDiscovery(request, response, context);
            return;
        }
        if (context.isReturning()) {
            if (request.getParameter("authenticator") != null && !request.getParameter("authenticator").isEmpty()) {
                this.handleRequestFromLoginPage(request, response, context);
                return;
            }
            this.handleResponse(request, response, context);
            return;
        }
        if (ConfigurationFacade.getInstance().isDumbMode() && authenticatedIdPs.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Executing in Dumb mode");
            }
            try {
                request.setAttribute("authenticatorFlowStatus", (Object)AuthenticatorFlowStatus.INCOMPLETE);
                response.sendRedirect(loginPage + "?" + context.getContextIdIncludedQueryParams() + "&authenticators=" + URLEncoder.encode(authenticatorNames, "UTF-8") + "&hrd=true");
            }
            catch (IOException e) {
                throw new FrameworkException(e.getMessage(), e);
            }
        }
        if (!(context.isForceAuthenticate() || stepConfig.isForced() || authenticatedStepIdps.isEmpty())) {
            Map.Entry<String, AuthenticatorConfig> entry = authenticatedStepIdps.entrySet().iterator().next();
            String idp = entry.getKey();
            AuthenticatorConfig authenticatorConfig = entry.getValue();
            if (context.isReAuthenticate()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Re-authenticating with " + idp + " IdP"));
                }
                try {
                    context.setExternalIdP(ConfigurationFacade.getInstance().getIdPConfigByName(idp, context.getTenantDomain()));
                }
                catch (IdentityProviderManagementException e) {
                    log.error((Object)"Exception while getting IdP by name", (Throwable)e);
                }
                this.doAuthentication(request, response, context, authenticatorConfig);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Already authenticated. Skipping the step");
            }
            AuthenticatedIdPData authenticatedIdPData = authenticatedIdPs.get(idp);
            this.populateStepConfigWithAuthenticationDetails(stepConfig, authenticatedIdPData, authenticatedStepIdps.get(idp));
            stepConfig.setCompleted(true);
            request.setAttribute("authenticatorFlowStatus", (Object)AuthenticatorFlowStatus.SUCCESS_COMPLETED);
            return;
        }
        boolean sendToPage = false;
        AuthenticatorConfig authenticatorConfig = null;
        if (authConfigList.size() > 1) {
            sendToPage = true;
        } else {
            authenticatorConfig = authConfigList.get(0);
            if (authenticatorConfig.getIdpNames().size() > 1) {
                sendToPage = true;
            }
        }
        if (!sendToPage) {
            if (!authenticatorConfig.getIdpNames().isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Step contains only a single IdP. Going to call it directly");
                }
                try {
                    context.setExternalIdP(ConfigurationFacade.getInstance().getIdPConfigByName(authenticatorConfig.getIdpNames().get(0), context.getTenantDomain()));
                }
                catch (IdentityProviderManagementException e) {
                    log.error((Object)"Exception while getting IdP by name", (Throwable)e);
                }
            }
            this.doAuthentication(request, response, context, authenticatorConfig);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sending to the Multi Option page");
        }
        Map<String, String> parameterMap = this.getAuthenticatorConfig().getParameterMap();
        String showAuthFailureReason = null;
        if (parameterMap != null) {
            showAuthFailureReason = parameterMap.get("showAuthFailureReason");
            if (log.isDebugEnabled()) {
                log.debug((Object)("showAuthFailureReason has been set as : " + showAuthFailureReason));
            }
        }
        String retryParam = "";
        if (stepConfig.isRetrying()) {
            context.setCurrentAuthenticator(null);
            retryParam = "&authFailure=true&authFailureMsg=login.fail.message";
        }
        try {
            request.setAttribute("authenticatorFlowStatus", (Object)AuthenticatorFlowStatus.INCOMPLETE);
            response.sendRedirect(this.getRedirectUrl(request, response, context, authenticatorNames, showAuthFailureReason, retryParam, loginPage));
        }
        catch (IOException e) {
            throw new FrameworkException(e.getMessage(), e);
        }
        return;
    }

    protected void handleHomeRealmDiscovery(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws FrameworkException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Request contains fidp parameter. Initiating Home Realm Discovery");
        }
        String domain = request.getParameter("fidp");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received domain: " + domain));
        }
        SequenceConfig sequenceConfig = context.getSequenceConfig();
        StepConfig stepConfig = sequenceConfig.getStepMap().get(context.getCurrentStep());
        List<AuthenticatorConfig> authConfigList = stepConfig.getAuthenticatorList();
        String authenticatorNames = FrameworkUtils.getAuthenticatorIdPMappingString(authConfigList);
        String redirectURL = ConfigurationFacade.getInstance().getAuthenticationEndpointURL();
        if (domain.trim().length() == 0) {
            try {
                request.setAttribute("authenticatorFlowStatus", (Object)AuthenticatorFlowStatus.INCOMPLETE);
                response.sendRedirect(redirectURL + "?" + context.getContextIdIncludedQueryParams() + "&authenticators=" + URLEncoder.encode(authenticatorNames, "UTF-8") + "&hrd=true");
            }
            catch (IOException e) {
                throw new FrameworkException(e.getMessage(), e);
            }
            return;
        }
        String homeRealm = FrameworkUtils.getHomeRealmDiscoverer().discover(domain);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Home realm discovered: " + homeRealm));
        }
        ExternalIdPConfig externalIdPConfig = null;
        try {
            externalIdPConfig = ConfigurationFacade.getInstance().getIdPConfigByRealm(homeRealm, context.getTenantDomain());
        }
        catch (IdentityProviderManagementException e) {
            log.error((Object)"Exception while getting IdP by realm", (Throwable)e);
        }
        if (externalIdPConfig != null) {
            Map<String, AuthenticatedIdPData> authenticatedIdPs;
            Map<String, AuthenticatorConfig> authenticatedStepIdps;
            String idpName = externalIdPConfig.getIdPName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found IdP of the realm: " + idpName));
            }
            if ((authenticatedStepIdps = FrameworkUtils.getAuthenticatedStepIdPs(stepConfig, authenticatedIdPs = context.getPreviousAuthenticatedIdPs())).containsKey(idpName) && !context.isForceAuthenticate() && !stepConfig.isForced() && !context.isReAuthenticate()) {
                AuthenticatedIdPData authenticatedIdPData = authenticatedIdPs.get(idpName);
                this.populateStepConfigWithAuthenticationDetails(stepConfig, authenticatedIdPData, authenticatedStepIdps.get(idpName));
                stepConfig.setCompleted(true);
                return;
            }
            for (AuthenticatorConfig authConfig : authConfigList) {
                if (!authConfig.getIdpNames().contains(idpName)) continue;
                context.setExternalIdP(externalIdPConfig);
                this.doAuthentication(request, response, context, authConfig);
                return;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"An IdP was not found for the sent domain. Sending to the domain page");
        }
        String errorMsg = "domain.unknown";
        try {
            request.setAttribute("authenticatorFlowStatus", (Object)AuthenticatorFlowStatus.INCOMPLETE);
            response.sendRedirect(redirectURL + "?" + context.getContextIdIncludedQueryParams() + "&authenticators=" + URLEncoder.encode(authenticatorNames, "UTF-8") + "&authFailure=true&authFailureMsg=" + errorMsg + "&hrd=true");
        }
        catch (IOException e) {
            throw new FrameworkException(e.getMessage(), e);
        }
    }

    protected void handleRequestFromLoginPage(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws FrameworkException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Relieved a request from the multi option page");
        }
        SequenceConfig sequenceConfig = context.getSequenceConfig();
        int currentStep = context.getCurrentStep();
        StepConfig stepConfig = sequenceConfig.getStepMap().get(currentStep);
        String selectedIdp = request.getParameter("idp");
        if (selectedIdp != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User has selected IdP: " + selectedIdp));
            }
            try {
                ExternalIdPConfig externalIdPConfig = ConfigurationFacade.getInstance().getIdPConfigByName(selectedIdp, context.getTenantDomain());
                context.setExternalIdP(externalIdPConfig);
            }
            catch (IdentityProviderManagementException e) {
                log.error((Object)"Exception while getting IdP by name", (Throwable)e);
            }
        }
        for (AuthenticatorConfig authenticatorConfig : stepConfig.getAuthenticatorList()) {
            ApplicationAuthenticator authenticator = authenticatorConfig.getApplicationAuthenticator();
            if (authenticator == null || !authenticator.getName().equalsIgnoreCase(request.getParameter("authenticator"))) continue;
            if (StringUtils.isNotBlank((String)selectedIdp) && authenticatorConfig.getIdps().get(selectedIdp) == null) {
                throw new FrameworkException("Authenticators configured for application and user selected idp does not match. Possible tampering of parameters in login page.");
            }
            this.doAuthentication(request, response, context, authenticatorConfig);
            return;
        }
    }

    protected void handleResponse(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws FrameworkException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Receive a response from the external party");
        }
        SequenceConfig sequenceConfig = context.getSequenceConfig();
        int currentStep = context.getCurrentStep();
        boolean isNoneCanHandle = true;
        StepConfig stepConfig = sequenceConfig.getStepMap().get(currentStep);
        for (AuthenticatorConfig authenticatorConfig : stepConfig.getAuthenticatorList()) {
            ApplicationAuthenticator authenticator = authenticatorConfig.getApplicationAuthenticator();
            if (authenticator == null || !authenticator.canHandle(request) || context.getCurrentAuthenticator() != null && !authenticator.getName().equals(context.getCurrentAuthenticator())) continue;
            isNoneCanHandle = false;
            if (log.isDebugEnabled()) {
                log.debug((Object)(authenticator.getName() + " can handle the request."));
            }
            this.doAuthentication(request, response, context, authenticatorConfig);
            break;
        }
        if (isNoneCanHandle) {
            throw new FrameworkException("No authenticator can handle the request in step :  " + currentStep);
        }
    }

    protected void doAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context, AuthenticatorConfig authenticatorConfig) throws FrameworkException {
        SequenceConfig sequenceConfig = context.getSequenceConfig();
        int currentStep = context.getCurrentStep();
        StepConfig stepConfig = sequenceConfig.getStepMap().get(currentStep);
        ApplicationAuthenticator authenticator = authenticatorConfig.getApplicationAuthenticator();
        if (authenticator == null) {
            log.error((Object)("Authenticator is null for AuthenticatorConfig: " + authenticatorConfig.getName()));
            return;
        }
        String idpName = "LOCAL";
        if (context.getExternalIdP() != null && authenticator instanceof FederatedApplicationAuthenticator) {
            idpName = context.getExternalIdP().getIdPName();
        }
        try {
            Serializable startTime;
            Object idpSessionIndexParamValue;
            context.setAuthenticatorProperties(FrameworkUtils.getAuthenticatorPropertyMapFromIdP(context.getExternalIdP(), authenticator.getName()));
            AuthenticatorFlowStatus status = authenticator.process(request, response, context);
            request.setAttribute("authenticatorFlowStatus", (Object)status);
            if (log.isDebugEnabled()) {
                log.debug((Object)(authenticator.getName() + " returned: " + status.toString()));
            }
            if (status == AuthenticatorFlowStatus.INCOMPLETE) {
                context.setCurrentAuthenticator(authenticator.getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)(authenticator.getName() + " is redirecting"));
                }
                return;
            }
            if (authenticator instanceof FederatedApplicationAuthenticator) {
                if (context.getSubject().getUserName() == null) {
                    String authenticatedSubjectIdentifier = context.getSubject().getAuthenticatedSubjectIdentifier();
                    context.getSubject().setUserName(authenticatedSubjectIdentifier);
                }
                if (context.getSubject().getFederatedIdPName() == null && context.getExternalIdP() != null) {
                    context.getSubject().setFederatedIdPName(idpName);
                }
                if (context.getSubject().getTenantDomain() == null) {
                    String tenantDomain = context.getTenantDomain();
                    context.getSubject().setTenantDomain(tenantDomain);
                }
            }
            AuthenticatedIdPData authenticatedIdPData = this.getAuthenticatedIdPData(context, idpName);
            AuthenticatedUser authenticatedUser = context.getSubject();
            stepConfig.setAuthenticatedUser(authenticatedUser);
            authenticatedIdPData.setUser(authenticatedUser);
            authenticatorConfig.setAuthenticatorStateInfo(context.getStateInfo());
            stepConfig.setAuthenticatedAutenticator(authenticatorConfig);
            stepConfig.setAuthenticatedIdP(idpName);
            authenticatedIdPData.setIdpName(idpName);
            authenticatedIdPData.addAuthenticator(authenticatorConfig);
            context.getCurrentAuthenticatedIdPs().put(idpName, authenticatedIdPData);
            String idpSessionIndex = null;
            String parameterName = "FederatedIdPSessionIndex_" + idpName;
            AuthHistory authHistory = new AuthHistory(authenticator.getName(), idpName);
            if (context.getParameters().containsKey(parameterName) && (idpSessionIndexParamValue = context.getParameter(parameterName)) != null) {
                idpSessionIndex = idpSessionIndexParamValue.toString();
            }
            if (StringUtils.isNotBlank((String)context.getCurrentAuthenticator()) && StringUtils.isNotBlank(idpSessionIndex) && "SAMLSSOAuthenticator".equals(context.getCurrentAuthenticator())) {
                authHistory.setIdpSessionIndex(idpSessionIndex);
                authHistory.setRequestType(context.getRequestType());
            }
            if ((startTime = context.getAnalyticsData("currentAuthenticatorStartTime")) instanceof Long) {
                authHistory.setDuration((Long)startTime - System.currentTimeMillis());
            }
            authHistory.setSuccess(true);
            context.addAuthenticationStepHistory(authHistory);
        }
        catch (InvalidCredentialsException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"A login attempt was failed due to invalid credentials", (Throwable)((Object)e));
            }
            this.handleFailedAuthentication(request, response, context, authenticatorConfig, e.getUser());
        }
        catch (AuthenticationFailedException e) {
            IdentityErrorMsgContext errorContext = IdentityUtil.getIdentityErrorMsg();
            if (errorContext != null) {
                if (!"17007".equals(errorContext.getErrorCode())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Authentication failed exception!", (Throwable)((Object)e));
                    }
                    log.error((Object)("Authentication failed exception! " + e.getMessage()));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Authentication failed exception!", (Throwable)((Object)e));
                }
                log.error((Object)("Authentication failed exception! " + e.getMessage()));
            }
            this.handleFailedAuthentication(request, response, context, authenticatorConfig, e.getUser());
        }
        catch (LogoutFailedException e) {
            throw new FrameworkException(e.getMessage(), (Throwable)((Object)e));
        }
        stepConfig.setCompleted(true);
    }

    protected void handleFailedAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context, AuthenticatorConfig authenticatorConfig, User user) {
        context.setRequestAuthenticated(false);
        request.setAttribute("authenticatorFlowStatus", (Object)AuthenticatorFlowStatus.FAIL_COMPLETED);
    }

    @Deprecated
    protected void populateStepConfigWithAuthenticationDetails(StepConfig stepConfig, AuthenticatedIdPData authenticatedIdPData) {
        stepConfig.setAuthenticatedUser(authenticatedIdPData.getUser());
        stepConfig.setAuthenticatedIdP(authenticatedIdPData.getIdpName());
        stepConfig.setAuthenticatedAutenticator(authenticatedIdPData.getAuthenticator());
    }

    protected void populateStepConfigWithAuthenticationDetails(StepConfig stepConfig, AuthenticatedIdPData authenticatedIdPData, AuthenticatorConfig authenticatedStepIdp) {
        stepConfig.setAuthenticatedUser(authenticatedIdPData.getUser());
        stepConfig.setAuthenticatedIdP(authenticatedIdPData.getIdpName());
        stepConfig.setAuthenticatedAutenticator(authenticatedStepIdp);
    }

    private AuthenticatedIdPData getAuthenticatedIdPData(AuthenticationContext context, String idpName) {
        AuthenticatedIdPData authenticatedIdPData = null;
        if (context.getCurrentAuthenticatedIdPs() != null && context.getCurrentAuthenticatedIdPs().get(idpName) != null) {
            authenticatedIdPData = context.getCurrentAuthenticatedIdPs().get(idpName);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Authenticated IDP data of the IDP '%s' could be found in current authenticated IDPs", idpName));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Authenticated IDP data of the IDP '%s' couldn't be found in current authenticate IDPs. Trying previous authenticated IDPs", idpName));
            }
            if (context.getPreviousAuthenticatedIdPs() != null && context.getPreviousAuthenticatedIdPs().get(idpName) != null) {
                authenticatedIdPData = context.getPreviousAuthenticatedIdPs().get(idpName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Authenticated IDP data of the IDP '%s' could be found in previous authenticated IDPs", idpName));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Authenticated IDP data for the IDP '%s' couldn't be found in previous authenticate IDPs as well. Using a fresh AuthenticatedIdPData object", idpName));
                }
                authenticatedIdPData = new AuthenticatedIdPData();
            }
        }
        return authenticatedIdPData;
    }

    private String getRedirectUrl(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context, String authenticatorNames, String showAuthFailureReason, String retryParam, String loginPage) throws IOException {
        String errorCode;
        IdentityErrorMsgContext errorContext = IdentityUtil.getIdentityErrorMsg();
        IdentityUtil.clearIdentityErrorMsg();
        retryParam = this.handleIdentifierFirstLogin(context, retryParam);
        String otp = (String)context.getProperty("PASSWORD_PROPERTY");
        context.getProperties().remove("PASSWORD_PROPERTY");
        if (showAuthFailureReason != null && "true".equals(showAuthFailureReason)) {
            if (errorContext != null) {
                String username;
                String[] errorCodeReason;
                String errorCode2 = errorContext.getErrorCode();
                String reason = null;
                if (errorCode2.contains(":") && (errorCodeReason = errorCode2.split(":")).length > 1) {
                    errorCode2 = errorCodeReason[0];
                    reason = errorCodeReason[1];
                }
                int remainingAttempts = errorContext.getMaximumLoginAttempts() - errorContext.getFailedLoginAttempts();
                if (log.isDebugEnabled()) {
                    StringBuilder debugString = new StringBuilder();
                    debugString.append("Identity error message context is not null. Error details are as follows.");
                    debugString.append("errorCode : " + errorCode2 + "\n");
                    debugString.append("username : " + request.getParameter("username") + "\n");
                    debugString.append("remainingAttempts : " + remainingAttempts);
                    log.debug((Object)debugString.toString());
                }
                if ("17002".equals(errorCode2)) {
                    retryParam = retryParam + "&errorCode=" + errorCode2 + "&failedUsername=" + URLEncoder.encode(request.getParameter("username"), "UTF-8") + "&remainingAttempts=" + remainingAttempts;
                    return response.encodeRedirectURL(loginPage + "?" + context.getContextIdIncludedQueryParams()) + "&authenticators=" + URLEncoder.encode(authenticatorNames, "UTF-8") + retryParam;
                }
                if ("17003".equals(errorCode2)) {
                    String redirectURL = remainingAttempts == 0 ? (StringUtils.isBlank((String)reason) ? response.encodeRedirectURL(loginPage + "?" + context.getContextIdIncludedQueryParams()) + "&errorCode=" + errorCode2 + "&failedUsername=" + URLEncoder.encode(request.getParameter("username"), "UTF-8") + "&remainingAttempts=0&authenticators=" + URLEncoder.encode(authenticatorNames, "UTF-8") + retryParam : response.encodeRedirectURL(loginPage + "?" + context.getContextIdIncludedQueryParams()) + "&errorCode=" + errorCode2 + "&lockedReason=" + reason + "&failedUsername=" + URLEncoder.encode(request.getParameter("username"), "UTF-8") + "&remainingAttempts=0&authenticators=" + URLEncoder.encode(authenticatorNames, "UTF-8") + retryParam) : (StringUtils.isBlank((String)reason) ? response.encodeRedirectURL(loginPage + "?" + context.getContextIdIncludedQueryParams()) + "&errorCode=" + errorCode2 + "&failedUsername=" + URLEncoder.encode(request.getParameter("username"), "UTF-8") + "&authenticators=" + URLEncoder.encode(authenticatorNames, "UTF-8") + retryParam : response.encodeRedirectURL(loginPage + "?" + context.getContextIdIncludedQueryParams()) + "&errorCode=" + errorCode2 + "&lockedReason=" + reason + "&failedUsername=" + URLEncoder.encode(request.getParameter("username"), "UTF-8") + "&authenticators=" + URLEncoder.encode(authenticatorNames, "UTF-8") + retryParam);
                    return redirectURL;
                }
                if ("17005".equals(errorCode2)) {
                    retryParam = "&authFailure=true&authFailureMsg=account.confirmation.pending";
                    username = request.getParameter("username");
                    Object domain = ((Map)IdentityUtil.threadLocalProperties.get()).get(RE_CAPTCHA_USER_DOMAIN);
                    if (domain != null) {
                        username = IdentityUtil.addDomainToName((String)username, (String)domain.toString());
                    }
                    retryParam = retryParam + "&errorCode=" + errorCode2 + "&failedUsername=" + URLEncoder.encode(username, "UTF-8");
                    return response.encodeRedirectURL(loginPage + "?" + context.getContextIdIncludedQueryParams()) + "&authenticators=" + URLEncoder.encode(authenticatorNames, "UTF-8") + retryParam;
                }
                if ("17007".equals(errorCode2)) {
                    username = request.getParameter("username");
                    return response.encodeRedirectURL("accountrecoveryendpoint/confirmrecovery.do?" + context.getContextIdIncludedQueryParams()) + "&username=" + URLEncoder.encode(username, "UTF-8") + "&confirmation=" + otp;
                }
                retryParam = retryParam + "&errorCode=" + errorCode2 + "&failedUsername=" + URLEncoder.encode(request.getParameter("username"), "UTF-8");
                return response.encodeRedirectURL(loginPage + "?" + context.getContextIdIncludedQueryParams()) + "&authenticators=" + URLEncoder.encode(authenticatorNames, "UTF-8") + retryParam;
            }
            return response.encodeRedirectURL(loginPage + "?" + context.getContextIdIncludedQueryParams()) + "&authenticators=" + URLEncoder.encode(authenticatorNames, "UTF-8") + retryParam;
        }
        String string = errorCode = errorContext != null ? errorContext.getErrorCode() : null;
        if ("17003".equals(errorCode)) {
            String redirectURL = response.encodeRedirectURL(loginPage + "?" + context.getContextIdIncludedQueryParams()) + "&failedUsername=" + URLEncoder.encode(request.getParameter("username"), "UTF-8") + "&authenticators=" + URLEncoder.encode(authenticatorNames, "UTF-8") + retryParam;
            return redirectURL;
        }
        if ("17007".equals(errorCode)) {
            String username = request.getParameter("username");
            return response.encodeRedirectURL("accountrecoveryendpoint/confirmrecovery.do?" + context.getContextIdIncludedQueryParams()) + "&username=" + URLEncoder.encode(username, "UTF-8") + "&confirmation=" + otp;
        }
        return response.encodeRedirectURL(loginPage + "?" + context.getContextIdIncludedQueryParams()) + "&authenticators=" + URLEncoder.encode(authenticatorNames, "UTF-8") + retryParam;
    }

    private String handleIdentifierFirstLogin(AuthenticationContext context, String retryParam) {
        Map<String, String> runtimeParams = context.getAuthenticatorParams("common");
        String promptType = null;
        String usernameFromContext = null;
        if (runtimeParams != null && (usernameFromContext = runtimeParams.get("username")) != null) {
            promptType = "idf";
        }
        if (promptType != null) {
            retryParam = retryParam + "&inputType=" + promptType;
            context.addEndpointParam("username", (Serializable)((Object)usernameFromContext));
        }
        return retryParam;
    }

    private AuthenticatorConfig getAuthenticatorConfig() {
        AuthenticatorConfig authConfig = FileBasedConfigurationBuilder.getInstance().getAuthenticatorBean("BasicAuthenticator");
        if (authConfig == null) {
            authConfig = new AuthenticatorConfig();
            authConfig.setParameterMap(new HashMap<String, String>());
        }
        return authConfig;
    }

    static {
        RE_CAPTCHA_USER_DOMAIN = "user-domain-recaptcha";
    }
}

