/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.handler.sequence.impl;

import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.JsAuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.handler.sequence.impl.SelectOneFunction;

public class SelectAcrFromFunction
implements SelectOneFunction {
    private static final Log log = LogFactory.getLog(SelectAcrFromFunction.class);

    @Override
    public String evaluate(JsAuthenticationContext context, Object possibleOutcomesObj) {
        String[] possibleOutcomes = this.extractPossibleOutcomes(context, possibleOutcomesObj);
        List<String> acrListRequested = ((AuthenticationContext)context.getWrapped()).getRequestedAcr();
        if (acrListRequested == null || acrListRequested.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ACR values from context is empty. Selecting the default outcome as null.");
            }
            return null;
        }
        if (possibleOutcomes.length > 0) {
            return this.selectBestOutcome(acrListRequested, possibleOutcomes);
        }
        return null;
    }

    private String[] extractPossibleOutcomes(JsAuthenticationContext context, Object possibleOutcomesObj) {
        String[] possibleOutcomes;
        if (possibleOutcomesObj instanceof String[]) {
            possibleOutcomes = (String[])possibleOutcomesObj;
        } else if (possibleOutcomesObj instanceof ScriptObjectMirror) {
            if (((ScriptObjectMirror)possibleOutcomesObj).isArray()) {
                possibleOutcomes = (String[])((ScriptObjectMirror)possibleOutcomesObj).to(String[].class);
            } else {
                log.error((Object)("Invalid argument provided for possible outcomes for selectAcrFrom function in service provider: " + ((AuthenticationContext)context.getWrapped()).getServiceProviderName() + ". Expected array of strings."));
                possibleOutcomes = new String[]{};
            }
        } else {
            log.error((Object)("Invalid argument provided for possible outcomes for selectAcrFrom function in service provider: " + ((AuthenticationContext)context.getWrapped()).getServiceProviderName() + ". Expected array of strings."));
            possibleOutcomes = new String[]{};
        }
        return possibleOutcomes;
    }

    private String selectBestOutcome(List<String> acrListRequested, String[] possibleOutcomes) {
        TreeMap acrRequestedWithPriority = new TreeMap(Collections.reverseOrder((o1, o2) -> o2.compareTo((Integer)o1)));
        String acrSelected = null;
        block0: for (String acrChecked : acrListRequested) {
            for (int x = 0; x < possibleOutcomes.length; ++x) {
                String outcomeToTest = possibleOutcomes[x];
                if (!outcomeToTest.equals(acrChecked)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Reassigning Best Match for the outcome : " + outcomeToTest + " with priority : " + x + 1));
                }
                acrRequestedWithPriority.put(x + 1, acrChecked);
                continue block0;
            }
        }
        if (!acrRequestedWithPriority.entrySet().isEmpty()) {
            acrSelected = (String)acrRequestedWithPriority.entrySet().iterator().next().getValue();
        }
        return acrSelected;
    }
}

