/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.handler.sequence.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;
import org.wso2.carbon.identity.application.authentication.framework.AsyncCaller;
import org.wso2.carbon.identity.application.authentication.framework.AsyncProcess;
import org.wso2.carbon.identity.application.authentication.framework.AsyncReturn;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticationFlowHandler;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticatorFlowStatus;
import org.wso2.carbon.identity.application.authentication.framework.config.ConfigurationFacade;
import org.wso2.carbon.identity.application.authentication.framework.config.model.AuthenticatorConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.AuthGraphNode;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.AuthenticationGraph;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.DynamicDecisionNode;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.EndStep;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.FailNode;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.JsGraphBuilder;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.JsGraphBuilderFactory;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.LongWaitNode;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.SerializableJsFunction;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.ShowPromptNode;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.StepConfigGraphNode;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.JsAuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.JsWritableParameters;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.exception.JsFailureException;
import org.wso2.carbon.identity.application.authentication.framework.handler.sequence.SequenceHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.sequence.impl.DefaultStepBasedSequenceHandler;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticationResult;
import org.wso2.carbon.identity.application.authentication.framework.model.LongWaitStatus;
import org.wso2.carbon.identity.application.authentication.framework.store.LongWaitStatusStoreService;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public class GraphBasedSequenceHandler
extends DefaultStepBasedSequenceHandler
implements SequenceHandler {
    private static final Log log = LogFactory.getLog(GraphBasedSequenceHandler.class);
    private static final String PROMPT_DEFAULT_ACTION = "Success";
    private static final String PROMPT_ACTION_PREFIX = "action.";
    private static final String RESPONSE_HANDLED_BY_FRAMEWORK = "hasResponseHandledByFramework";
    public static final String SKIPPED_CALLBACK_NAME = "onSkip";
    public static final String STEP_IDENTIFIER_PARAM = "step";

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws FrameworkException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Executing the Step Based Authentication...");
        }
        if (this.isBackToPreviousStep(context)) {
            this.modifyCurrentNodeAsPreviousStep(context);
        }
        SequenceConfig sequenceConfig = context.getSequenceConfig();
        String authenticationType = sequenceConfig.getApplicationConfig().getServiceProvider().getLocalAndOutBoundAuthenticationConfig().getAuthenticationType();
        AuthenticationGraph graph = sequenceConfig.getAuthenticationGraph();
        if (graph == null || !graph.isEnabled() || !"flow".equals(authenticationType) && !"default".equals(authenticationType)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authentication Graph not defined for the application. Performing Step based authentication. Service Provider :" + sequenceConfig.getApplicationId()));
            }
            DefaultStepBasedSequenceHandler.getInstance().handle(request, response, context);
            return;
        }
        if (!graph.isBuildSuccessful()) {
            throw new FrameworkException("Error while building graph from Javascript. Nested exception is: " + graph.getErrorReason());
        }
        boolean isInterrupted = false;
        while (!isInterrupted && !context.getSequenceConfig().isCompleted()) {
            AuthGraphNode currentNode = (AuthGraphNode)context.getProperty("Adaptive.Auth.Current.Graph.Node");
            if (currentNode == null) {
                isInterrupted = this.handleInitialize(request, response, context, sequenceConfig, graph);
                continue;
            }
            isInterrupted = this.handleNode(request, response, context, sequenceConfig, currentNode);
        }
    }

    private void modifyCurrentNodeAsPreviousStep(AuthenticationContext context) {
        context.removeProperty("BACK_TO_PREVIOUS_STEP");
        if (context.getProperty("Adaptive.Auth.Current.Graph.Node") != null) {
            AuthGraphNode parentNode;
            for (int i = 2; i <= context.getSequenceConfig().getStepMap().size(); ++i) {
                context.getSequenceConfig().getStepMap().remove(i);
            }
            for (parentNode = ((AuthGraphNode)context.getProperty("Adaptive.Auth.Current.Graph.Node")).getParent(); parentNode != null && !this.isIdentifierFirstStep(parentNode); parentNode = parentNode.getParent()) {
                if (!(parentNode instanceof DynamicDecisionNode)) continue;
                ((DynamicDecisionNode)parentNode).setDefaultEdge(new EndStep());
            }
            context.setProperty("Adaptive.Auth.Current.Graph.Node", parentNode);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Modified current node a parent node which can handle the Identifier First requests.");
            }
        }
    }

    private boolean isBackToPreviousStep(AuthenticationContext context) {
        return context.getProperty("BACK_TO_PREVIOUS_STEP") != null && Boolean.parseBoolean(context.getProperty("BACK_TO_PREVIOUS_STEP").toString());
    }

    private boolean handleNode(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context, SequenceConfig sequenceConfig, AuthGraphNode currentNode) throws FrameworkException {
        context.setProperty("Adaptive.Auth.Current.Graph.Node", currentNode);
        boolean isInterrupt = false;
        if (currentNode instanceof ShowPromptNode) {
            isInterrupt = this.handlePrompt(request, response, context, sequenceConfig, (ShowPromptNode)currentNode);
        } else if (currentNode instanceof LongWaitNode) {
            isInterrupt = this.handleLongWait(request, response, context, sequenceConfig, (LongWaitNode)currentNode);
        } else if (currentNode instanceof DynamicDecisionNode) {
            this.handleDecisionPoint(request, response, context, sequenceConfig, (DynamicDecisionNode)currentNode);
        } else if (currentNode instanceof StepConfigGraphNode) {
            isInterrupt = this.handleAuthenticationStep(request, response, context, sequenceConfig, (StepConfigGraphNode)currentNode);
            if (!isInterrupt) {
                this.gotoToNextNode(context, sequenceConfig, currentNode);
            }
        } else if (currentNode instanceof EndStep) {
            this.handleEndOfSequence(request, response, context, sequenceConfig);
        } else if (currentNode instanceof FailNode) {
            this.handleAuthFail(request, response, context, sequenceConfig, (FailNode)currentNode);
        }
        return isInterrupt;
    }

    private void displayLongWait(AuthenticationContext context, HttpServletRequest request, HttpServletResponse response) throws FrameworkException {
        try {
            String longWaitUrl = ConfigurationFacade.getInstance().getAuthenticationEndpointWaitURL();
            response.sendRedirect(longWaitUrl + "?" + "sessionDataKey" + "=" + context.getContextIdentifier());
            request.setAttribute("authenticatorFlowStatus", (Object)AuthenticatorFlowStatus.INCOMPLETE);
        }
        catch (IOException e) {
            throw new FrameworkException("Error while redirecting to wait.do", e);
        }
    }

    private boolean handlePrompt(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context, SequenceConfig sequenceConfig, ShowPromptNode promptNode) throws FrameworkException {
        boolean isPromptToBeDisplayed = false;
        if (context.isReturning()) {
            String action = PROMPT_DEFAULT_ACTION;
            for (String s : request.getParameterMap().keySet()) {
                if (!s.startsWith(PROMPT_ACTION_PREFIX)) continue;
                action = s.substring(PROMPT_ACTION_PREFIX.length(), s.length());
                action = StringUtils.capitalize((String)action);
                break;
            }
            action = "on" + action;
            this.executeFunction(action, promptNode, context);
            AuthGraphNode nextNode = promptNode.getDefaultEdge();
            context.setProperty("Adaptive.Auth.Current.Graph.Node", nextNode);
            context.setReturning(false);
        } else {
            if (promptNode.getHandlerMap().get("preHandler") != null) {
                Object result = this.evaluateHandler("preHandler", promptNode, context, promptNode.getParameters().get(STEP_IDENTIFIER_PARAM));
                if (Boolean.TRUE.equals(result)) {
                    this.executeFunction(SKIPPED_CALLBACK_NAME, promptNode, context);
                    AuthGraphNode nextNode = promptNode.getDefaultEdge();
                    context.setProperty("Adaptive.Auth.Current.Graph.Node", nextNode);
                } else {
                    this.displayPrompt(context, request, response, promptNode);
                    isPromptToBeDisplayed = true;
                }
                return isPromptToBeDisplayed;
            }
            this.displayPrompt(context, request, response, promptNode);
            isPromptToBeDisplayed = true;
        }
        return isPromptToBeDisplayed;
    }

    private void displayPrompt(AuthenticationContext context, HttpServletRequest request, HttpServletResponse response, ShowPromptNode promptNode) throws FrameworkException {
        try {
            String promptPage = ConfigurationFacade.getInstance().getAuthenticationEndpointPromptURL();
            String tenantDomainQueryString = null;
            if (!IdentityTenantUtil.isTenantQualifiedUrlsEnabled()) {
                tenantDomainQueryString = "tenantDomain=" + context.getTenantDomain();
                promptPage = FrameworkUtils.appendQueryParamsStringToUrl(promptPage, tenantDomainQueryString);
            }
            String redirectUrl = FrameworkUtils.appendQueryParamsStringToUrl(promptPage, "templateId=" + URLEncoder.encode(promptNode.getTemplateId(), StandardCharsets.UTF_8.name()) + "&promptId=" + context.getContextIdentifier());
            if (promptNode.getData() != null) {
                context.addEndpointParams(promptNode.getData());
            }
            response.sendRedirect(redirectUrl);
            AuthenticationResult authenticationResult = new AuthenticationResult();
            request.setAttribute("authResult", (Object)authenticationResult);
            request.setAttribute(RESPONSE_HANDLED_BY_FRAMEWORK, (Object)Boolean.TRUE);
            request.setAttribute("authenticatorFlowStatus", (Object)AuthenticatorFlowStatus.INCOMPLETE);
        }
        catch (UnsupportedEncodingException e) {
            throw new FrameworkException("Error while encoding the data to send to prompt page with session data key" + context.getContextIdentifier(), e);
        }
        catch (IOException e) {
            throw new FrameworkException("Error while redirecting the user for prompt page with session data key" + context.getContextIdentifier(), e);
        }
    }

    private void gotoToNextNode(AuthenticationContext context, SequenceConfig sequenceConfig, AuthGraphNode currentNode) {
        AuthGraphNode nextNode = null;
        if (currentNode instanceof StepConfigGraphNode) {
            nextNode = ((StepConfigGraphNode)currentNode).getNext();
        }
        if (nextNode == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No Next node found for the current graph node : " + currentNode.getName() + ", Service Provider: " + context.getServiceProviderName() + " . Ending the authentication flow."));
            }
            nextNode = new EndStep();
        }
        context.setProperty("Adaptive.Auth.Current.Graph.Node", nextNode);
    }

    private void handleEndOfSequence(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context, SequenceConfig sequenceConfig) throws FrameworkException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"There are no more steps to execute");
        }
        context.getSequenceConfig().setCompleted(true);
        context.setRequestAuthenticated(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Request is successfully authenticated");
        }
        this.handlePostAuthentication(request, response, context);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Step processing is completed");
        }
    }

    private void handleAuthFail(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context, SequenceConfig sequenceConfig, FailNode node) throws FrameworkException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Found a Fail Node in conditional authentication");
        }
        if (node.isShowErrorPage()) {
            String errorPage = node.getErrorPageUri();
            String redirectURL = null;
            if (StringUtils.isBlank((String)errorPage)) {
                errorPage = ConfigurationFacade.getInstance().getAuthenticationEndpointRetryURL();
            }
            try {
                URIBuilder uriBuilder = new URIBuilder(errorPage);
                node.getFailureData().forEach((arg_0, arg_1) -> ((URIBuilder)uriBuilder).addParameter(arg_0, arg_1));
                redirectURL = uriBuilder.toString();
                response.sendRedirect(FrameworkUtils.getRedirectURL(redirectURL, request));
            }
            catch (IOException e) {
                throw new FrameworkException("Error when redirecting user to " + errorPage, e);
            }
            catch (URISyntaxException e) {
                throw new FrameworkException("Error when redirecting user to " + errorPage + ". Error page is not a valid URL.", e);
            }
            context.setRequestAuthenticated(false);
            context.getSequenceConfig().setCompleted(true);
            request.setAttribute("authenticatorFlowStatus", (Object)AuthenticatorFlowStatus.INCOMPLETE);
            throw new JsFailureException("Error initiated from authentication script. User will be redirected to " + redirectURL);
        }
        this.setErrorPropertiesToContext(node, context);
    }

    private void setErrorPropertiesToContext(FailNode node, AuthenticationContext context) throws FrameworkException {
        Map<String, String> parameterMap = node.getFailureData();
        if (parameterMap.containsKey("errorCode")) {
            context.setProperty("AuthErrorCode", parameterMap.get("errorCode"));
        }
        if (parameterMap.containsKey("errorMessage")) {
            context.setProperty("AuthErrorMessage", parameterMap.get("errorMessage"));
        }
        if (parameterMap.containsKey("errorURI")) {
            try {
                new URL(parameterMap.get("errorURI"));
            }
            catch (MalformedURLException e) {
                throw new FrameworkException("Error when validating provided errorURI: " + parameterMap.get("errorURI"), e);
            }
            context.setProperty("AuthErrorURI", parameterMap.get("errorURI"));
        }
        context.setRequestAuthenticated(false);
        context.getSequenceConfig().setCompleted(true);
    }

    private boolean handleAuthenticationStep(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context, SequenceConfig sequenceConfig, StepConfigGraphNode stepConfigGraphNode) throws FrameworkException {
        StepConfig stepConfig = stepConfigGraphNode.getStepConfig();
        if (stepConfig == null) {
            throw new FrameworkException("StepConfig not found while handling the step. Service Provider : " + context.getServiceProviderName());
        }
        if (stepConfig.isCompleted()) {
            stepConfig.setCompleted(false);
            stepConfig.setRetrying(false);
            if (context.isRequestAuthenticated()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Step " + stepConfig.getOrder() + " is completed. Going to get the next one."));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Authentication has failed in the Step " + context.getCurrentStep()));
                }
                if (stepConfig.isMultiOption() && !context.isPassiveAuthenticate()) {
                    stepConfig.setRetrying(true);
                    context.setRequestAuthenticated(true);
                } else {
                    this.resetAuthenticationContext(context);
                }
            }
            this.resetAuthenticationContext(context);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting Step: " + stepConfig.getOrder()));
        }
        AuthenticatorFlowStatus flowStatus = (AuthenticatorFlowStatus)request.getAttribute("authenticatorFlowStatus");
        int stepNumber = context.getCurrentStep();
        if (!context.isReturning()) {
            if (stepNumber <= 0) {
                stepNumber = 1;
            } else if (flowStatus != AuthenticatorFlowStatus.FAIL_COMPLETED) {
                ++stepNumber;
            }
            context.setCurrentStep(stepNumber);
            context.getSequenceConfig().getStepMap().put(stepNumber, stepConfig);
        }
        FrameworkUtils.getStepHandler().handle(request, response, context);
        flowStatus = (AuthenticatorFlowStatus)request.getAttribute("authenticatorFlowStatus");
        if (!(flowStatus == AuthenticatorFlowStatus.SUCCESS_COMPLETED || flowStatus == AuthenticatorFlowStatus.INCOMPLETE || AuthenticatorFlowStatus.FAIL_COMPLETED.equals(flowStatus) && context.isRetrying())) {
            stepConfig.setSubjectAttributeStep(false);
            stepConfig.setSubjectIdentifierStep(false);
        }
        if (flowStatus == AuthenticatorFlowStatus.FAIL_COMPLETED && !(stepConfigGraphNode.getNext() instanceof DynamicDecisionNode)) {
            if (context.isRetrying()) {
                StepConfigGraphNode newNextNode = new StepConfigGraphNode(stepConfigGraphNode.getStepConfig());
                newNextNode.setNext(stepConfigGraphNode.getNext());
                AuthGraphNode parentNode = stepConfigGraphNode.getParent();
                if (parentNode == null) {
                    parentNode = sequenceConfig.getAuthenticationGraph().getStartNode();
                }
                if (parentNode instanceof DynamicDecisionNode) {
                    ((DynamicDecisionNode)parentNode).setDefaultEdge(newNextNode);
                } else if (parentNode instanceof StepConfigGraphNode) {
                    ((StepConfigGraphNode)parentNode).setNext(newNextNode);
                }
                stepConfigGraphNode.setNext(newNextNode);
            } else {
                stepConfigGraphNode.setNext(new FailNode());
            }
        }
        if (!stepConfig.isCompleted()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Step is not complete yet. Redirecting to outside.");
            }
            return true;
        }
        if (context.isPassiveAuthenticate() && !context.isRequestAuthenticated()) {
            return true;
        }
        context.setReturning(false);
        return false;
    }

    private boolean handleLongWait(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context, SequenceConfig sequenceConfig, LongWaitNode longWaitNode) throws FrameworkException {
        boolean isWaiting;
        LongWaitStatusStoreService longWaitStatusStoreService = FrameworkServiceDataHolder.getInstance().getLongWaitStatusStoreService();
        LongWaitStatus longWaitStatus = longWaitStatusStoreService.getWait(context.getContextIdentifier());
        if (longWaitStatus == null || longWaitStatus.getStatus() == LongWaitStatus.Status.UNKNOWN) {
            longWaitStatus = new LongWaitStatus();
            int tenantId = IdentityTenantUtil.getTenantId((String)context.getTenantDomain());
            longWaitStatusStoreService.addWait(tenantId, context.getContextIdentifier(), longWaitStatus);
            isWaiting = this.callExternalSystem(request, response, context, sequenceConfig, longWaitNode);
            if (FrameworkUtils.promptOnLongWait() && isWaiting) {
                this.displayLongWait(context, request, response);
            }
        } else {
            AuthGraphNode nextNode;
            context.setReturning(false);
            isWaiting = LongWaitStatus.Status.COMPLETED != longWaitStatus.getStatus();
            longWaitStatusStoreService.removeWait(context.getContextIdentifier());
            String outcomeName = (String)context.getProperty("callAndWaitReturnStatus");
            Map data = (Map)context.getProperty("callAndWaitReturnData");
            context.removeProperty("callAndWaitReturnStatus");
            context.removeProperty("callAndWaitReturnData");
            if (outcomeName != null) {
                this.executeFunction(outcomeName, longWaitNode, context, data);
                nextNode = longWaitNode.getDefaultEdge();
                if (nextNode == null) {
                    log.error((Object)("Authentication script does not have applicable event handler for outcome " + outcomeName + " from the long wait process : " + context.getContextIdentifier() + ". So ending the authentication flow. Add the correspoding event handler to the script"));
                    nextNode = new FailNode();
                }
            } else {
                log.error((Object)("The outcome from the long wait process " + context.getContextIdentifier() + " is null. Because asyncReturn.accept() has not been used properly in the async process flow of the custom function. So ending the authentication flow. Check the flow in the async process flow of the custom function and add asyncReturn.accept() with the corresponding outcome."));
                nextNode = new FailNode();
            }
            context.setProperty("Adaptive.Auth.Current.Graph.Node", nextNode);
        }
        return isWaiting;
    }

    private void resumeLongWait(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws FrameworkException {
        this.handle(request, response, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean callExternalSystem(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context, SequenceConfig sequenceConfig, LongWaitNode longWaitNode) throws FrameworkException {
        AsyncProcess asyncProcess = longWaitNode.getAsyncProcess();
        if (asyncProcess == null) {
            return false;
        }
        AsyncCaller caller = asyncProcess.getAsyncCaller();
        AsyncReturn asyncReturn = GraphBasedSequenceHandler.rethrowTriConsumer((authenticationContext, data, result) -> {
            authenticationContext.setProperty("callAndWaitReturnStatus", result);
            authenticationContext.setProperty("callAndWaitReturnData", data);
            if (!FrameworkUtils.promptOnLongWait()) {
                AuthenticationContext authenticationContext2 = context;
                synchronized (authenticationContext2) {
                    context.notify();
                }
            }
        });
        if (caller != null) {
            FrameworkServiceDataHolder.getInstance().getAsyncSequenceExecutor().exec(caller, asyncReturn, context);
            if (!FrameworkUtils.promptOnLongWait()) {
                int waitTimeout = this.getLongWaitTimeout();
                AuthenticationContext authenticationContext2 = context;
                synchronized (authenticationContext2) {
                    try {
                        context.wait(waitTimeout);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.error((Object)("Thread interrupted while waiting for the external call to complete for session data key: " + context.getContextIdentifier() + ". "), (Throwable)e);
                    }
                }
                this.resumeLongWait(request, response, context);
            }
            return true;
        }
        return false;
    }

    private int getLongWaitTimeout() {
        String waitTimeoutPropValue = IdentityUtil.getProperty((String)"AdaptiveAuth.LongWaitTimeout");
        int waitTimeout = 10000;
        try {
            if (waitTimeoutPropValue != null) {
                waitTimeout = Integer.parseInt(waitTimeoutPropValue);
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Error while reading the wait timeout. Default value of 10 seconds will be used. ", (Throwable)e);
        }
        return waitTimeout;
    }

    private void handleDecisionPoint(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context, SequenceConfig sequenceConfig, DynamicDecisionNode dynamicDecisionNode) throws FrameworkException {
        if (dynamicDecisionNode == null) {
            log.error((Object)"Dynamic decision node is null");
            return;
        }
        AuthenticatorFlowStatus flowStatus = (AuthenticatorFlowStatus)request.getAttribute("authenticatorFlowStatus");
        if (flowStatus != null) {
            switch (flowStatus) {
                case SUCCESS_COMPLETED: {
                    this.executeFunction("onSuccess", dynamicDecisionNode, context);
                    break;
                }
                case FAIL_COMPLETED: {
                    if (dynamicDecisionNode.getFunctionMap().get("onFail") != null) {
                        this.executeFunction("onFail", dynamicDecisionNode, context);
                    } else if (context.isRetrying()) {
                        AuthGraphNode nextNode = dynamicDecisionNode.getParent();
                        context.setProperty("Adaptive.Auth.Current.Graph.Node", nextNode);
                        return;
                    }
                    if (!(dynamicDecisionNode.getDefaultEdge() instanceof EndStep)) break;
                    dynamicDecisionNode.setDefaultEdge(new FailNode());
                    break;
                }
                case FALLBACK: {
                    this.executeFunction("onFallback", dynamicDecisionNode, context);
                    break;
                }
                case USER_ABORT: {
                    this.executeFunction("onUserAbort", dynamicDecisionNode, context);
                }
            }
        }
        AuthGraphNode nextNode = dynamicDecisionNode.getDefaultEdge();
        context.setProperty("Adaptive.Auth.Current.Graph.Node", nextNode);
    }

    private void executeFunction(String outcomeName, DynamicDecisionNode dynamicDecisionNode, AuthenticationContext context) {
        JsGraphBuilder graphBuilder;
        SerializableJsFunction fn = dynamicDecisionNode.getFunctionMap().get(outcomeName);
        FrameworkServiceDataHolder dataHolder = FrameworkServiceDataHolder.getInstance();
        JsGraphBuilderFactory jsGraphBuilderFactory = dataHolder.getJsGraphBuilderFactory();
        JsGraphBuilder jsGraphBuilder = graphBuilder = jsGraphBuilderFactory.createBuilder(context, context.getSequenceConfig().getAuthenticationGraph().getStepMap(), dynamicDecisionNode);
        jsGraphBuilder.getClass();
        JsGraphBuilder.JsBasedEvaluator jsBasedEvaluator = jsGraphBuilder.new JsGraphBuilder.JsBasedEvaluator(fn);
        jsBasedEvaluator.evaluate(context, jsConsumer -> jsConsumer.call(null, new Object[]{new JsAuthenticationContext(context)}));
        if (dynamicDecisionNode.getDefaultEdge() == null) {
            dynamicDecisionNode.setDefaultEdge(new EndStep());
        }
    }

    private void executeFunction(String outcomeName, DynamicDecisionNode dynamicDecisionNode, AuthenticationContext context, Map<String, Object> data) {
        JsGraphBuilder jsGraphBuilder;
        SerializableJsFunction fn = dynamicDecisionNode.getFunctionMap().get(outcomeName);
        FrameworkServiceDataHolder dataHolder = FrameworkServiceDataHolder.getInstance();
        JsGraphBuilderFactory jsGraphBuilderFactory = dataHolder.getJsGraphBuilderFactory();
        JsGraphBuilder jsGraphBuilder2 = jsGraphBuilder = jsGraphBuilderFactory.createBuilder(context, context.getSequenceConfig().getAuthenticationGraph().getStepMap(), dynamicDecisionNode);
        jsGraphBuilder2.getClass();
        JsGraphBuilder.JsBasedEvaluator jsBasedEvaluator = jsGraphBuilder2.new JsGraphBuilder.JsBasedEvaluator(fn);
        jsBasedEvaluator.evaluate(context, jsConsumer -> jsConsumer.call(null, new Object[]{new JsAuthenticationContext(context), new JsWritableParameters(data)}));
        if (dynamicDecisionNode.getDefaultEdge() == null) {
            dynamicDecisionNode.setDefaultEdge(new EndStep());
        }
    }

    private Object evaluateHandler(String outcomeName, ShowPromptNode dynamicDecisionNode, AuthenticationContext context, Object stepId) {
        JsGraphBuilder graphBuilder;
        SerializableJsFunction fn = dynamicDecisionNode.getHandlerMap().get(outcomeName);
        FrameworkServiceDataHolder dataHolder = FrameworkServiceDataHolder.getInstance();
        JsGraphBuilderFactory jsGraphBuilderFactory = dataHolder.getJsGraphBuilderFactory();
        JsGraphBuilder jsGraphBuilder = graphBuilder = jsGraphBuilderFactory.createBuilder(context, context.getSequenceConfig().getAuthenticationGraph().getStepMap(), dynamicDecisionNode);
        jsGraphBuilder.getClass();
        JsGraphBuilder.JsBasedEvaluator jsBasedEvaluator = jsGraphBuilder.new JsGraphBuilder.JsBasedEvaluator(fn);
        return jsBasedEvaluator.evaluate(context, jsFunction -> jsFunction.call(null, new Object[]{stepId, new JsAuthenticationContext(context)}));
    }

    private boolean handleInitialize(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context, SequenceConfig sequenceConfig, AuthenticationGraph graph) throws FrameworkException {
        AuthGraphNode startNode = graph.getStartNode();
        if (startNode == null) {
            throw new FrameworkException("Start node is not set for authentication graph:" + graph.getName());
        }
        context.setCurrentStep(0);
        return this.handleNode(request, response, context, sequenceConfig, startNode);
    }

    public static <T, U, V, E extends Exception> AsyncReturn rethrowTriConsumer(AsyncReturn triConsumer) {
        return (t, u, v) -> {
            try {
                triConsumer.accept(t, u, v);
            }
            catch (Exception exception) {
                GraphBasedSequenceHandler.throwAsUnchecked(exception);
            }
        };
    }

    private static <E extends Throwable> void throwAsUnchecked(Exception exception) throws E {
        throw exception;
    }

    private boolean isIdentifierFirstStep(AuthGraphNode authGraphNode) {
        if (authGraphNode instanceof DynamicDecisionNode) {
            return false;
        }
        if (authGraphNode instanceof StepConfigGraphNode) {
            StepConfig stepConfig = ((StepConfigGraphNode)authGraphNode).getStepConfig();
            for (AuthenticatorConfig authenticatorConfig : stepConfig.getAuthenticatorList()) {
                if (!(authenticatorConfig.getApplicationAuthenticator() instanceof AuthenticationFlowHandler)) continue;
                return true;
            }
        }
        return false;
    }
}

