/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.handler.sequence.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.ApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticationFlowHandler;
import org.wso2.carbon.identity.application.authentication.framework.FederatedApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.config.ConfigurationFacade;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ApplicationConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.AuthenticatorConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ExternalIdPConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.exception.MisconfigurationException;
import org.wso2.carbon.identity.application.authentication.framework.handler.sequence.StepBasedSequenceHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.sequence.impl.DefaultSequenceHandlerUtils;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.common.model.ThreadLocalProvisioningServiceProvider;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;

public class DefaultStepBasedSequenceHandler
implements StepBasedSequenceHandler {
    private static final Log log = LogFactory.getLog(DefaultStepBasedSequenceHandler.class);
    private static volatile DefaultStepBasedSequenceHandler instance;
    private static final String SEND_ONLY_LOCALLY_MAPPED_ROLES_OF_IDP = "FederatedRoleManagement.ReturnOnlyMappedLocalRoles";
    private static boolean returnOnlyMappedLocalRoles;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultStepBasedSequenceHandler getInstance() {
        if (instance != null) return instance;
        Class<DefaultStepBasedSequenceHandler> clazz = DefaultStepBasedSequenceHandler.class;
        synchronized (DefaultStepBasedSequenceHandler.class) {
            if (instance != null) return instance;
            instance = new DefaultStepBasedSequenceHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws FrameworkException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Executing the Step Based Authentication...");
        }
        while (!context.getSequenceConfig().isCompleted()) {
            StepConfig stepConfig;
            int currentStep = context.getCurrentStep();
            if (currentStep == 0) {
                context.setCurrentStep(++currentStep);
            }
            if ((stepConfig = context.getSequenceConfig().getStepMap().get(currentStep)) != null && stepConfig.isCompleted()) {
                stepConfig.setCompleted(false);
                stepConfig.setRetrying(false);
                if (context.isRequestAuthenticated()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Step " + stepConfig.getOrder() + " is completed. Going to get the next one."));
                    }
                    currentStep = context.getCurrentStep() + 1;
                    context.setCurrentStep(currentStep);
                    stepConfig = context.getSequenceConfig().getStepMap().get(currentStep);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Authentication has failed in the Step " + context.getCurrentStep()));
                    }
                    if (stepConfig.isMultiOption() && !context.isPassiveAuthenticate()) {
                        stepConfig.setRetrying(true);
                        context.setRequestAuthenticated(true);
                    } else {
                        context.getSequenceConfig().setCompleted(true);
                        this.resetAuthenticationContext(context);
                        continue;
                    }
                }
                this.resetAuthenticationContext(context);
            }
            if (stepConfig == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"There are no more steps to execute.");
                }
                if (context.isRequestAuthenticated()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Request is successfully authenticated.");
                    }
                    context.getSequenceConfig().setCompleted(true);
                    this.handlePostAuthentication(request, response, context);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Step processing is completed.");
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Starting Step: " + stepConfig.getOrder()));
            }
            FrameworkUtils.getStepHandler().handle(request, response, context);
            if (!stepConfig.isCompleted()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Step is not complete yet. Redirecting to outside.");
                }
                return;
            }
            context.setReturning(false);
        }
    }

    protected void handlePostAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws FrameworkException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Handling Post Authentication tasks");
        }
        SequenceConfig sequenceConfig = context.getSequenceConfig();
        StringBuilder jsonBuilder = new StringBuilder();
        boolean subjectFoundInStep = false;
        boolean subjectAttributesFoundInStep = false;
        int stepCount = 1;
        Map<Object, Object> mappedAttrs = new HashMap();
        Map<ClaimMapping, String> authenticatedUserAttributes = new HashMap<ClaimMapping, String>();
        boolean isAuthenticatorExecuted = false;
        for (Map.Entry<Integer, StepConfig> entry : sequenceConfig.getStepMap().entrySet()) {
            StepConfig stepConfig = entry.getValue();
            AuthenticatorConfig authenticatorConfig = stepConfig.getAuthenticatedAutenticator();
            if (authenticatorConfig == null) continue;
            ApplicationAuthenticator authenticator = authenticatorConfig.getApplicationAuthenticator();
            if (!(authenticator instanceof AuthenticationFlowHandler)) {
                isAuthenticatorExecuted = true;
            }
            if (stepCount == 1) {
                jsonBuilder.append("\"idps\":");
                jsonBuilder.append("[");
            }
            jsonBuilder.append("{");
            jsonBuilder.append("\"idp\":\"").append(stepConfig.getAuthenticatedIdP()).append("\",");
            jsonBuilder.append("\"authenticator\":\"").append(authenticator.getName()).append("\"");
            if (stepCount != sequenceConfig.getStepMap().size()) {
                jsonBuilder.append("},");
            } else {
                jsonBuilder.append("}");
                jsonBuilder.append("]");
                sequenceConfig.setAuthenticatedIdPs(IdentityApplicationManagementUtil.getSignedJWT((String)jsonBuilder.toString(), (ServiceProvider)sequenceConfig.getApplicationConfig().getServiceProvider()));
                stepConfig.setSubjectIdentifierStep(!subjectFoundInStep);
                stepConfig.setSubjectAttributeStep(!subjectAttributesFoundInStep);
            }
            ++stepCount;
            if (authenticator instanceof FederatedApplicationAuthenticator) {
                ExternalIdPConfig externalIdPConfig = null;
                try {
                    externalIdPConfig = ConfigurationFacade.getInstance().getIdPConfigByName(stepConfig.getAuthenticatedIdP(), context.getTenantDomain());
                }
                catch (IdentityProviderManagementException e) {
                    log.error((Object)"Exception while getting IdP by name", (Throwable)e);
                }
                context.setExternalIdP(externalIdPConfig);
                String originalExternalIdpSubjectValueForThisStep = stepConfig.getAuthenticatedUser().getAuthenticatedSubjectIdentifier();
                if (externalIdPConfig == null) {
                    String errorMsg = "An External IdP cannot be null for a FederatedApplicationAuthenticator";
                    log.error((Object)errorMsg);
                    throw new FrameworkException(errorMsg);
                }
                Map localClaimValues = null;
                Map idpClaimValues = null;
                Map<ClaimMapping, String> extAttrs = stepConfig.getAuthenticatedUser().getUserAttributes();
                Map<String, String> extAttibutesValueMap = FrameworkUtils.getClaimMappings(extAttrs, false);
                if (stepConfig.isSubjectAttributeStep()) {
                    subjectAttributesFoundInStep = true;
                    String idpRoleClaimUri = this.getIdpRoleClaimUri(stepConfig, context);
                    List<String> identityProviderMappedUserRolesUnmappedInclusive = this.getIdentityProvideMappedUserRoles(externalIdPConfig, extAttibutesValueMap, idpRoleClaimUri, returnOnlyMappedLocalRoles);
                    String serviceProviderMappedUserRoles = this.getServiceProviderMappedUserRoles(sequenceConfig, identityProviderMappedUserRolesUnmappedInclusive);
                    if (StringUtils.isNotBlank((String)idpRoleClaimUri) && StringUtils.isNotBlank((String)serviceProviderMappedUserRoles)) {
                        extAttibutesValueMap.put(idpRoleClaimUri, serviceProviderMappedUserRoles);
                    }
                    if (mappedAttrs == null || mappedAttrs.isEmpty()) {
                        mappedAttrs = this.handleClaimMappings(stepConfig, context, extAttibutesValueMap, true);
                        localClaimValues = (Map)context.getProperty("UNFILTERED_LOCAL_CLAIM_VALUES");
                        idpClaimValues = (Map)context.getProperty("UNFILTERED_IDP_CLAIM_VALUES");
                    }
                }
                if (stepConfig.isSubjectIdentifierStep()) {
                    subjectFoundInStep = true;
                    sequenceConfig.setAuthenticatedUser(new AuthenticatedUser(stepConfig.getAuthenticatedUser()));
                }
                if (!stepConfig.isSubjectAttributeStep() || sequenceConfig.getApplicationConfig().isMappedSubjectIDSelected()) continue;
                if (context.getSequenceConfig().getApplicationConfig().getRequestedClaimMappings() == null || context.getSequenceConfig().getApplicationConfig().getRequestedClaimMappings().isEmpty()) {
                    if (MapUtils.isNotEmpty(localClaimValues)) {
                        mappedAttrs = localClaimValues;
                    } else if (MapUtils.isNotEmpty(idpClaimValues)) {
                        mappedAttrs = idpClaimValues;
                    }
                }
                authenticatedUserAttributes = FrameworkUtils.buildClaimMappings(mappedAttrs);
                continue;
            }
            if (stepConfig.isSubjectIdentifierStep()) {
                subjectFoundInStep = true;
                sequenceConfig.setAuthenticatedUser(new AuthenticatedUser(stepConfig.getAuthenticatedUser()));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Authenticated User: " + sequenceConfig.getAuthenticatedUser().getUserName()));
                    log.debug((Object)("Authenticated User Tenant Domain: " + sequenceConfig.getAuthenticatedUser().getTenantDomain()));
                }
            }
            if (!stepConfig.isSubjectAttributeStep()) continue;
            subjectAttributesFoundInStep = true;
            mappedAttrs = this.handleClaimMappings(stepConfig, context, null, false);
            this.handleRoleMapping(context, sequenceConfig, mappedAttrs);
            authenticatedUserAttributes = FrameworkUtils.buildClaimMappings(mappedAttrs);
        }
        if (!isAuthenticatorExecuted) {
            String errorMsg = String.format("No authenticator have been executed in the authentication flow of application: %s in tenant-domain: %s", sequenceConfig.getApplicationConfig().getApplicationName(), context.getTenantDomain());
            log.error((Object)errorMsg);
            throw new MisconfigurationException(errorMsg);
        }
        if (!authenticatedUserAttributes.isEmpty() && sequenceConfig.getAuthenticatedUser() != null) {
            sequenceConfig.getAuthenticatedUser().setUserAttributes(authenticatedUserAttributes);
        }
    }

    protected String getServiceProviderMappedUserRoles(SequenceConfig sequenceConfig, List<String> locallyMappedUserRoles) throws FrameworkException {
        return DefaultSequenceHandlerUtils.getServiceProviderMappedUserRoles(sequenceConfig, locallyMappedUserRoles);
    }

    private void handleRoleMapping(AuthenticationContext context, SequenceConfig sequenceConfig, Map<String, String> mappedAttrs) throws FrameworkException {
        String spRoleUri = this.getSpRoleClaimUri(sequenceConfig.getApplicationConfig());
        Object[] roles = DefaultSequenceHandlerUtils.getRolesFromSPMappedClaims(context, sequenceConfig, mappedAttrs, spRoleUri);
        if (!ArrayUtils.isEmpty((Object[])roles)) {
            mappedAttrs.put(spRoleUri, this.getServiceProviderMappedUserRoles(sequenceConfig, Arrays.asList(roles)));
        }
    }

    protected String getSpRoleClaimUri(ApplicationConfig appConfig) throws FrameworkException {
        return DefaultSequenceHandlerUtils.getSpRoleClaimUri(appConfig);
    }

    protected String getIdpRoleClaimUri(ExternalIdPConfig externalIdPConfig) throws FrameworkException {
        return FrameworkUtils.getIdpRoleClaimUri(externalIdPConfig);
    }

    protected String getIdpRoleClaimUri(StepConfig stepConfig, AuthenticationContext context) throws FrameworkException {
        String idpRoleClaimUri = this.getIdpRoleClaimUri(context.getExternalIdP());
        return FrameworkUtils.getMappedIdpRoleClaimUri(idpRoleClaimUri, stepConfig, context);
    }

    protected List<String> getIdentityProvideMappedUserRoles(ExternalIdPConfig externalIdPConfig, Map<String, String> extAttributesValueMap, String idpRoleClaimUri, Boolean excludeUnmapped) throws FrameworkException {
        return FrameworkUtils.getIdentityProvideMappedUserRoles(externalIdPConfig, extAttributesValueMap, idpRoleClaimUri, excludeUnmapped);
    }

    protected Map<String, String> handleClaimMappings(StepConfig stepConfig, AuthenticationContext context, Map<String, String> extAttrs, boolean isFederatedClaims) throws FrameworkException {
        try {
            Map<String, String> mappedAttrs = FrameworkUtils.getClaimHandler().handleClaimMappings(stepConfig, context, extAttrs, isFederatedClaims);
            return mappedAttrs;
        }
        catch (FrameworkException e) {
            log.error((Object)"Claim handling failed!", (Throwable)((Object)e));
            return Collections.emptyMap();
        }
    }

    @Override
    public void callJitProvisioning(String subjectIdentifier, AuthenticationContext context, List<String> mappedRoles, Map<String, String> extAttributesValueMap) throws FrameworkException {
        this.handleJitProvisioning(subjectIdentifier, context, mappedRoles, extAttributesValueMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleJitProvisioning(String subjectIdentifier, AuthenticationContext context, List<String> mappedRoles, Map<String, String> extAttributesValueMap) throws FrameworkException {
        try {
            String userStoreDomain = null;
            String provisioningClaimUri = context.getExternalIdP().getProvisioningUserStoreClaimURI();
            String provisioningUserStoreId = context.getExternalIdP().getProvisioningUserStoreId();
            if (provisioningUserStoreId != null) {
                userStoreDomain = provisioningUserStoreId;
            } else if (provisioningClaimUri != null) {
                userStoreDomain = extAttributesValueMap.get(provisioningClaimUri);
            }
            ThreadLocalProvisioningServiceProvider serviceProvider = new ThreadLocalProvisioningServiceProvider();
            serviceProvider.setServiceProviderName(context.getSequenceConfig().getApplicationConfig().getApplicationName());
            serviceProvider.setJustInTimeProvisioning(true);
            serviceProvider.setClaimDialect("http://wso2.org/claims");
            serviceProvider.setTenantDomain(context.getTenantDomain());
            IdentityApplicationManagementUtil.setThreadLocalProvisioningServiceProvider((ThreadLocalProvisioningServiceProvider)serviceProvider);
            FrameworkUtils.getProvisioningHandler().handle(mappedRoles, subjectIdentifier, extAttributesValueMap, userStoreDomain, context.getTenantDomain());
        }
        catch (FrameworkException e) {
            log.error((Object)"User provisioning failed!", (Throwable)((Object)e));
        }
        finally {
            IdentityApplicationManagementUtil.resetThreadLocalProvisioningServiceProvider();
        }
    }

    protected void resetAuthenticationContext(AuthenticationContext context) throws FrameworkException {
        context.setSubject(null);
        context.setStateInfo(null);
        context.setExternalIdP(null);
        context.setAuthenticatorProperties(new HashMap<String, String>());
        context.setRetryCount(0);
        context.setRetrying(false);
        context.setCurrentAuthenticator(null);
    }

    protected String getLocalClaimUriMappedForIdPRoleClaim(ExternalIdPConfig externalIdPConfig) throws FrameworkException {
        return FrameworkUtils.getLocalClaimUriMappedForIdPRoleClaim(externalIdPConfig);
    }

    static {
        returnOnlyMappedLocalRoles = false;
        if (IdentityUtil.getProperty((String)SEND_ONLY_LOCALLY_MAPPED_ROLES_OF_IDP) != null) {
            returnOnlyMappedLocalRoles = Boolean.parseBoolean(IdentityUtil.getProperty((String)SEND_ONLY_LOCALLY_MAPPED_ROLES_OF_IDP));
        }
    }
}

