/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.handler.sequence.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ApplicationConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.model.ClaimConfig;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataHandler;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class DefaultSequenceHandlerUtils {
    private static Log log = LogFactory.getLog(DefaultSequenceHandlerUtils.class);
    private static final String SEND_ONLY_SP_MAPPED_ROLES = "SPRoleManagement.ReturnOnlyMappedLocalRoles";

    private DefaultSequenceHandlerUtils() {
    }

    public static String getServiceProviderMappedUserRoles(SequenceConfig sequenceConfig, List<String> locallyMappedUserRoles) {
        if (log.isDebugEnabled()) {
            AuthenticatedUser authenticatedUser = sequenceConfig.getAuthenticatedUser();
            String serviceProvider = sequenceConfig.getApplicationConfig().getApplicationName();
            log.debug((Object)("Getting Service Provider mapped roles of application: " + serviceProvider + " of user: " + (Object)((Object)authenticatedUser)));
        }
        boolean returnOnlyMappedLocalRoles = Boolean.parseBoolean(IdentityUtil.getProperty((String)SEND_ONLY_SP_MAPPED_ROLES));
        String spMappedRoles = null;
        if (CollectionUtils.isNotEmpty(locallyMappedUserRoles)) {
            List<String> domainRemovedRoles;
            Map<String, String> localToSpRoleMapping = sequenceConfig.getApplicationConfig().getRoleMappings();
            List<Object> spMappedRoleList = new ArrayList();
            ArrayList<String> domainRemovedRoleList = new ArrayList();
            if (localToSpRoleMapping != null && !localToSpRoleMapping.isEmpty()) {
                for (String locallyMappedRole : locallyMappedUserRoles) {
                    if (localToSpRoleMapping.containsKey(locallyMappedRole)) {
                        String spMappedRole = localToSpRoleMapping.get(locallyMappedRole);
                        spMappedRoleList.add(spMappedRole);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Mapping local role: " + locallyMappedRole + " to service provider role: " + spMappedRole));
                        continue;
                    }
                    if (returnOnlyMappedLocalRoles) continue;
                    if (DefaultSequenceHandlerUtils.isRemoveUserDomainInRole(sequenceConfig)) {
                        domainRemovedRoleList.add(locallyMappedRole);
                        continue;
                    }
                    spMappedRoleList.add(locallyMappedRole);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No local roles to map to Service Provider role mappings. Sending back all local roles as service provider mapped roles.");
                }
                if (DefaultSequenceHandlerUtils.isRemoveUserDomainInRole(sequenceConfig)) {
                    domainRemovedRoleList = locallyMappedUserRoles;
                } else {
                    spMappedRoleList = locallyMappedUserRoles;
                }
            }
            if (DefaultSequenceHandlerUtils.isRemoveUserDomainInRole(sequenceConfig) && !(domainRemovedRoles = DefaultSequenceHandlerUtils.removeDomainFromNamesExcludeHybrid(domainRemovedRoleList)).isEmpty()) {
                spMappedRoleList.addAll(domainRemovedRoles);
            }
            spMappedRoles = StringUtils.join((Object[])spMappedRoleList.toArray(), (String)FrameworkUtils.getMultiAttributeSeparator());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Service Provider Mapped Roles: " + spMappedRoles));
        }
        return spMappedRoles;
    }

    private static List<String> removeDomainFromNamesExcludeHybrid(List<String> names) {
        ArrayList<String> nameList = new ArrayList<String>();
        for (String name : names) {
            String userStoreDomain = IdentityUtil.extractDomainFromName((String)name);
            if ("Internal".equalsIgnoreCase(userStoreDomain) || "Application".equalsIgnoreCase(userStoreDomain) || "Workflow".equalsIgnoreCase(userStoreDomain)) {
                nameList.add(name);
                continue;
            }
            nameList.add(UserCoreUtil.removeDomainFromName((String)name));
        }
        return nameList;
    }

    private static boolean isRemoveUserDomainInRole(SequenceConfig sequenceConfig) {
        return !sequenceConfig.getApplicationConfig().getServiceProvider().getLocalAndOutBoundAuthenticationConfig().isUseUserstoreDomainInRoles();
    }

    public static String[] getRolesFromSPMappedClaims(AuthenticationContext context, SequenceConfig sequenceConfig, Map<String, String> mappedAttrs, String spRoleUri) throws FrameworkException {
        String spStandardDialect = DefaultSequenceHandlerUtils.getSPStandardDialect(context);
        String roleAttr = null;
        if (spStandardDialect != null && DefaultSequenceHandlerUtils.isLocalClaimDialect(context)) {
            spRoleUri = DefaultSequenceHandlerUtils.getStandardRoleClaimURI(spStandardDialect, context.getTenantDomain());
            roleAttr = mappedAttrs.get(spRoleUri);
        } else if (spStandardDialect != null && !DefaultSequenceHandlerUtils.isLocalClaimDialect(context)) {
            String localClaim = DefaultSequenceHandlerUtils.getSPMappedLocalRoleClaimURI(sequenceConfig.getApplicationConfig());
            spRoleUri = DefaultSequenceHandlerUtils.getStandardClaimURIFromLocal(spStandardDialect, context.getTenantDomain(), localClaim);
            roleAttr = mappedAttrs.get(spRoleUri);
        } else if (spStandardDialect == null && DefaultSequenceHandlerUtils.isLocalClaimDialect(context)) {
            roleAttr = mappedAttrs.get(spRoleUri);
        } else if (spStandardDialect == null && !DefaultSequenceHandlerUtils.isLocalClaimDialect(context)) {
            roleAttr = mappedAttrs.get(spRoleUri);
        }
        if (StringUtils.isNotBlank(roleAttr)) {
            return roleAttr.split(Pattern.quote(FrameworkUtils.getMultiAttributeSeparator()));
        }
        return null;
    }

    private static String getSPStandardDialect(AuthenticationContext context) {
        ApplicationConfig appConfig = context.getSequenceConfig().getApplicationConfig();
        String spStandardDialect = context.getProperties().containsKey("SP_STANDARD_DIALECT") ? (String)context.getProperty("SP_STANDARD_DIALECT") : FrameworkUtils.getStandardDialect(context.getRequestType(), appConfig);
        return spStandardDialect;
    }

    private static boolean isLocalClaimDialect(AuthenticationContext context) {
        ApplicationConfig appConfig = context.getSequenceConfig().getApplicationConfig();
        ClaimConfig claimConfig = appConfig.getServiceProvider().getClaimConfig();
        return claimConfig.isLocalClaimDialect();
    }

    private static String getStandardRoleClaimURI(String standardDialect, String tenantDomain) throws FrameworkException {
        String roleClaim = DefaultSequenceHandlerUtils.getStandardClaimURIFromLocal(standardDialect, tenantDomain, "http://wso2.org/claims/role");
        if (StringUtils.isBlank((String)roleClaim)) {
            return "http://wso2.org/claims/role";
        }
        return roleClaim;
    }

    private static String getStandardClaimURIFromLocal(String standardDialect, String tenantDomain, String claimURI) throws FrameworkException {
        try {
            Map claimMapping = ClaimMetadataHandler.getInstance().getMappingsMapFromOtherDialectToCarbon(standardDialect, null, tenantDomain, true);
            if (claimMapping.containsKey(claimURI)) {
                return (String)claimMapping.get(claimURI);
            }
        }
        catch (ClaimMetadataException e) {
            throw new FrameworkException("Error while loading mappings.", e);
        }
        return null;
    }

    private static String getSPMappedLocalRoleClaimURI(ApplicationConfig appConfig) {
        Map<String, String> spToLocalClaimMapping;
        String spRoleClaimUri = appConfig.getRoleClaim();
        if (StringUtils.isNotBlank((String)spRoleClaimUri) && MapUtils.isNotEmpty(spToLocalClaimMapping = appConfig.getClaimMappings())) {
            for (Map.Entry<String, String> entry : spToLocalClaimMapping.entrySet()) {
                if (!spRoleClaimUri.equals(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return "http://wso2.org/claims/role";
    }

    public static String getSpRoleClaimUri(ApplicationConfig appConfig) {
        Map<String, String> spToLocalClaimMapping;
        String spRoleClaimUri = appConfig.getRoleClaim();
        if (StringUtils.isEmpty((String)spRoleClaimUri) && MapUtils.isNotEmpty(spToLocalClaimMapping = appConfig.getClaimMappings())) {
            for (Map.Entry<String, String> entry : spToLocalClaimMapping.entrySet()) {
                if (!"http://wso2.org/claims/role".equals(entry.getValue())) continue;
                spRoleClaimUri = entry.getKey();
                break;
            }
        }
        if (StringUtils.isEmpty((String)spRoleClaimUri)) {
            spRoleClaimUri = "http://wso2.org/claims/role";
            if (log.isDebugEnabled()) {
                String serviceProvider = appConfig.getApplicationName();
                log.debug((Object)("Service Provider Role Claim URI not configured for SP: " + serviceProvider + ". Defaulting to " + spRoleClaimUri));
            }
        }
        return spRoleClaimUri;
    }
}

